/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.lavaplayer.extensions.format.xm;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.filter.AudioPipeline;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.filter.AudioPipelineFactory;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.filter.PcmFormat;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import dev.felnull.imp.include.ibxm.IBXM;

public class XmTrackProvider {
    private final IBXM ibxm;
    private final AudioPipeline downstream;
    private final int blocksInBuffer;

    public XmTrackProvider(AudioProcessingContext context, IBXM ibxm) {
        this.ibxm = ibxm;
        this.downstream = AudioPipelineFactory.create(context, new PcmFormat(2, ibxm.getSampleRate()));
        this.blocksInBuffer = ibxm.getMixBufferLength();
    }

    public void provideFrames() throws InterruptedException {
        int blockCount;
        int[] buffer = new int[this.blocksInBuffer];
        short[] shortBuffer = new short[this.blocksInBuffer];
        while ((blockCount = this.ibxm.getAudio(buffer)) > 0) {
            for (int i = 0; i < this.blocksInBuffer; ++i) {
                shortBuffer[i] = (short)Math.max(Short.MIN_VALUE, Math.min(buffer[i], Short.MAX_VALUE));
            }
            this.downstream.process(shortBuffer, 0, blockCount * 2);
        }
    }

    public void close() {
        this.downstream.close();
    }
}

