/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.felnull.fnjl.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostRequest {
    @NotNull
    private final Consumer<OutputStream> body;
    @NotNull
    private final Map<String, String> headers;

    public PostRequest(@NotNull Consumer<OutputStream> body, @NotNull Map<String, String> headers, long length) {
        this.body = body;
        if (length >= 0L) {
            headers = new HashMap<String, String>(headers);
            headers.put("Content-Length", String.valueOf(length));
            headers = Collections.unmodifiableMap(headers);
        }
        this.headers = headers;
    }

    public PostRequest(@NotNull Consumer<OutputStream> body, @NotNull Map<String, String> headers) {
        this(body, headers, -1L);
    }

    @NotNull
    public Consumer<OutputStream> getBody() {
        return this.body;
    }

    @NotNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static PostRequest newRequest(Consumer<OutputStream> body, Map<String, String> headers, long length) {
        return new PostRequest(body, headers, length);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static PostRequest newRequest(@NotNull Consumer<OutputStream> body, Map<String, String> headers) {
        return new PostRequest(body, headers);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static PostRequest newRequest(@NotNull String bodyText, @NotNull Map<String, String> headers) {
        return PostRequest.newRequest(bodyText.getBytes(StandardCharsets.UTF_8), headers);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static PostRequest newRequest(byte[] bodyByte, @NotNull Map<String, String> headers) {
        return PostRequest.newRequest(out -> {
            try (BufferedOutputStream outst = new BufferedOutputStream((OutputStream)out);){
                outst.write(bodyByte);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, headers, bodyByte.length);
    }

    public static class HeaderBuilder {
        @NotNull
        private final Map<String, String> headerMap = new HashMap<String, String>();

        @Contract(value=" -> new")
        @NotNull
        public static HeaderBuilder newBuilder() {
            return new HeaderBuilder();
        }

        public Map<String, String> build() {
            return Collections.unmodifiableMap(this.headerMap);
        }

        public HeaderBuilder addHeader(@NotNull String key, @NotNull String entry) {
            this.headerMap.put(key, entry);
            return this;
        }

        public HeaderBuilder addHeader(@NotNull Map<String, String> headers) {
            this.headerMap.putAll(headers);
            return this;
        }

        public HeaderBuilder setLanguage(@NotNull String language) {
            this.addHeader("Accept-Language", language);
            return this;
        }

        public HeaderBuilder setContentType(@NotNull String contentType) {
            this.setContentType(contentType, null);
            return this;
        }

        public HeaderBuilder setContentType(@NotNull String contentType, @Nullable String charset) {
            this.addHeader("Content-Type", String.format("%s; ", contentType) + (charset != null ? String.format("charset=%s", charset) : ""));
            return this;
        }
    }
}

