/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.felnull.fnjl.io.watcher;

import dev.felnull.imp.include.dev.felnull.fnjl.io.watcher.FileSystemWatcher;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class FileSystemWatcherImpl
implements FileSystemWatcher {
    protected final WatchService watchService;
    protected final FileSystemWatcher.WatchEventListener watchEventListener;
    protected final Map<WatchKey, Path> watchKeyPath = new HashMap<WatchKey, Path>();
    private final Thread thread;

    protected FileSystemWatcherImpl(FileSystemWatcher.WatchEventListener watchEventListener, ThreadFactory threadFactory) throws IOException {
        this.watchService = FileSystems.getDefault().newWatchService();
        this.watchEventListener = watchEventListener;
        this.thread = threadFactory.newThread(this::run);
        this.thread.start();
    }

    protected FileSystemWatcherImpl(FileSystemWatcher.WatchEventListener watchEventListener, String name) throws IOException {
        this(watchEventListener, FileSystemWatcherImpl.defaultThreadFactory(name));
    }

    private void run() {
        try {
            this.loop();
        }
        finally {
            this.destroy();
        }
    }

    private void loop() {
        while (true) {
            try {
                while (true) {
                    WatchKey take = this.watchService.take();
                    for (WatchEvent<Path> watchEvent : take.pollEvents()) {
                        Object co = watchEvent.context();
                        if (!(co instanceof Path)) continue;
                        this.onEvent(take, watchEvent, watchEvent.count());
                    }
                    take.reset();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public void stop() {
        this.thread.interrupt();
    }

    protected void destroy() {
        this.watchKeyPath.clear();
        try {
            this.watchService.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void onEvent(WatchKey key, WatchEvent<Path> watchEvent, int count) {
        this.watchEventListener.onWatchEvent(watchEvent, this.getPath(key, watchEvent));
    }

    private static ThreadFactory defaultThreadFactory(String name) {
        return r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName(name);
            return t;
        };
    }

    protected Path getPath(WatchKey key, WatchEvent<Path> watchEvent) {
        return this.watchKeyPath.get(key).resolve(watchEvent.context().toString());
    }
}

