/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.tectonic.util;

import com.dfsek.tectonic.api.exception.ReflectiveAccessException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ReflectionUtil {
    private static final Map<Class<?>, Class<?>> PRIMITIVES = new HashMap();

    public static Field[] getFields(@NotNull Class<?> type) {
        Field[] result = type.getDeclaredFields();
        Class<?> parentClass = type.getSuperclass();
        if (parentClass != null) {
            result = (Field[])Stream.concat(Arrays.stream(result), Arrays.stream(ReflectionUtil.getFields(parentClass))).toArray(Field[]::new);
        }
        return result;
    }

    public static <T> T cast(Class<T> clazz, Object object) {
        return PRIMITIVES.getOrDefault(clazz, clazz).cast(object);
    }

    public static void setField(Field field, Object target, Object value) throws ReflectiveAccessException {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new ReflectiveAccessException("Failed to set field " + field + ".", e);
        }
    }

    static {
        PRIMITIVES.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES.put(Byte.TYPE, Byte.class);
        PRIMITIVES.put(Short.TYPE, Short.class);
        PRIMITIVES.put(Character.TYPE, Character.class);
        PRIMITIVES.put(Integer.TYPE, Integer.class);
        PRIMITIVES.put(Long.TYPE, Long.class);
        PRIMITIVES.put(Float.TYPE, Float.class);
        PRIMITIVES.put(Double.TYPE, Double.class);
        PRIMITIVES.put(Void.TYPE, Void.class);
    }
}

