/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_768;
import org.lwjgl.opengl.GL11;

public class GhostIngredientDrag<T> {
    private static final int targetColor = 1075038474;
    private static final int hoverColor = -2142451431;
    private final IGhostIngredientHandler<?> handler;
    private final List<IGhostIngredientHandler.Target<T>> targets;
    private final List<class_768> targetAreas;
    private final IIngredientRenderer<T> ingredientRenderer;
    private final ITypedIngredient<T> ingredient;
    private final double mouseStartX;
    private final double mouseStartY;
    private final ImmutableRect2i origin;

    public GhostIngredientDrag(IGhostIngredientHandler<?> handler, List<IGhostIngredientHandler.Target<T>> targets, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> ingredient, double mouseX, double mouseY, ImmutableRect2i origin) {
        this.handler = handler;
        this.targets = targets;
        this.targetAreas = targets.stream().map(IGhostIngredientHandler.Target::getArea).toList();
        this.ingredientRenderer = ingredientRenderer;
        this.ingredient = ingredient;
        this.origin = origin;
        this.mouseStartX = mouseX;
        this.mouseStartY = mouseY;
    }

    public void drawTargets(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.handler.shouldHighlightTargets()) {
            GhostIngredientDrag.drawTargets(guiGraphics, mouseX, mouseY, this.targetAreas);
        }
    }

    public static boolean farEnoughToDraw(GhostIngredientDrag<?> drag, double mouseX, double mouseY) {
        ImmutableRect2i origin = drag.getOrigin();
        class_241 center = origin.isEmpty() ? new class_241((float)drag.mouseStartX, (float)drag.mouseStartY) : new class_241((float)origin.getX() + (float)origin.getWidth() / 2.0f, (float)origin.getY() + (float)origin.getHeight() / 2.0f);
        double mouseXDist = (double)center.field_1343 - mouseX;
        double mouseYDist = (double)center.field_1342 - mouseY;
        double mouseDistSq = mouseXDist * mouseXDist + mouseYDist * mouseYDist;
        return mouseDistSq > 64.0;
    }

    public void drawItem(class_332 guiGraphics, int mouseX, int mouseY) {
        if (!GhostIngredientDrag.farEnoughToDraw(this, mouseX, mouseY)) {
            return;
        }
        if (!this.origin.isEmpty()) {
            int originX = this.origin.getX() + this.origin.getWidth() / 2;
            int originY = this.origin.getY() + this.origin.getHeight() / 2;
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            class_5944 oldShader = RenderSystem.getShader();
            RenderSystem.setShader(class_757::method_34540);
            GL11.glEnable((int)2848);
            GL11.glHint((int)3154, (int)4354);
            class_289 tesselator = RenderSystem.renderThreadTesselator();
            class_287 builder = tesselator.method_1349();
            builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
            float red = 0.2509804f;
            float green = 0.07450981f;
            float blue = 0.7882353f;
            float alpha = 0.039215688f;
            builder.method_22912((double)mouseX, (double)mouseY, 150.0).method_22915(red, green, blue, alpha).method_1344();
            builder.method_22912((double)originX, (double)originY, 150.0).method_22915(red, green, blue, alpha).method_1344();
            tesselator.method_1350();
            RenderSystem.setShader(() -> oldShader);
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)(mouseX - 8), (float)(mouseY - 8), 0.0f);
        this.ingredientRenderer.render(guiGraphics, this.ingredient.getIngredient());
        poseStack.method_22909();
    }

    public static void drawTargets(class_332 guiGraphics, int mouseX, int mouseY, List<class_768> targetAreas) {
        RenderSystem.disableDepthTest();
        for (class_768 area : targetAreas) {
            int color = MathUtil.contains(area, mouseX, mouseY) ? -2142451431 : 1075038474;
            guiGraphics.method_51739(class_1921.method_51785(), area.method_3321(), area.method_3322(), area.method_3321() + area.method_3319(), area.method_3322() + area.method_3320(), color);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean onClick(UserInput input) {
        for (IGhostIngredientHandler.Target<T> target : this.targets) {
            class_768 area = target.getArea();
            if (!MathUtil.contains(area, input.getMouseX(), input.getMouseY())) continue;
            if (!input.isSimulate()) {
                target.accept(this.ingredient.getIngredient());
                this.handler.onComplete();
            }
            return true;
        }
        if (!input.isSimulate()) {
            this.handler.onComplete();
        }
        return false;
    }

    public void stop() {
        this.handler.onComplete();
    }

    public IIngredientRenderer<T> getIngredientRenderer() {
        return this.ingredientRenderer;
    }

    public ITypedIngredient<T> getIngredient() {
        return this.ingredient;
    }

    public ImmutableRect2i getOrigin() {
        return this.origin;
    }
}

