/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.util.Translator;
import mezz.jei.gui.ingredients.IListElement;
import mezz.jei.gui.ingredients.IListElementInfo;
import mezz.jei.gui.ingredients.IngredientInformationUtil;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListElementInfo<V>
implements IListElementInfo<V> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    private final IListElement<V> element;
    private final String displayNameLowercase;
    private final List<String> modIds;
    private final List<String> modNames;
    private final class_2960 resourceLocation;
    private int sortedIndex = Integer.MAX_VALUE;

    public static <V> Optional<IListElementInfo<V>> create(IListElement<V> element, IIngredientManager ingredientManager, IModIdHelper modIdHelper) {
        ITypedIngredient<V> value = element.getTypedIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        try {
            ListElementInfo<V> info = new ListElementInfo<V>(element, ingredientHelper, modIdHelper);
            return Optional.of(info);
        }
        catch (RuntimeException e) {
            try {
                String ingredientInfo = ingredientHelper.getErrorInfo(value.getIngredient());
                LOGGER.warn("Found a broken ingredient {}", (Object)ingredientInfo, (Object)e);
            }
            catch (RuntimeException e2) {
                LOGGER.warn("Found a broken ingredient.", (Throwable)e2);
            }
            return Optional.empty();
        }
    }

    protected ListElementInfo(IListElement<V> element, IIngredientHelper<V> ingredientHelper, IModIdHelper modIdHelper) {
        this.element = element;
        ITypedIngredient<V> value = element.getTypedIngredient();
        V ingredient = value.getIngredient();
        this.resourceLocation = ingredientHelper.getResourceLocation(ingredient);
        String displayModId = ingredientHelper.getDisplayModId(ingredient);
        String modId = this.resourceLocation.method_12836();
        this.modIds = new ArrayList<String>();
        this.modIds.add(displayModId);
        if (!modId.equals(displayModId)) {
            this.modIds.add(modId);
        }
        this.modNames = this.modIds.stream().map(modIdHelper::getModNameForModId).toList();
        String displayName = IngredientInformationUtil.getDisplayName(ingredient, ingredientHelper);
        this.displayNameLowercase = Translator.toLowercaseWithLocale(displayName);
    }

    @Override
    public String getName() {
        return this.displayNameLowercase;
    }

    @Override
    public String getModNameForSorting() {
        return this.modNames.get(0);
    }

    @Override
    public Set<String> getModNameStrings() {
        HashSet<String> modNameStrings = new HashSet<String>();
        for (int i = 0; i < this.modIds.size(); ++i) {
            String modId = this.modIds.get(i);
            String modName = this.modNames.get(i);
            ListElementInfo.addModNameStrings(modNameStrings, modId, modName);
        }
        return modNameStrings;
    }

    private static void addModNameStrings(Set<String> modNames, String modId, String modName) {
        String modNameLowercase = modName.toLowerCase(Locale.ENGLISH);
        String modNameNoSpaces = SPACE_PATTERN.matcher(modNameLowercase).replaceAll("");
        String modIdNoSpaces = SPACE_PATTERN.matcher(modId).replaceAll("");
        modNames.add(modId);
        modNames.add(modNameNoSpaces);
        modNames.add(modIdNoSpaces);
    }

    @Override
    public final List<String> getTooltipStrings(IIngredientFilterConfig config, IIngredientManager ingredientManager) {
        String modName = this.modNames.get(0);
        String modId = this.modIds.get(0);
        String modNameLowercase = modName.toLowerCase(Locale.ENGLISH);
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientRenderer<V> ingredientRenderer = ingredientManager.getIngredientRenderer(value.getType());
        ImmutableSet toRemove = ImmutableSet.of((Object)modId, (Object)modNameLowercase, (Object)this.displayNameLowercase, (Object)this.resourceLocation.method_12832());
        return IngredientInformationUtil.getTooltipStrings(value.getIngredient(), ingredientRenderer, (Set<String>)toRemove, config);
    }

    @Override
    public Collection<String> getTagStrings(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        return ingredientHelper.getTagStream(value.getIngredient()).map(class_2960::method_12832).toList();
    }

    @Override
    public Stream<class_2960> getTagIds(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        return ingredientHelper.getTagStream(value.getIngredient());
    }

    @Override
    public Iterable<Integer> getColors(IIngredientManager ingredientManager) {
        ITypedIngredient<V> value = this.element.getTypedIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        V ingredient = value.getIngredient();
        return ingredientHelper.getColors(ingredient);
    }

    @Override
    public class_2960 getResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    public IListElement<V> getElement() {
        return this.element;
    }

    @Override
    public ITypedIngredient<V> getTypedIngredient() {
        return this.element.getTypedIngredient();
    }

    @Override
    public void setSortedIndex(int sortIndex) {
        this.sortedIndex = sortIndex;
    }

    @Override
    public int getSortedIndex() {
        return this.sortedIndex;
    }
}

