/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.compat.journeymap;

import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_310;

public enum UsernameUtils {
    INSTANCE;

    private final HashMap<UUID, String> uuidNameMap = new HashMap();
    private final Set<UUID> tried = new HashSet<UUID>();
    private static final String url = "https://sessionserver.mojang.com/session/minecraft/profile/";

    public String getName(UUID uuid) {
        if (uuid == null) {
            return "Unknown";
        }
        if (!this.uuidNameMap.containsKey(uuid)) {
            if (class_310.method_1551().method_1548().method_1673().equals(uuid.toString())) {
                this.uuidNameMap.put(uuid, class_310.method_1551().method_1548().method_1676());
                return this.uuidNameMap.get(uuid);
            }
            if (!this.tried.contains(uuid)) {
                CompletableFuture.runAsync(() -> {
                    HttpClient client = HttpClient.newHttpClient();
                    HttpRequest request = HttpRequest.newBuilder(URI.create(url + uuid.toString().replace("-", ""))).GET().build();
                    try {
                        String body = client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).join().body();
                        this.uuidNameMap.put(uuid, JsonParser.parseString((String)body).getAsJsonObject().get("name").getAsString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                this.tried.add(uuid);
            }
            return "Unknown Player";
        }
        return this.uuidNameMap.get(uuid);
    }
}

