/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.selection_menu;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.content.custom_bogeys.selection_menu.RadialBogeyCategoryMenu;
import com.railwayteam.railways.registry.CRBogeyStyles;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.EntityUtils;
import com.railwayteam.railways.util.Utils;
import com.railwayteam.railways.util.packet.BogeyStyleSelectionPacket;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.AllKeys;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.utility.Pair;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BogeyCategoryHandlerClient {
    static final class_2960 FAVORITES_CATEGORY = Railways.asResource("favorites_category");
    static final class_2960 MANAGE_FAVORITES_CATEGORY = Railways.asResource("manage_favorites_category");
    private static final Map<class_2960, NonNullSupplier<? extends class_1935>> STYLE_CATEGORIES = new HashMap<class_2960, NonNullSupplier<? extends class_1935>>();
    private static final List<class_2960> STYLE_CATEGORY_ORDER = new ArrayList<class_2960>();
    static int COOLDOWN = 0;
    @Nullable
    private static BogeyStyle selectedStyle;
    @Nullable
    private static BogeySizes.BogeySize selectedSize;
    @Nullable
    private static List<BogeyStyle> favorites;
    public static final Map<Pair<BogeyStyle, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable BogeySizes.BogeySize>, class_2960> ICONS;

    public static class_2960 getCategoryId(int i) {
        if (i == 0) {
            return FAVORITES_CATEGORY;
        }
        return STYLE_CATEGORY_ORDER.get(i - 1);
    }

    public static int categoryCount() {
        return STYLE_CATEGORIES.size() + 1;
    }

    public static NonNullSupplier<? extends class_1935> getCategoryIcon(class_2960 id) {
        if (id == FAVORITES_CATEGORY) {
            return () -> class_1802.field_8367;
        }
        return STYLE_CATEGORIES.get(id);
    }

    public static NonNullSupplier<? extends class_1935> getCategoryIcon(int i) {
        return BogeyCategoryHandlerClient.getCategoryIcon(BogeyCategoryHandlerClient.getCategoryId(i));
    }

    public static Map<class_2960, BogeyStyle> getStylesInCategory(int i) {
        return BogeyCategoryHandlerClient.getStylesInCategory(BogeyCategoryHandlerClient.getCategoryId(i));
    }

    private static Map<class_2960, BogeyStyle> filterHidden(Map<class_2960, BogeyStyle> orig, boolean copyFirst) {
        if (orig.isEmpty()) {
            return orig;
        }
        Map<class_2960, BogeyStyle> map = copyFirst ? new HashMap<class_2960, BogeyStyle>(orig) : orig;
        map.entrySet().removeIf(entry -> CRBogeyStyles.hideInSelectionMenu((BogeyStyle)entry.getValue()));
        return map;
    }

    public static Map<class_2960, BogeyStyle> getStylesInCategory(class_2960 id) {
        if (id == MANAGE_FAVORITES_CATEGORY || id == FAVORITES_CATEGORY) {
            HashMap<class_2960, BogeyStyle> map = new HashMap<class_2960, BogeyStyle>();
            for (BogeyStyle style : BogeyCategoryHandlerClient.getFavorites()) {
                map.put(style.name, style);
            }
            return map;
        }
        if (Mods.EXTENDEDBOGEYS.isLoaded) {
            if (id.equals((Object)Railways.asResource("extendedbogeys"))) {
                HashMap<class_2960, BogeyStyle> EB = new HashMap<class_2960, BogeyStyle>((Map)AllBogeyStyles.CYCLE_GROUPS.get(Create.asResource((String)"standard")));
                EB.remove(AllBogeyStyles.STANDARD.name);
                EB.remove(CRBogeyStyles.INVISIBLE.name);
                EB.remove(CRBogeyStyles.WIDE_DEFAULT.name);
                EB.remove(CRBogeyStyles.NARROW_DEFAULT.name);
                EB.remove(CRBogeyStyles.NARROW_DOUBLE_SCOTCH.name);
                return BogeyCategoryHandlerClient.filterHidden(EB, false);
            }
            if (id.equals((Object)Create.asResource((String)"standard"))) {
                HashMap<class_2960, BogeyStyle> noEB = new HashMap<class_2960, BogeyStyle>((Map)AllBogeyStyles.CYCLE_GROUPS.get(Create.asResource((String)"standard")));
                noEB.remove(new class_2960("extendedbogeys", "single_axle"));
                noEB.remove(new class_2960("extendedbogeys", "double_axle"));
                noEB.remove(new class_2960("extendedbogeys", "triple_axle"));
                return BogeyCategoryHandlerClient.filterHidden(noEB, false);
            }
        }
        return BogeyCategoryHandlerClient.filterHidden(AllBogeyStyles.CYCLE_GROUPS.getOrDefault(id, new HashMap()), true);
    }

    public static class_2960 getStyleId(class_2960 categoryId, int styleIdx) {
        if (categoryId == MANAGE_FAVORITES_CATEGORY) {
            return BogeyCategoryHandlerClient.getFavorites().get((int)styleIdx).name;
        }
        return ((class_2960[])BogeyCategoryHandlerClient.getStylesInCategory(categoryId).keySet().toArray(class_2960[]::new))[styleIdx];
    }

    public static BogeyStyle getStyle(int categoryIdx, int styleIdx) {
        return BogeyCategoryHandlerClient.getStyle(BogeyCategoryHandlerClient.getCategoryId(categoryIdx), styleIdx);
    }

    public static BogeyStyle getStyle(class_2960 categoryId, int styleIdx) {
        int offset = 0;
        for (int i = 0; i < BogeyCategoryHandlerClient.styleCount(categoryId); ++i) {
            BogeyStyle style = BogeyCategoryHandlerClient.getStylesInCategory(categoryId).get(BogeyCategoryHandlerClient.getStyleId(categoryId, i));
            if (!BogeyCategoryHandlerClient.showIndividualSizes(style)) {
                if (i + offset != styleIdx) continue;
                return style;
            }
            for (int sizeIdx = 0; sizeIdx < style.validSizes().size(); ++sizeIdx) {
                if (i + offset + sizeIdx != styleIdx) continue;
                return style;
            }
            offset += style.validSizes().size() - 1;
        }
        if (Utils.isDevEnv()) {
            Railways.LOGGER.error("getStyle failed! category: " + categoryId + ", styleIdx: " + styleIdx);
        }
        return BogeyCategoryHandlerClient.getStylesInCategory(categoryId).get(BogeyCategoryHandlerClient.getStyleId(categoryId, styleIdx));
    }

    @Nullable
    public static BogeySizes.BogeySize getSize(class_2960 categoryId, int styleIdx) {
        int offset = 0;
        for (int i = 0; i < BogeyCategoryHandlerClient.styleCount(categoryId); ++i) {
            BogeyStyle style = BogeyCategoryHandlerClient.getStylesInCategory(categoryId).get(BogeyCategoryHandlerClient.getStyleId(categoryId, i));
            if (!BogeyCategoryHandlerClient.showIndividualSizes(style)) {
                if (i + offset != styleIdx) continue;
                return null;
            }
            int sizeIdx = 0;
            for (BogeySizes.BogeySize size : style.validSizes()) {
                if (i + offset + sizeIdx == styleIdx) {
                    return size;
                }
                ++sizeIdx;
            }
            offset += style.validSizes().size() - 1;
        }
        if (Utils.isDevEnv()) {
            Railways.LOGGER.error("getStyle failed! category: " + categoryId + ", styleIdx: " + styleIdx);
        }
        return null;
    }

    public static int styleCount(class_2960 categoryId) {
        if (categoryId == MANAGE_FAVORITES_CATEGORY) {
            return BogeyCategoryHandlerClient.styleAndSizeCount(BogeyCategoryHandlerClient.getFavorites());
        }
        return BogeyCategoryHandlerClient.styleAndSizeCount(BogeyCategoryHandlerClient.getStylesInCategory(categoryId).values());
    }

    private static int styleAndSizeCount(Collection<BogeyStyle> styles) {
        int count = 0;
        for (BogeyStyle style : styles) {
            count += BogeyCategoryHandlerClient.showIndividualSizes(style) ? style.validSizes().size() : 1;
        }
        return count;
    }

    public static void registerStyleCategory(String name, NonNullSupplier<? extends class_1935> icon) {
        BogeyCategoryHandlerClient.registerStyleCategory(Railways.asResource(name), icon);
    }

    public static void registerStyleCategory(class_2960 id, NonNullSupplier<? extends class_1935> icon) {
        STYLE_CATEGORIES.put(id, icon);
        STYLE_CATEGORY_ORDER.add(id);
    }

    @Nullable
    public static BogeyStyle getSelectedStyle() {
        return selectedStyle;
    }

    @Nullable
    public static BogeySizes.BogeySize getSelectedSize() {
        return selectedSize;
    }

    static void setSelectedStyle(@Nullable BogeyStyle style, @Nullable BogeySizes.BogeySize size) {
        if (selectedStyle == style && selectedSize == size) {
            return;
        }
        selectedStyle = style;
        selectedSize = size;
        if (style == null) {
            style = AllBogeyStyles.STANDARD;
        }
        CRPackets.PACKETS.send(new BogeyStyleSelectionPacket(style, size));
    }

    @NotNull
    static List<BogeyStyle> getFavorites() {
        if (favorites == null) {
            BogeyCategoryHandlerClient.loadFavorites();
        }
        return favorites;
    }

    static void optimizeFavorites() {
        ArrayList<BogeyStyle> newFavorites = new ArrayList<BogeyStyle>();
        for (BogeyStyle style : BogeyCategoryHandlerClient.getFavorites()) {
            if (newFavorites.contains(style)) continue;
            newFavorites.add(style);
        }
        favorites = newFavorites;
        BogeyCategoryHandlerClient.saveFavorites();
    }

    public static void loadFavorites() {
        favorites = new ArrayList<BogeyStyle>();
        try {
            class_310 mc = class_310.method_1551();
            File file = new File(mc.field_1697, "snr_favorite_styles.nbt");
            class_2487 tag = class_2507.method_10633((File)file);
            if (tag == null) {
                return;
            }
            if (tag.method_10573("Favorites", 9)) {
                class_2499 favoritesList = tag.method_10554("Favorites", 8);
                if (favorites == null) {
                    favorites = new ArrayList<BogeyStyle>();
                }
                favorites.clear();
                for (class_2520 favoriteTag : favoritesList) {
                    class_2519 stringTag;
                    class_2960 loc;
                    if (!(favoriteTag instanceof class_2519) || (loc = class_2960.method_12829((String)(stringTag = (class_2519)favoriteTag).method_10714())) == null || !AllBogeyStyles.BOGEY_STYLES.containsKey(loc)) continue;
                    favorites.add((BogeyStyle)AllBogeyStyles.BOGEY_STYLES.get(loc));
                }
            }
            BogeyCategoryHandlerClient.optimizeFavorites();
        }
        catch (Exception e) {
            Railways.LOGGER.error("Failed to load favorite styles", (Throwable)e);
        }
    }

    public static boolean showIndividualSizes(BogeyStyle style) {
        return style.name.method_12836().equals("extendedbogeys") && style.name.method_12832().equals("double_axle");
    }

    public static void saveFavorites() {
        if (favorites == null) {
            return;
        }
        try {
            class_2487 tag = new class_2487();
            class_2499 listTag = new class_2499();
            for (BogeyStyle style : favorites) {
                listTag.add((Object)class_2519.method_23256((String)style.name.toString()));
            }
            tag.method_10566("Favorites", (class_2520)listTag);
            class_2507.method_10630((class_2487)tag, (File)new File(class_310.method_1551().field_1697, "snr_favorite_styles.nbt"));
        }
        catch (Exception e) {
            Railways.LOGGER.error("Failed to save favorite styles", (Throwable)e);
        }
    }

    public static void clientTick() {
        if (COOLDOWN > 0 && !AllKeys.TOOL_MENU.isPressed()) {
            --COOLDOWN;
        }
    }

    public static void onKeyInput(int key, boolean pressed) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1761 == null || mc.field_1761.method_2920() == class_1934.field_9219) {
            return;
        }
        if (key != AllKeys.TOOL_MENU.getBoundCode() || !pressed) {
            return;
        }
        if (COOLDOWN > 0) {
            return;
        }
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        class_1937 level = player.field_6002;
        if (!EntityUtils.isHolding((class_1657)player, arg_0 -> ((BlockEntry)AllBlocks.RAILWAY_CASING).isIn(arg_0))) {
            return;
        }
        ScreenOpener.open((class_437)new RadialBogeyCategoryMenu(RadialBogeyCategoryMenu.State.PICK_CATEGORY));
    }

    public static void addIcon(BogeyStyle style, String name) {
        ICONS.put((Pair<BogeyStyle, BogeySizes.BogeySize>)Pair.of((Object)style, null), Railways.asResource("textures/gui/bogey_icons/" + name + "_icon.png"));
    }

    public static void addIcon(BogeyStyle style, BogeySizes.BogeySize size, String name) {
        if (!BogeyCategoryHandlerClient.showIndividualSizes(style)) {
            if (Utils.isDevEnv()) {
                throw new IllegalStateException("Cannot add sized icon for style that does not show individual sizes");
            }
            BogeyCategoryHandlerClient.addIcon(style, name);
            return;
        }
        ICONS.put((Pair<BogeyStyle, BogeySizes.BogeySize>)Pair.of((Object)style, (Object)size), Railways.asResource("textures/gui/bogey_icons/" + name + "_icon.png"));
    }

    public static boolean hasIcon(BogeyStyle style, BogeySizes.BogeySize size) {
        return BogeyCategoryHandlerClient.showIndividualSizes(style) && ICONS.containsKey(Pair.of((Object)style, (Object)size)) || ICONS.containsKey(Pair.of((Object)style, null));
    }

    public static class_2960 getIcon(BogeyStyle style, BogeySizes.BogeySize size) {
        if (BogeyCategoryHandlerClient.showIndividualSizes(style) && ICONS.containsKey(Pair.of((Object)style, (Object)size))) {
            return ICONS.get(Pair.of((Object)style, (Object)size));
        }
        return ICONS.get(Pair.of((Object)style, null));
    }

    static {
        favorites = null;
        ICONS = new HashMap<Pair<BogeyStyle, BogeySizes.BogeySize>, class_2960>();
        for (BogeyStyle style : AllBogeyStyles.BOGEY_STYLES.values()) {
            if (CRBogeyStyles.hideInSelectionMenu(style)) continue;
            if (style.name.method_12836().equals("railways")) {
                BogeyCategoryHandlerClient.addIcon(style, style.name.method_12832());
                continue;
            }
            if (!Mods.EXTENDEDBOGEYS.isLoaded || !style.name.method_12836().equals("extendedbogeys")) continue;
            BogeyCategoryHandlerClient.addIcon(style, "eb_" + style.name.method_12832());
        }
        BogeyCategoryHandlerClient.addIcon(AllBogeyStyles.STANDARD, "default");
    }
}

