/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.andromeda.client;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import me.melontini.andromeda.Andromeda;
import me.melontini.andromeda.client.particles.KnockoffTotemParticle;
import me.melontini.andromeda.client.render.BoatWithBlockRenderer;
import me.melontini.andromeda.client.render.FlyingItemEntityRenderer;
import me.melontini.andromeda.client.render.block.IncubatorBlockRenderer;
import me.melontini.andromeda.client.screens.FletchingScreen;
import me.melontini.andromeda.client.screens.MerchantInventoryScreen;
import me.melontini.andromeda.config.AndromedaConfig;
import me.melontini.andromeda.config.AndromedaFeatureManager;
import me.melontini.andromeda.networks.ClientSideNetworking;
import me.melontini.andromeda.registries.BlockRegistry;
import me.melontini.andromeda.registries.EntityTypeRegistry;
import me.melontini.andromeda.registries.ScreenHandlerRegistry;
import me.melontini.andromeda.util.AndromedaLog;
import me.melontini.andromeda.util.AndromedaReporter;
import me.melontini.andromeda.util.SharedConstants;
import me.melontini.andromeda.util.annotations.config.FeatureEnvironment;
import me.melontini.andromeda.util.translations.TranslationUpdater;
import me.melontini.dark_matter.api.analytics.MessageHandler;
import me.melontini.dark_matter.api.base.util.MathStuff;
import me.melontini.dark_matter.api.base.util.Utilities;
import me.melontini.dark_matter.api.glitter.ScreenParticleHelper;
import me.melontini.dark_matter.api.minecraft.client.util.DrawUtil;
import me.melontini.dark_matter.api.minecraft.util.TextUtil;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1720;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3865;
import net.minecraft.class_3929;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_489;
import net.minecraft.class_5602;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_925;
import org.apache.commons.lang3.ArrayUtils;

@Environment(value=EnvType.CLIENT)
public class AndromedaClient
implements ClientModInitializer {
    public static final class_2960 WIKI_BUTTON_TEXTURE = new class_2960("andromeda", "textures/gui/wiki_button.png");
    public static final class_2583 WIKI_LINK = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://andromeda-wiki.pages.dev/"));
    public static String DEBUG_SPLASH;
    private static class_1799 frameStack;
    private float tooltipFlow;
    private float oldTooltipFlow;

    public void onInitializeClient() {
        GuiRegistry registry = AutoConfig.getGuiRegistry(AndromedaConfig.class);
        registry.registerPredicateTransformer((list, s, field, o, o1, guiRegistryAccess) -> list.stream().peek(gui -> {
            gui.setRequirement(() -> !AndromedaFeatureManager.isModified(field));
            if (gui instanceof TooltipListEntry) {
                TooltipListEntry tooltipGui = (TooltipListEntry)gui;
                if ("mod_json".equals(AndromedaFeatureManager.blameProcessor(field))) {
                    class_2561[] manager = new class_2561[]{TextUtil.translatable((String)"andromeda.config.tooltip.manager.mod_json", (Object[])new Object[]{Arrays.toString(AndromedaFeatureManager.blameMod(field))})};
                    tooltipGui.setTooltipSupplier(() -> Optional.of(manager));
                } else {
                    class_2561[] manager = new class_2561[]{TextUtil.translatable((String)("andromeda.config.tooltip.manager." + AndromedaFeatureManager.blameProcessor(field)))};
                    tooltipGui.setTooltipSupplier(() -> Optional.of(manager));
                }
            }
        }).toList(), AndromedaFeatureManager::isModified);
        registry.registerPredicateTransformer((list, s, field, o, o1, guiRegistryAccess) -> {
            list.forEach(gui -> gui.setRequiresRestart(true));
            return list;
        }, field -> Andromeda.CONFIG.compatMode);
        registry.registerAnnotationTransformer((list, s, field, o, o1, guiRegistryAccess) -> {
            list.forEach(gui -> {
                if (gui instanceof TooltipListEntry) {
                    TooltipListEntry tooltipGui = (TooltipListEntry)gui;
                    FeatureEnvironment environment = field.getAnnotation(FeatureEnvironment.class);
                    if (tooltipGui.getTooltipSupplier() != null) {
                        Optional optional = (Optional)tooltipGui.getTooltipSupplier().get();
                        class_2561[] text = optional.map(texts -> (class_2561[])ArrayUtils.add((Object[])texts, (Object)TextUtil.translatable((String)("andromeda.config.tooltip.environment." + environment.value().toString().toLowerCase())))).orElseGet(() -> new class_2561[]{TextUtil.translatable((String)("andromeda.config.tooltip.environment." + environment.value().toString().toLowerCase()))});
                        tooltipGui.setTooltipSupplier(() -> Optional.of(text));
                    } else {
                        class_2561[] text = new class_2561[]{TextUtil.translatable((String)("andromeda.config.tooltip.environment." + environment.value().toString().toLowerCase()))};
                        tooltipGui.setTooltipSupplier(() -> Optional.of(text));
                    }
                }
            });
            return list;
        }, new Class[]{FeatureEnvironment.class});
        if (Andromeda.CONFIG.autoUpdateTranslations) {
            boolean shouldUpdate = true;
            if (Files.exists(TranslationUpdater.LANG_PATH.resolve("en_us.json"), new LinkOption[0])) {
                try {
                    FileTime lastModifiedTime = Files.getLastModifiedTime(TranslationUpdater.LANG_PATH.resolve("en_us.json"), new LinkOption[0]);
                    shouldUpdate = ChronoUnit.HOURS.between(lastModifiedTime.toInstant(), Instant.now()) >= 24L;
                }
                catch (Exception lastModifiedTime) {
                    // empty catch block
                }
            }
            if (!shouldUpdate) {
                shouldUpdate = SharedConstants.MOD_UPDATED;
            }
            if (shouldUpdate) {
                HashSet languages = Sets.newHashSet((Object[])new String[]{"en_us"});
                String s2 = TranslationUpdater.getSelectedLanguage();
                if (!s2.isEmpty()) {
                    languages.add(s2);
                }
                MessageHandler.EXECUTOR.submit(() -> TranslationUpdater.downloadTranslations(languages));
            } else {
                AndromedaLog.info("Skipped translations update.");
            }
        }
        ClientSideNetworking.register();
        this.registerEntityRenderers();
        this.registerBlockRenderers();
        this.inGameTooltips();
        ScreenEvents.BEFORE_INIT.register((client, screen1, scaledWidth, scaledHeight) -> {
            if (screen1 instanceof class_489) {
                class_489 abstractFurnaceScreen = (class_489)screen1;
                if (Andromeda.CONFIG.guiParticles.furnaceScreenParticles) {
                    ScreenEvents.afterTick((class_437)abstractFurnaceScreen).register(screen -> {
                        class_489 furnaceScreen = (class_489)screen;
                        if (((class_1720)furnaceScreen.method_17577()).method_17365() && Utilities.RANDOM.nextInt(10) == 0) {
                            ScreenParticleHelper.addScreenParticle((class_437)screen, (class_2394)class_2398.field_11240, (double)MathStuff.nextDouble((Random)Utilities.RANDOM, (double)(furnaceScreen.field_2776 + 56), (double)(furnaceScreen.field_2776 + 56 + 14)), (double)(furnaceScreen.field_2800 + 36 + 13), (double)MathStuff.nextDouble((Random)Utilities.RANDOM, (double)-0.01, (double)0.01), (double)0.05);
                        }
                    });
                }
            }
        });
        if (Andromeda.CONFIG.usefulFletching) {
            class_3929.method_17542(ScreenHandlerRegistry.FLETCHING_SCREEN_HANDLER, FletchingScreen::new);
        }
        class_3929.method_17542(ScreenHandlerRegistry.MERCHANT_INVENTORY_SCREEN_HANDLER, MerchantInventoryScreen::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)Andromeda.KNOCKOFF_TOTEM_PARTICLE, KnockoffTotemParticle.Factory::new);
        FabricLoader.getInstance().getModContainer("andromeda").ifPresent(modContainer -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960("andromeda", "dark"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.NORMAL));
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (Andromeda.CONFIG.itemFrameTooltips) {
                class_239 cast = client.field_1765;
                this.getCast(cast);
                this.oldTooltipFlow = this.tooltipFlow;
                this.tooltipFlow = !frameStack.method_7960() ? class_3532.method_16439((float)0.25f, (float)this.tooltipFlow, (float)1.0f) : class_3532.method_16439((float)0.1f, (float)this.tooltipFlow, (float)0.0f);
            }
        });
        AndromedaReporter.handleUpload();
    }

    private void inGameTooltips() {
        HudRenderCallback.EVENT.register((context, delta) -> {
            if (Andromeda.CONFIG.itemFrameTooltips && class_310.method_1551().field_1755 == null) {
                class_310 client = class_310.method_1551();
                if (!frameStack.method_7960()) {
                    float flow = class_3532.method_16439((float)client.method_1488(), (float)this.oldTooltipFlow, (float)this.tooltipFlow);
                    class_4587 matrices = context.method_51448();
                    matrices.method_22903();
                    matrices.method_46416(0.0f, 0.0f, -450.0f);
                    matrices.method_22905(1.0f, 1.0f, 1.0f);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(flow, 0.8f));
                    List list = class_437.method_25408((class_310)class_310.method_1551(), (class_1799)frameStack);
                    List list1 = list.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(Collectors.toList());
                    frameStack.method_32347().ifPresent(datax -> list1.add(1, (class_5684)Utilities.supply(() -> {
                        class_5684 component = ((TooltipComponentCallback)TooltipComponentCallback.EVENT.invoker()).getComponent(datax);
                        if (component == null) {
                            component = class_5684.method_32663((class_5632)datax);
                        }
                        return component;
                    })));
                    int j = 0;
                    for (class_5684 tooltipComponent : list1) {
                        j += tooltipComponent.method_32661();
                    }
                    DrawUtil.renderTooltipFromComponents((class_332)context, list1, (float)((float)client.method_22683().method_4486() / 2.0f - flow * 15.0f + 15.0f), (float)((float)(client.method_22683().method_4502() - j) / 2.0f + 12.0f));
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.disableBlend();
                    matrices.method_22909();
                }
            }
        });
    }

    private void getCast(class_239 cast) {
        class_3966 hitResult;
        class_1297 class_12972;
        if (cast != null && cast.method_17783() == class_239.class_240.field_1331 && (class_12972 = (hitResult = (class_3966)cast).method_17782()) instanceof class_1533) {
            class_1533 itemFrameEntity = (class_1533)class_12972;
            frameStack = itemFrameEntity.method_6940();
            return;
        }
        frameStack = class_1799.field_8037;
    }

    public void registerBlockRenderers() {
        if (Andromeda.CONFIG.unknown) {
            BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23581(), new class_2248[]{BlockRegistry.ROSE_OF_THE_VALLEY});
        }
        if (Andromeda.CONFIG.incubatorSettings.enableIncubator) {
            BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23581(), new class_2248[]{BlockRegistry.INCUBATOR_BLOCK});
            BlockEntityRendererRegistry.register(BlockRegistry.INCUBATOR_BLOCK_ENTITY, IncubatorBlockRenderer::new);
        }
    }

    public void registerEntityRenderers() {
        if (Andromeda.CONFIG.newBoats.isFurnaceBoatOn) {
            EntityRendererRegistry.register(EntityTypeRegistry.BOAT_WITH_FURNACE, ctx -> new BoatWithBlockRenderer(ctx, (class_2680)class_2246.field_10181.method_9564().method_11657((class_2769)class_3865.field_11104, (Comparable)class_2350.field_11043)));
        }
        if (Andromeda.CONFIG.newBoats.isJukeboxBoatOn) {
            EntityRendererRegistry.register(EntityTypeRegistry.BOAT_WITH_JUKEBOX, ctx -> new BoatWithBlockRenderer(ctx, class_2246.field_10223.method_9564()));
        }
        if (Andromeda.CONFIG.newBoats.isTNTBoatOn) {
            EntityRendererRegistry.register(EntityTypeRegistry.BOAT_WITH_TNT, ctx -> new BoatWithBlockRenderer(ctx, class_2246.field_10375.method_9564()));
        }
        if (Andromeda.CONFIG.newBoats.isHopperBoatOn) {
            EntityRendererRegistry.register(EntityTypeRegistry.BOAT_WITH_HOPPER, ctx -> new BoatWithBlockRenderer(ctx, class_2246.field_10312.method_9564()));
        }
        if (Andromeda.CONFIG.newMinecarts.isAnvilMinecartOn) {
            EntityRendererRegistry.register(EntityTypeRegistry.ANVIL_MINECART_ENTITY, ctx -> new class_925(ctx, class_5602.field_27614));
        }
        if (Andromeda.CONFIG.newMinecarts.isNoteBlockMinecartOn) {
            EntityRendererRegistry.register(EntityTypeRegistry.NOTEBLOCK_MINECART_ENTITY, ctx -> new class_925(ctx, class_5602.field_27614));
        }
        if (Andromeda.CONFIG.newMinecarts.isJukeboxMinecartOn) {
            EntityRendererRegistry.register(EntityTypeRegistry.JUKEBOX_MINECART_ENTITY, ctx -> new class_925(ctx, class_5602.field_27614));
        }
        EntityRendererRegistry.register(EntityTypeRegistry.FLYING_ITEM, FlyingItemEntityRenderer::new);
    }

    static {
        frameStack = class_1799.field_8037;
    }
}

