/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.andromeda.content.managers;

import java.util.Optional;
import me.melontini.dark_matter.api.base.util.MakeSure;
import me.melontini.dark_matter.api.base.util.Utilities;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1922;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3986;
import net.minecraft.class_3989;
import net.minecraft.class_4153;
import net.minecraft.class_4538;
import net.minecraft.class_5268;
import net.minecraft.class_6908;
import net.minecraft.class_7477;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomTraderManager
extends class_18 {
    public int cooldown;

    public void readNbt(@NotNull class_2487 nbt) {
        MakeSure.notNull((Object)nbt);
        this.cooldown = nbt.method_10550("andromeda-trader-cooldown");
    }

    public class_2487 method_75(@NotNull class_2487 nbt) {
        MakeSure.notNull((Object)nbt);
        nbt.method_10569("andromeda-trader-cooldown", this.cooldown);
        return nbt;
    }

    public void tick() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    public void trySpawn(class_3218 world, class_5268 properties, class_1657 player) {
        MakeSure.notNulls((Object[])new Object[]{world, properties, player});
        if (this.cooldown == 0 && player != null) {
            class_2338 blockPos = player.method_24515();
            class_4153 pointOfInterestStorage = world.method_19494();
            Optional optional = pointOfInterestStorage.method_19127(registryEntry -> registryEntry.method_40225(class_7477.field_39292), pos -> true, blockPos, 48, class_4153.class_4155.field_18489);
            class_2338 blockPos2 = optional.orElse(blockPos);
            class_2338 blockPos3 = this.getNearbySpawnPos((class_4538)world, blockPos2, 48);
            if (blockPos3 != null && this.doesNotSuffocateAt((class_1922)world, blockPos3)) {
                if (world.method_23753(blockPos3).method_40220(class_6908.field_37383)) {
                    return;
                }
                class_3989 wanderingTraderEntity = (class_3989)class_1299.field_17713.method_47821(world, blockPos3, class_3730.field_16467);
                if (wanderingTraderEntity != null) {
                    this.cooldown = 48000;
                    for (int j = 0; j < 2; ++j) {
                        this.spawnLlama(world, wanderingTraderEntity);
                    }
                    properties.method_18040(wanderingTraderEntity.method_5667());
                    wanderingTraderEntity.method_18013(48000);
                    wanderingTraderEntity.method_18069(blockPos2);
                    wanderingTraderEntity.method_18408(blockPos2, 16);
                }
            }
        }
    }

    private void spawnLlama(class_3218 world, @NotNull class_3989 wanderingTrader) {
        class_3986 traderLlamaEntity;
        MakeSure.notNulls((Object[])new Object[]{world, wanderingTrader});
        class_2338 blockPos = this.getNearbySpawnPos((class_4538)world, wanderingTrader.method_24515(), 4);
        if (blockPos != null && (traderLlamaEntity = (class_3986)class_1299.field_17714.method_47821(world, blockPos, class_3730.field_16467)) != null) {
            traderLlamaEntity.method_5954((class_1297)wanderingTrader, true);
        }
    }

    @Nullable
    private class_2338 getNearbySpawnPos(class_4538 world, class_2338 pos, int range) {
        class_2338 blockPos = null;
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = pos.method_10263() + Utilities.RANDOM.nextInt(range * 2) - range;
            class_2338 blockPos2 = new class_2338(x, y = world.method_8624(class_2902.class_2903.field_13202, x, z = pos.method_10260() + Utilities.RANDOM.nextInt(range * 2) - range), z);
            if (!class_1948.method_8660((class_1317.class_1319)class_1317.class_1319.field_6317, (class_4538)world, (class_2338)blockPos2, (class_1299)class_1299.field_17713)) continue;
            blockPos = blockPos2;
            break;
        }
        return blockPos;
    }

    private boolean doesNotSuffocateAt(class_1922 world, class_2338 pos) {
        for (class_2338 blockPos : class_2338.method_10097((class_2338)pos, (class_2338)pos.method_10069(1, 2, 1))) {
            if (world.method_8320(blockPos).method_26220(world, blockPos).method_1110()) continue;
            return false;
        }
        return true;
    }
}

