/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.andromeda.content.throwable_items;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.melontini.andromeda.content.throwable_items.ItemBehavior;
import net.minecraft.class_1792;

public class ItemBehaviorManager {
    private static final Map<class_1792, Holder> ITEM_BEHAVIORS = new IdentityHashMap<class_1792, Holder>();
    private static final Object2IntOpenHashMap<class_1792> CUSTOM_COOLDOWNS = new Object2IntOpenHashMap();
    private static final Set<class_1792> OVERRIDE_VANILLA = new HashSet<class_1792>();

    public static List<ItemBehavior> getBehaviors(class_1792 item) {
        Holder holder = ITEM_BEHAVIORS.get(item);
        if (holder == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(holder.behaviors);
    }

    public static void addBehavior(class_1792 item, ItemBehavior behavior, boolean complement) {
        Holder holder = ITEM_BEHAVIORS.computeIfAbsent(item, Holder::new);
        holder.addBehavior(behavior, complement);
    }

    public static void addBehavior(class_1792 item, ItemBehavior behavior) {
        ItemBehaviorManager.addBehavior(item, behavior, true);
    }

    public static void addBehaviors(ItemBehavior behavior, boolean complement, class_1792 ... items) {
        for (class_1792 item : items) {
            ItemBehaviorManager.addBehavior(item, behavior, complement);
        }
    }

    public static void addBehaviors(ItemBehavior behavior, class_1792 ... items) {
        for (class_1792 item : items) {
            ItemBehaviorManager.addBehavior(item, behavior);
        }
    }

    public static boolean hasBehaviors(class_1792 item) {
        return ITEM_BEHAVIORS.containsKey(item);
    }

    public static void clear() {
        ITEM_BEHAVIORS.clear();
    }

    public static void overrideVanilla(class_1792 item) {
        OVERRIDE_VANILLA.add(item);
    }

    public static boolean overridesVanilla(class_1792 item) {
        return OVERRIDE_VANILLA.contains(item);
    }

    public static void addCustomCooldown(class_1792 item, int cooldown) {
        CUSTOM_COOLDOWNS.putIfAbsent((Object)item, cooldown);
    }

    public static void replaceCustomCooldown(class_1792 item, int cooldown) {
        CUSTOM_COOLDOWNS.put((Object)item, cooldown);
    }

    public static int getCooldown(class_1792 item) {
        return CUSTOM_COOLDOWNS.getOrDefault((Object)item, 50);
    }

    private static class Holder {
        final List<ItemBehavior> behaviors = new ArrayList<ItemBehavior>();
        private final class_1792 item;
        private boolean locked;

        public Holder(class_1792 item) {
            this.item = item;
        }

        public void addBehavior(ItemBehavior behavior, boolean complement) {
            if (!this.locked) {
                if (!complement) {
                    this.behaviors.clear();
                }
                this.behaviors.add(behavior);
                if (!complement) {
                    this.locked = true;
                }
            }
        }

        public class_1792 getItem() {
            return this.item;
        }
    }
}

