/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.andromeda.registries;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.melontini.andromeda.Andromeda;
import me.melontini.andromeda.config.AndromedaConfig;
import me.melontini.andromeda.content.throwable_items.ItemBehaviorAdder;
import me.melontini.andromeda.content.throwable_items.ItemBehaviorManager;
import me.melontini.andromeda.util.AndromedaLog;
import me.melontini.andromeda.util.data.EggProcessingData;
import me.melontini.andromeda.util.data.ItemBehaviorData;
import me.melontini.andromeda.util.data.PlantData;
import me.melontini.andromeda.util.exceptions.AndromedaException;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1299;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class ResourceConditionRegistry {
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void register() {
        ResourceConditions.register((class_2960)new class_2960("andromeda", "config_option"), object -> {
            JsonArray array = class_3518.method_15261((JsonObject)object, (String)"values");
            boolean load = true;
            for (JsonElement element : array) {
                if (!element.isJsonPrimitive()) continue;
                try {
                    String configOption = element.getAsString();
                    List<String> fields = Arrays.stream(configOption.split("\\.")).toList();
                    try {
                        if (fields.size() > 1) {
                            Object obj = AndromedaConfig.class.getField(fields.get(0)).get(Andromeda.CONFIG);
                            for (int i = 1; i < fields.size() - 1; ++i) {
                                obj = obj.getClass().getField(fields.get(i)).get(obj);
                            }
                            load = obj.getClass().getField(fields.get(1)).getBoolean(obj);
                        } else {
                            load = Andromeda.CONFIG.getClass().getField(configOption).getBoolean(Andromeda.CONFIG);
                        }
                    }
                    catch (NoSuchFieldException e) {
                        throw new AndromedaException("Invalid config option: " + configOption);
                    }
                    if (load) continue;
                    break;
                }
                catch (IllegalAccessException e) {
                    throw new AndromedaException("Exception while evaluating andromeda:config_option", (Throwable)e);
                }
            }
            return load;
        });
        ResourceConditions.register((class_2960)new class_2960("andromeda", "items_registered"), object -> {
            JsonArray array = class_3518.method_15261((JsonObject)object, (String)"values");
            for (JsonElement element : array) {
                if (!element.isJsonPrimitive() || class_7923.field_41178.method_10223(new class_2960(element.getAsString())) != class_1802.field_8162) continue;
                return false;
            }
            return true;
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("andromeda", "crop_temperatures");
            }

            public void method_14491(class_3300 manager) {
                Andromeda.PLANT_DATA.clear();
                Map map = manager.method_14488("am_crop_temperatures", identifier -> identifier.method_12832().endsWith(".json"));
                for (Map.Entry entry : map.entrySet()) {
                    try {
                        JsonObject jsonElement = class_3518.method_15255((Reader)new InputStreamReader(((class_3298)entry.getValue()).method_14482()));
                        PlantData data = (PlantData)GSON.fromJson((JsonElement)jsonElement, PlantData.class);
                        if (class_7923.field_41175.method_10223(class_2960.method_12829((String)data.identifier)) == class_2246.field_10124) {
                            throw new class_151(String.format("(Andromeda) invalid identifier provided! %s", data.identifier));
                        }
                        Andromeda.PLANT_DATA.putIfAbsent((class_2248)class_7923.field_41175.method_10223(class_2960.method_12829((String)data.identifier)), data);
                    }
                    catch (IOException e) {
                        AndromedaLog.error("Error while parsing JSON for am_crop_temperatures", e);
                    }
                }
            }
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("andromeda", "egg_processing");
            }

            public void method_14491(class_3300 manager) {
                Andromeda.EGG_DATA.clear();
                for (class_1792 item : class_7923.field_41178) {
                    if (!(item instanceof class_1826)) continue;
                    class_1826 spawnEggItem = (class_1826)item;
                    Andromeda.EGG_DATA.putIfAbsent((class_1792)spawnEggItem, new EggProcessingData(class_7923.field_41178.method_10221((Object)spawnEggItem).toString(), class_7923.field_41177.method_10221((Object)spawnEggItem.method_8015(new class_2487())).toString(), 8000));
                }
                Map map = manager.method_14488("am_egg_processing", identifier -> identifier.method_12832().endsWith(".json"));
                for (Map.Entry entry : map.entrySet()) {
                    try {
                        JsonObject jsonElement = class_3518.method_15255((Reader)new InputStreamReader(((class_3298)entry.getValue()).method_14482()));
                        EggProcessingData data = (EggProcessingData)GSON.fromJson((JsonElement)jsonElement, EggProcessingData.class);
                        if (class_7923.field_41177.method_10223(class_2960.method_12829((String)data.entity)) == class_1299.field_6093 && !Objects.equals(data.entity, "minecraft:pig")) {
                            throw new class_151(String.format("(Andromeda) invalid entity identifier provided! %s", data.entity));
                        }
                        if (class_7923.field_41178.method_10223(class_2960.method_12829((String)data.identifier)) == class_1802.field_8162) {
                            throw new class_151(String.format("(Andromeda) invalid item identifier provided! %s", data.identifier));
                        }
                        Andromeda.EGG_DATA.putIfAbsent((class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)data.identifier)), data);
                    }
                    catch (IOException e) {
                        AndromedaLog.error("Error while parsing JSON for am_egg_processing", e);
                    }
                }
            }
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("andromeda", "am_item_throw_behavior");
            }

            public void method_14491(class_3300 manager) {
                ItemBehaviorManager.clear();
                ItemBehaviorAdder.addDefaults();
                Map map = manager.method_14488("am_item_throw_behavior", identifier -> identifier.method_12832().endsWith(".json"));
                for (Map.Entry entry : map.entrySet()) {
                    try {
                        JsonObject json = class_3518.method_15255((Reader)new InputStreamReader(((class_3298)entry.getValue()).method_14482()));
                        ItemBehaviorData data = new ItemBehaviorData();
                        HashSet<class_1792> items = new HashSet<class_1792>();
                        if (!json.has("item_id")) {
                            throw new class_151("(Andromeda) missing item_id!");
                        }
                        JsonElement element = json.get("item_id");
                        if (element.isJsonArray()) {
                            for (JsonElement e : element.getAsJsonArray()) {
                                class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)e.getAsString()));
                                if (item == class_1802.field_8162) {
                                    throw new class_151(String.format("(Andromeda) invalid identifier provided! %s", item));
                                }
                                items.add(item);
                            }
                        } else {
                            class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)element.getAsString()));
                            if (item == class_1802.field_8162) {
                                throw new class_151(String.format("(Andromeda) invalid identifier provided! %s", item));
                            }
                            items.add(item);
                        }
                        data.on_entity_hit = new ItemBehaviorData.CommandHolder();
                        ResourceConditionRegistry.readCommands(class_3518.method_15281((JsonObject)json, (String)"on_entity_hit", (JsonObject)new JsonObject()), data.on_entity_hit);
                        data.on_block_hit = new ItemBehaviorData.CommandHolder();
                        ResourceConditionRegistry.readCommands(class_3518.method_15281((JsonObject)json, (String)"on_block_hit", (JsonObject)new JsonObject()), data.on_block_hit);
                        data.on_miss = new ItemBehaviorData.CommandHolder();
                        ResourceConditionRegistry.readCommands(class_3518.method_15281((JsonObject)json, (String)"on_miss", (JsonObject)new JsonObject()), data.on_miss);
                        data.on_any_hit = new ItemBehaviorData.CommandHolder();
                        ResourceConditionRegistry.readCommands(class_3518.method_15281((JsonObject)json, (String)"on_any_hit", (JsonObject)new JsonObject()), data.on_any_hit);
                        data.spawn_item_particles = class_3518.method_15258((JsonObject)json, (String)"spawn_item_particles", (boolean)true);
                        data.spawn_colored_particles = class_3518.method_15258((JsonObject)json, (String)"spawn_colored_particles", (boolean)false);
                        JsonObject colors = class_3518.method_15281((JsonObject)json, (String)"particle_colors", (JsonObject)new JsonObject());
                        data.particle_colors = new ItemBehaviorData.ParticleColors();
                        data.particle_colors.red = class_3518.method_15282((JsonObject)colors, (String)"red", (int)0);
                        data.particle_colors.green = class_3518.method_15282((JsonObject)colors, (String)"green", (int)0);
                        data.particle_colors.blue = class_3518.method_15282((JsonObject)colors, (String)"blue", (int)0);
                        boolean override_vanilla = class_3518.method_15258((JsonObject)json, (String)"override_vanilla", (boolean)false);
                        boolean complement = class_3518.method_15258((JsonObject)json, (String)"complement", (boolean)true);
                        int cooldown_time = class_3518.method_15282((JsonObject)json, (String)"cooldown", (int)50);
                        for (class_1792 item : items) {
                            ItemBehaviorManager.addBehavior(item, ItemBehaviorAdder.dataPack(data), complement);
                            if (override_vanilla) {
                                ItemBehaviorManager.overrideVanilla(item);
                            }
                            if (cooldown_time == 50) continue;
                            ItemBehaviorManager.addCustomCooldown(item, cooldown_time);
                        }
                    }
                    catch (IOException e) {
                        AndromedaLog.error("Error while parsing JSON for am_item_drop_behavior", e);
                    }
                }
                AndromedaLog.devInfo("Successfully loaded am_item_throw_behavior");
            }
        });
        AndromedaLog.info("ResourceConditionRegistry init complete!");
    }

    private static void readCommands(JsonObject json, ItemBehaviorData.CommandHolder holder) {
        JsonArray hit_block_arr;
        JsonArray hit_entity_arr;
        JsonArray server_arr;
        JsonArray user_arr;
        JsonArray item_arr = class_3518.method_15292((JsonObject)json, (String)"item_commands", null);
        if (item_arr != null) {
            ArrayList<String> item_commands = new ArrayList<String>(item_arr.size());
            for (Object element : item_arr) {
                item_commands.add(element.getAsString());
            }
            holder.item_commands = (String[])item_commands.toArray(String[]::new);
        }
        if ((user_arr = class_3518.method_15292((JsonObject)json, (String)"user_commands", null)) != null) {
            ArrayList<String> user_commands = new ArrayList<String>(user_arr.size());
            for (Object element : user_arr) {
                user_commands.add(element.getAsString());
            }
            holder.user_commands = (String[])user_commands.toArray(String[]::new);
        }
        if ((server_arr = class_3518.method_15292((JsonObject)json, (String)"server_commands", null)) != null) {
            ArrayList<String> server_commands = new ArrayList<String>(server_arr.size());
            for (Object element : server_arr) {
                server_commands.add(element.getAsString());
            }
            holder.server_commands = (String[])server_commands.toArray(String[]::new);
        }
        if ((hit_entity_arr = class_3518.method_15292((JsonObject)json, (String)"hit_entity_commands", null)) != null) {
            ArrayList<String> server_commands = new ArrayList<String>(hit_entity_arr.size());
            for (JsonElement element : hit_entity_arr) {
                server_commands.add(element.getAsString());
            }
            holder.hit_entity_commands = (String[])server_commands.toArray(String[]::new);
        }
        if ((hit_block_arr = class_3518.method_15292((JsonObject)json, (String)"hit_block_commands", null)) != null) {
            ArrayList<String> server_commands = new ArrayList<String>(hit_block_arr.size());
            for (JsonElement element : hit_block_arr) {
                server_commands.add(element.getAsString());
            }
            holder.hit_block_commands = (String[])server_commands.toArray(String[]::new);
        }
    }
}

