/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.andromeda.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import me.melontini.andromeda.Andromeda;
import me.melontini.andromeda.util.AndromedaLog;
import me.melontini.andromeda.util.SharedConstants;
import me.melontini.andromeda.util.exceptions.AndromedaException;
import me.melontini.dark_matter.api.analytics.Analytics;
import me.melontini.dark_matter.api.analytics.Prop;
import me.melontini.dark_matter.api.analytics.crashes.Crashlytics;
import me.melontini.dark_matter.api.analytics.mixpanel.MixpanelAnalytics;
import me.melontini.dark_matter.api.analytics.mixpanel.MixpanelHandler;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.StringUtils;

public class AndromedaReporter {
    public static final String CRASH_UUID = "be4db047-16df-4e41-9121-f1e87618ddea";
    private static final MixpanelHandler HANDLER = MixpanelAnalytics.init((String)new String(Base64.getDecoder().decode("NGQ3YWVhZGRjN2M5M2JkNzhiODRmNDViZWI3Y2NlOTE=")), (boolean)true);

    public static void handleUpload() {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            if (Andromeda.CONFIG.sendOptionalData) {
                if (SharedConstants.MOD_UPDATED) {
                    HANDLER.send(messageBuilder -> {
                        JsonObject object = new JsonObject();
                        object.addProperty("mod_version", SharedConstants.MOD_VERSION.split("-")[0]);
                        object.addProperty("mc_version", Prop.MINECRAFT_VERSION.get());
                        object.addProperty("modloader", StringUtils.capitalize((String)SharedConstants.PLATFORM.name().toLowerCase()));
                        AndromedaLog.info("Uploading optional data.: " + object);
                        messageBuilder.set(Analytics.getUUIDString(), object);
                    });
                } else {
                    AndromedaLog.info("Skipped optional data upload.");
                }
                Path fakeConfig = SharedConstants.HIDDEN_PATH.resolve("config_copy.json");
                try {
                    Files.deleteIfExists(fakeConfig);
                }
                catch (Exception e) {
                    AndromedaLog.warn("Failed to delete config_copy.json", e);
                }
            } else {
                HANDLER.send(messageBuilder -> messageBuilder.delete(Analytics.getUUIDString()));
            }
        }
    }

    private static boolean findAndromedaInTrace(Throwable cause) {
        for (StackTraceElement element : cause.getStackTrace()) {
            if (element.isNativeMethod()) continue;
            String cls = element.getClassName();
            if (cls.contains("me.melontini.andromeda.")) {
                return true;
            }
            if (!cls.contains("net.minecraft.")) continue;
            String mthd = element.getMethodName();
            return mthd.contains("$andromeda$") || mthd.contains(".andromeda$");
        }
        return cause.getCause() != null && AndromedaReporter.findAndromedaInTrace(cause.getCause());
    }

    public static void registerCrashHandler() {
        Crashlytics.addHandler((String)"andromeda", (report, cause, latestLog, envType) -> {
            if (!FabricLoader.getInstance().isDevelopmentEnvironment() && Andromeda.CONFIG.sendCrashReports) {
                if (cause instanceof AndromedaException) {
                    AndromedaException e = (AndromedaException)cause;
                    return e.shouldReport();
                }
                return AndromedaReporter.findAndromedaInTrace(cause);
            }
            return false;
        }, (report, cause, latestLog, envType) -> HANDLER.send(messageBuilder -> {
            String[] importantMods;
            AndromedaLog.warn("Found Andromeda in trace, collecting and uploading crash report...");
            JsonObject object = new JsonObject();
            JsonArray stackTrace = new JsonArray();
            for (String string : report.method_557().lines().toList()) {
                stackTrace.add(string);
            }
            object.add("stackTrace", (JsonElement)stackTrace);
            object.addProperty("environment", envType.toString().toLowerCase());
            object.addProperty("platform", SharedConstants.PLATFORM.toString().toLowerCase());
            JsonArray mods = new JsonArray();
            for (String importantMod : importantMods = new String[]{"andromeda", "minecraft", "modmenu", "dark-matter-base", "fabric-api", "fabricloader", "cloth-config", "cloth_config", "connectormod", "forge", "iceberg"}) {
                FabricLoader.getInstance().getModContainer(importantMod).ifPresent(mod -> mods.add(importantMod + " (" + mod.getMetadata().getVersion().getFriendlyString() + ")"));
            }
            object.add("mods", (JsonElement)mods);
            messageBuilder.trackEvent(CRASH_UUID, "Crash", object);
        }, true));
    }
}

