/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.andromeda.util;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Set;
import me.melontini.andromeda.util.AndromedaLog;
import me.melontini.andromeda.util.SharedConstants;

public class GitTracker {
    public static final String OWNER = "melontini";
    public static final String REPO = "andromeda";
    public static final String RAW_URL = "https://raw.githubusercontent.com";
    public static final String API_URL = "https://api.github.com";
    private static String DEFAULT_BRANCH = "1.19-fabric";
    private static final Set<String> PRESERVE_KEYS = Sets.newHashSet((Object[])new String[]{"default_branch", "stargazers_count"});
    private static final HttpClient CLIENT = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(5L)).build();

    public static String getDefaultBranch() {
        return DEFAULT_BRANCH;
    }

    private static void tryUpdateInfoFromJson(Path lastResponse) {
        try {
            JsonObject object = (JsonObject)JsonParser.parseString((String)Files.readString(lastResponse));
            if (object.has("default_branch")) {
                DEFAULT_BRANCH = object.get("default_branch").getAsString();
                AndromedaLog.info("Default branch is: {}", DEFAULT_BRANCH);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void tryUpdateGitInfo(Path lastResponse) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.github.com/repos/melontini/andromeda")).GET().header("Accept", "application/vnd.github+json").build();
        try {
            HttpResponse<String> response = CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Status Code: " + response.statusCode() + " Body: " + response.body());
            }
            JsonObject jsonResponse = (JsonObject)JsonParser.parseString((String)response.body());
            for (String s : new HashSet(jsonResponse.keySet())) {
                if (PRESERVE_KEYS.contains(s)) continue;
                jsonResponse.remove(s);
            }
            if (!Files.exists(lastResponse, new LinkOption[0])) {
                Files.createDirectories(lastResponse.getParent(), new FileAttribute[0]);
            }
            Files.writeString(lastResponse, (CharSequence)jsonResponse.toString(), new OpenOption[0]);
        }
        catch (Exception e) {
            AndromedaLog.warn("Couldn't update git info", e);
        }
    }

    static {
        Path lastResponse = SharedConstants.HIDDEN_PATH.resolve("git-response.json");
        boolean shouldUpdate = true;
        if (Files.exists(lastResponse, new LinkOption[0])) {
            try {
                FileTime lastModifiedTime = Files.getLastModifiedTime(lastResponse, new LinkOption[0]);
                shouldUpdate = ChronoUnit.HOURS.between(lastModifiedTime.toInstant(), Instant.now()) >= 24L;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!shouldUpdate) {
            shouldUpdate = SharedConstants.MOD_UPDATED;
        }
        if (shouldUpdate) {
            GitTracker.tryUpdateGitInfo(lastResponse);
        } else {
            AndromedaLog.info("Skipped git info update.");
        }
        if (Files.exists(lastResponse, new LinkOption[0])) {
            GitTracker.tryUpdateInfoFromJson(lastResponse);
        }
    }
}

