/*
 * Decompiled with CFR 0.152.
 */
package me.melontini.andromeda.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import org.spongepowered.asm.service.MixinService;

public class SharedConstants {
    public static final String MODID = "andromeda";
    public static final ModContainer MOD_CONTAINER = (ModContainer)FabricLoader.getInstance().getModContainer("andromeda").orElseThrow();
    public static final String MOD_VERSION = MOD_CONTAINER.getMetadata().getVersion().getFriendlyString();
    public static final Path HIDDEN_PATH = FabricLoader.getInstance().getGameDir().resolve(".andromeda");
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("andromeda.json");
    public static final boolean FABRICATION_LOADED = FabricLoader.getInstance().isModLoaded("fabrication");
    public static final Platform PLATFORM = SharedConstants.getPlatform();
    public static final boolean MOD_UPDATED = SharedConstants.checkModUpdate();

    private static Platform getPlatform() {
        String sn;
        if (FabricLoader.getInstance().isModLoaded("connectormod")) {
            try {
                Class.forName("dev.su5ed.sinytra.connector.mod.ConnectorLoader");
                return Platform.CONNECTOR;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (FabricLoader.getInstance().isModLoaded("quilt_loader") && "quilt".equalsIgnoreCase(sn = MixinService.getService().getName().replaceAll("^Knot|^Launchwrapper|^ModLauncher|/", ""))) {
            return Platform.QUILT;
        }
        return Platform.FABRIC;
    }

    private static boolean checkModUpdate() {
        Path lastVer = HIDDEN_PATH.resolve("last_version.txt");
        boolean modUpdated = true;
        if (Files.exists(lastVer, new LinkOption[0])) {
            try {
                Version lastVersion = Version.parse((String)Files.readString(lastVer));
                if (lastVersion.compareTo((Object)MOD_CONTAINER.getMetadata().getVersion()) <= 0) {
                    modUpdated = false;
                }
            }
            catch (IOException | VersionParsingException throwable) {
                // empty catch block
            }
        }
        SharedConstants.writeVersion(lastVer);
        return modUpdated;
    }

    private static void writeVersion(Path lastVer) {
        try {
            if (!Files.exists(lastVer.getParent(), new LinkOption[0])) {
                Files.createDirectories(lastVer.getParent(), new FileAttribute[0]);
            }
            Files.writeString(lastVer, (CharSequence)MOD_VERSION, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static enum Platform {
        FABRIC,
        CONNECTOR,
        QUILT,
        FORGE,
        NEOFORGED;

    }
}

