/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.parties.party;

import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_640;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.parties.party.IClientPartyMemberDynamicInfoSyncableStorage;
import xaero.pac.client.parties.party.IClientPartyStorage;
import xaero.pac.common.parties.party.IPartyMemberDynamicInfoSyncable;

public class PartyMemberDynamicInfoSyncable
implements IPartyMemberDynamicInfoSyncable {
    private class_2960 dimension;
    private double x;
    private double y;
    private double z;
    private final UUID playerId;
    private boolean dirty;
    private final boolean active;
    private UUID partyId;
    private final PartyMemberDynamicInfoSyncable remover;

    public PartyMemberDynamicInfoSyncable(UUID playerId, boolean active) {
        this.playerId = playerId;
        this.active = active;
        this.remover = active ? new PartyMemberDynamicInfoSyncable(playerId, false) : null;
    }

    @Override
    @Nonnull
    public UUID getPlayerId() {
        return this.playerId;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    @Nullable
    public class_2960 getDimension() {
        return this.dimension;
    }

    public void setDimension(class_2960 dimension) {
        if (!Objects.equals(dimension, this.dimension)) {
            this.dirty = true;
        }
        this.dimension = dimension;
    }

    public void setX(double x) {
        if (this.x != x) {
            this.dirty = true;
        }
        this.x = x;
    }

    public void setY(double y) {
        if (this.y != y) {
            this.dirty = true;
        }
        this.y = y;
    }

    public void setZ(double z) {
        if (this.z != z) {
            this.dirty = true;
        }
        this.z = z;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setPartyId(UUID partyId) {
        if (!Objects.equals(this.partyId, partyId)) {
            this.dirty = true;
        }
        this.partyId = partyId;
    }

    @Override
    public PartyMemberDynamicInfoSyncable getRemover() {
        return this.remover;
    }

    @Override
    public void update(class_2960 dimension, double x, double y, double z) {
        this.setDimension(dimension);
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    @Override
    public UUID getPartyId() {
        return this.partyId;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String toString() {
        return String.format("[%f, %f, %f, %s, %s]", this.x, this.y, this.z, this.dimension, this.active);
    }

    public static class ClientHandler
    implements Consumer<PartyMemberDynamicInfoSyncable> {
        @Override
        public void accept(PartyMemberDynamicInfoSyncable t) {
            if (t.active) {
                class_640 playerInfo;
                PartyMemberDynamicInfoSyncable clientInfo = ((IClientPartyMemberDynamicInfoSyncableStorage)((IClientPartyStorage)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage()).getPartyMemberDynamicInfoSyncableStorage()).getOrSetForPlayer(t.getPlayerId(), t);
                if (clientInfo != t) {
                    clientInfo.update(t.dimension, t.x, t.y, t.z);
                }
                String string = (playerInfo = class_310.method_1551().method_1562().method_2871(t.getPlayerId())) == null ? "unknown" : playerInfo.method_2966().getName();
            } else {
                ((IClientPartyMemberDynamicInfoSyncableStorage)((IClientPartyStorage)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage()).getPartyMemberDynamicInfoSyncableStorage()).removeForPlayer(t.playerId);
            }
        }
    }

    public static class Codec
    implements BiConsumer<PartyMemberDynamicInfoSyncable, class_2540>,
    Function<class_2540, PartyMemberDynamicInfoSyncable> {
        @Override
        public PartyMemberDynamicInfoSyncable apply(class_2540 input) {
            try {
                if (input.readableBytes() > 16384) {
                    return null;
                }
                class_2487 tag = input.method_30617();
                UUID playerId = tag.method_25926("i");
                boolean active = tag.method_10577("a");
                if (!active) {
                    return new PartyMemberDynamicInfoSyncable(playerId, false);
                }
                String dimensionSpace = tag.method_10558("ds");
                String dimensionPath = tag.method_10558("dp");
                class_2960 dimension = new class_2960(dimensionSpace, dimensionPath);
                double x = tag.method_10574("x");
                double y = tag.method_10574("y");
                double z = tag.method_10574("z");
                PartyMemberDynamicInfoSyncable result = new PartyMemberDynamicInfoSyncable(playerId, true);
                result.update(dimension, x, y, z);
                result.dirty = false;
                return result;
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void accept(PartyMemberDynamicInfoSyncable t, class_2540 u) {
            t.dirty = false;
            class_2487 tag = new class_2487();
            tag.method_25927("i", t.playerId);
            tag.method_10556("a", t.active);
            if (t.active) {
                tag.method_10582("ds", t.dimension.method_12836());
                tag.method_10582("dp", t.dimension.method_12832());
                tag.method_10549("x", t.x);
                tag.method_10549("y", t.y);
                tag.method_10549("z", t.z);
            }
            u.method_10794(tag);
        }
    }
}

