/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_3508;
import net.minecraft.class_6490;
import xaero.pac.common.claims.PlayerChunkClaimHolder;
import xaero.pac.common.claims.RegionClaims;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.claims.storage.RegionClaimsPaletteStorage;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.ServerClaimsManager;
import xaero.pac.common.server.claims.player.ServerPlayerClaimInfoManager;
import xaero.pac.common.server.player.config.PlayerConfig;

public final class ServerRegionClaims
extends RegionClaims<ServerPlayerClaimInfoManager, ServerRegionClaims>
implements IServerRegionClaims {
    private final ServerClaimsManager manager;
    private final RegionClaimsPaletteStorage syncableStorage;
    private final Object2IntMap<UUID> claimOwnerStateCounts;

    private ServerRegionClaims(class_2960 dimension, int x, int z, RegionClaimsPaletteStorage syncableStorage, RegionClaimsPaletteStorage storage, ServerClaimsManager manager, Object2IntMap<UUID> claimOwnerStateCounts) {
        super(dimension, x, z, storage);
        this.syncableStorage = syncableStorage;
        this.manager = manager;
        this.claimOwnerStateCounts = claimOwnerStateCounts;
    }

    @Override
    protected void set(int x, int z, PlayerChunkClaim value) {
        boolean shouldSync;
        PlayerChunkClaim oldValueForSync = null;
        boolean bl = shouldSync = this.manager != null && this.manager.isLoaded();
        if (shouldSync) {
            oldValueForSync = this.get(x, z);
        }
        super.set(x, z, value);
        if (this.syncableStorage != this.storage) {
            if (value != null && !Objects.equals(value.getPlayerId(), PlayerConfig.SERVER_CLAIM_UUID)) {
                value = null;
            }
            if (shouldSync && oldValueForSync != null && !Objects.equals(oldValueForSync.getPlayerId(), PlayerConfig.SERVER_CLAIM_UUID)) {
                oldValueForSync = null;
            }
            this.syncableStorage.set(x, z, value, this);
        }
        if (shouldSync && value != oldValueForSync) {
            this.manager.getClaimsManagerSynchronizer().syncToPlayersClaimUpdate(this.dimension, this.getX() << 5 | x, this.getZ() << 5 | z, value, oldValueForSync);
        }
    }

    @Override
    public void onAddedToPalette(RegionClaimsPaletteStorage paletteStorage, PlayerChunkClaim state) {
        super.onAddedToPalette(paletteStorage, state);
        if (paletteStorage == this.storage) {
            this.increaseOwnerCount(state.getPlayerId());
            this.manager.countStateRegions(state, 1);
        }
    }

    @Override
    public void onRemovedFromPalette(RegionClaimsPaletteStorage paletteStorage, PlayerChunkClaim state) {
        super.onRemovedFromPalette(paletteStorage, state);
        if (paletteStorage == this.storage) {
            this.decreaseOwnerCount(state.getPlayerId());
            this.manager.countStateRegions(state, -1);
        }
    }

    public int[] getSyncablePaletteArray() {
        return this.syncableStorage.getPaletteArray();
    }

    public int getSyncableStorageBits() {
        return this.syncableStorage.getStorageBits();
    }

    public long[] getSyncableStorageData() {
        return this.syncableStorage.getStorageData();
    }

    public boolean containsSyncableState(PlayerChunkClaim state) {
        return this.syncableStorage.containsState(state);
    }

    public boolean containsStateOwner(UUID ownerId) {
        return this.claimOwnerStateCounts.containsKey((Object)ownerId);
    }

    private void increaseOwnerCount(UUID ownerId) {
        this.claimOwnerStateCounts.put((Object)ownerId, this.claimOwnerStateCounts.getInt((Object)ownerId) + 1);
    }

    private void decreaseOwnerCount(UUID ownerId) {
        int currentCount = this.claimOwnerStateCounts.getInt((Object)ownerId);
        if (currentCount == 1) {
            this.claimOwnerStateCounts.removeInt((Object)ownerId);
        } else {
            this.claimOwnerStateCounts.put((Object)ownerId, currentCount - 1);
        }
    }

    public static final class Builder
    extends RegionClaims.Builder<ServerPlayerClaimInfoManager, ServerRegionClaims, Builder> {
        private ServerClaimsManager manager;
        private boolean playerClaimsSyncAllowed;
        private RegionClaimsPaletteStorage syncableStorage;

        public static Builder begin() {
            return new Builder().setDefault();
        }

        @Override
        public Builder setDefault() {
            super.setDefault();
            this.setManager(null);
            this.setPlayerClaimsSyncAllowed(true);
            return (Builder)this.self;
        }

        public Builder setManager(ServerClaimsManager manager) {
            this.manager = manager;
            return (Builder)this.self;
        }

        public Builder setPlayerClaimsSyncAllowed(boolean playerClaimsSyncAllowed) {
            this.playerClaimsSyncAllowed = playerClaimsSyncAllowed;
            return (Builder)this.self;
        }

        public ServerRegionClaims build() {
            this.syncableStorage = new RegionClaimsPaletteStorage((Object2IntMap<PlayerChunkClaim>)new Object2IntOpenHashMap(), (IntList)new IntArrayList(), Lists.newArrayList((Object[])new PlayerChunkClaimHolder[]{null}), (class_6490)new class_3508(1, 1024), false);
            this.setStorage(this.playerClaimsSyncAllowed ? this.syncableStorage : new RegionClaimsPaletteStorage((Object2IntMap<PlayerChunkClaim>)new Object2IntOpenHashMap(), null, Lists.newArrayList((Object[])new PlayerChunkClaimHolder[]{null}), (class_6490)new class_3508(1, 1024), false));
            return (ServerRegionClaims)super.build();
        }

        protected ServerRegionClaims buildInternally() {
            return new ServerRegionClaims(this.dimension, this.x, this.z, this.syncableStorage, this.storage, this.manager, (Object2IntMap<UUID>)new Object2IntOpenHashMap());
        }
    }
}

