/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.command.ClaimsClaimCommands;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.command.ConfigCommandUtil;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.api.IPlayerConfigAPI;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ClaimsSubClaimUseCommand {
    public void register(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment) {
        Command<class_2168> regularExecutor = ClaimsSubClaimUseCommand.getExecutor(PlayerConfigType.PLAYER);
        Command<class_2168> serverExecutor = ClaimsSubClaimUseCommand.getExecutor(PlayerConfigType.SERVER);
        SuggestionProvider<class_2168> playerSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.PLAYER);
        SuggestionProvider<class_2168> serverSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.SERVER);
        Predicate<class_2168> serverRequirement = ClaimsClaimCommands.getServerClaimCommandRequirement();
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac-claims").then(class_2170.method_9247((String)"sub-claim").then(this.getMainCommandPart(playerSubConfigSuggestionProvider, regularExecutor)));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac-claims").then(class_2170.method_9247((String)"sub-claim").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"for").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).then(this.getMainCommandPart(playerSubConfigSuggestionProvider, regularExecutor)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac-claims").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"server").requires(serverRequirement)).then(class_2170.method_9247((String)"sub-claim").then(this.getMainCommandPart(serverSubConfigSuggestionProvider, serverExecutor))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac-claims").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"server").requires(serverRequirement)).then(class_2170.method_9247((String)"sub-claim").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"for").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).then(this.getMainCommandPart(serverSubConfigSuggestionProvider, serverExecutor))))));
        dispatcher.register(command);
    }

    private LiteralArgumentBuilder<class_2168> getMainCommandPart(SuggestionProvider<class_2168> subConfigSuggestionProvider, Command<class_2168> executor) {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"use").then(class_2170.method_9244((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(subConfigSuggestionProvider).executes(executor));
    }

    private static Command<class_2168> getExecutor(PlayerConfigType type) {
        return context -> {
            class_3222 sourcePlayer = ((class_2168)context.getSource()).method_9207();
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            String inputSubId = StringArgumentType.getString((CommandContext)context, (String)"sub-id");
            GameProfile inputPlayer = ConfigCommandUtil.getConfigInputPlayer((CommandContext<class_2168>)context, sourcePlayer, "gui.xaero_claims_sub_use_too_many_targets", "gui.xaero_claims_sub_use_invalid_target", adaptiveLocalizer);
            if (inputPlayer == null) {
                return 0;
            }
            UUID configPlayerUUID = inputPlayer.getId();
            IPlayerConfig playerConfig = serverData.getPlayerConfigs().getLoadedConfig(configPlayerUUID);
            IPlayerConfigOptionSpecAPI<String> option = type == PlayerConfigType.SERVER ? PlayerConfigOptions.USED_SERVER_SUBCLAIM : PlayerConfigOptions.USED_SUBCLAIM;
            IPlayerConfig rootConfig = type == PlayerConfigType.SERVER ? serverData.getPlayerConfigs().getServerClaimConfig() : playerConfig;
            IPlayerConfig result = rootConfig.getSubConfig(inputSubId);
            if (result == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_claims_sub_use_not_exist", new Object[0]));
                return 0;
            }
            IPlayerConfigAPI.SetResult setResult = playerConfig.tryToSet(option, inputSubId);
            if (setResult == IPlayerConfigAPI.SetResult.INVALID) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_claims_sub_use_invalid_value", new Object[0]));
                return 0;
            }
            sourcePlayer.method_43496((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_claims_sub_use", inputSubId));
            return 1;
        };
    }
}

