/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.lazypacket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.BiConsumer;
import net.minecraft.class_2540;

public abstract class LazyPacket<E extends Encoder<P>, P extends LazyPacket<E, P>> {
    private final class_2540 data = new class_2540(Unpooled.buffer());
    private boolean prepared;

    protected abstract E getEncoder();

    public int getPreparedSize() {
        if (!this.prepared) {
            throw new IllegalStateException("Lazy packet has not been prepared!");
        }
        return this.data.readableBytes();
    }

    public int prepare() {
        if (this.prepared) {
            return this.data.readableBytes();
        }
        this.data.clear();
        this.writeOnPrepare(this.getEncoder(), this.data);
        this.prepared = true;
        return this.data.readableBytes();
    }

    protected abstract void writeOnPrepare(E var1, class_2540 var2);

    public static class Encoder<P extends LazyPacket<?, P>>
    implements BiConsumer<P, class_2540> {
        @Override
        public void accept(P t, class_2540 u) {
            P lazyPacket = t;
            if (!((LazyPacket)lazyPacket).prepared) {
                throw new IllegalStateException("Lazy packet has not been prepared!");
            }
            u.writeBytes((ByteBuf)((LazyPacket)lazyPacket).data, 0, ((LazyPacket)lazyPacket).data.readableBytes());
        }
    }
}

