/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.ally.api.IPartyAllyAPI;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.command.PartyOnCommandUpdater;
import xaero.pac.common.server.parties.party.IPartyManager;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class UnallyPartyCommand {
    public void register(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment, CommandRequirementProvider commandRequirementProvider) {
        Predicate<class_2168> requirement = commandRequirementProvider.getMemberRequirement((party, mi) -> mi.getRank().ordinal() >= PartyMemberRank.MODERATOR.ordinal());
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"ally").requires(requirement)).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"owner", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            Stream partyAllyStream;
            class_3222 commandPlayer = ((class_2168)context.getSource()).method_9207();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(((class_2168)context.getSource()).method_9211());
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerParty playerParty = (IServerParty)partyManager.getPartyByMember(commandPlayer.method_5667());
            String lowercaseInput = builder.getRemainingLowerCase();
            if (playerParty.getAllyCount() > 1024) {
                Object exactAlly = playerParty.getAlly(lowercaseInput);
                partyAllyStream = Stream.ofNullable(exactAlly);
            } else {
                partyAllyStream = playerParty.getAllyPartiesStream();
            }
            return class_2172.method_9264(partyAllyStream.map(IPartyAllyAPI::getPartyId).map(((IPartyManager)partyManager)::getPartyById).filter(Objects::nonNull).map(party -> ((IPartyMember)party.getOwner()).getUsername()).filter(ownerName -> ownerName.toLowerCase().startsWith(lowercaseInput)).limit(16L), (SuggestionsBuilder)builder);
        }).executes(context -> {
            IServerParty targetPlayerParty;
            String targetOwnerName;
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            UUID playerId = player.method_5667();
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerParty playerParty = (IServerParty)partyManager.getPartyByMember(playerId);
            Object targetAlly = playerParty.getAlly(targetOwnerName = StringArgumentType.getString((CommandContext)context, (String)"owner"));
            IServerParty iServerParty = targetPlayerParty = targetAlly == null ? null : (IServerParty)partyManager.getPartyById(targetAlly.getPartyId());
            if (targetPlayerParty == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_unally_party_not_found", targetOwnerName));
                return 0;
            }
            playerParty.removeAllyParty(targetPlayerParty.getId());
            new PartyOnCommandUpdater().update(playerId, serverData, targetPlayerParty, serverData.getPlayerConfigs(), mi -> false, (class_2561)class_2561.method_43469((String)"gui.xaero_parties_unally_target_party_message", (Object[])new Object[]{class_2561.method_43470((String)playerParty.getDefaultName()).method_27694(s -> s.method_10977(class_124.field_1077)), class_2561.method_43470((String)targetPlayerParty.getDefaultName())}));
            IPartyMember casterInfo = (IPartyMember)playerParty.getMemberInfo(playerId);
            new PartyOnCommandUpdater().update(playerId, serverData, playerParty, serverData.getPlayerConfigs(), mi -> false, (class_2561)class_2561.method_43469((String)"gui.xaero_parties_unally_caster_party_message", (Object[])new Object[]{class_2561.method_43470((String)casterInfo.getUsername()).method_27694(s -> s.method_10977(class_124.field_1077)), class_2561.method_43470((String)targetPlayerParty.getDefaultName()).method_27694(s -> s.method_10977(class_124.field_1054))}));
            return 1;
        }))));
        dispatcher.register(command);
    }
}

