/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.system.impl;

import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMember;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.server.parties.system.api.IPlayerPartySystemAPI;

public class PlayerArgonautsGuildSystem
implements IPlayerPartySystemAPI<Guild> {
    private final MinecraftServer server;

    public PlayerArgonautsGuildSystem(MinecraftServer server) {
        this.server = server;
    }

    @Override
    @Nullable
    public Guild getPartyByOwner(@Nonnull UUID playerId) {
        Guild guild = GuildApi.API.getPlayerGuild(this.server, playerId);
        if (guild == null) {
            return null;
        }
        if (!((GuildMember)guild.members().getLeader()).profile().getId().equals(playerId)) {
            return null;
        }
        return guild;
    }

    @Override
    @Nullable
    public Guild getPartyByMember(@Nonnull UUID playerId) {
        return GuildApi.API.getPlayerGuild(this.server, playerId);
    }

    @Override
    public boolean isPlayerAllying(@Nonnull UUID playerId, @Nonnull UUID potentialAllyPlayerId) {
        return false;
    }

    @Override
    public boolean isPermittedToPartyClaim(@Nonnull UUID playerId) {
        Guild guild = this.getPartyByMember(playerId);
        if (guild == null) {
            return false;
        }
        GuildMember member = (GuildMember)guild.members().get(playerId);
        return member != null && member.hasPermission("xaero.pac_party_claim");
    }
}

