/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.fabric.data.model;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.data.model.FileModel;
import dev.felnull.otyacraftengine.data.model.OverridePredicate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public class JsonModelInjector {
    private final BiConsumer<class_2960, Supplier<JsonElement>> originalModelOutput;
    private final Multimap<FileModel, OverridePredicate> overrides = LinkedHashMultimap.create();
    private final Map<String, class_2960> textures = new LinkedHashMap<String, class_2960>();

    public JsonModelInjector(BiConsumer<class_2960, Supplier<JsonElement>> originalModelOutput) {
        this.originalModelOutput = originalModelOutput;
    }

    public BiConsumer<class_2960, Supplier<JsonElement>> injectedModelOutput() {
        return (location, jsonElementSupplier) -> this.originalModelOutput.accept((class_2960)location, () -> this.lambda$injectedModelOutput$0((Supplier)jsonElementSupplier));
    }

    private JsonElement injectJsonModel(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject jo = jsonElement.getAsJsonObject();
            if (!this.overrides.isEmpty()) {
                JsonArray oja = new JsonArray();
                this.overrides.asMap().forEach((fileModel, predicates) -> {
                    JsonObject apjso = new JsonObject();
                    apjso.addProperty("model", fileModel.getLocation().toString());
                    JsonObject pjso = new JsonObject();
                    for (OverridePredicate predicate : predicates) {
                        pjso.addProperty(predicate.key().toString(), (Number)Float.valueOf(predicate.value()));
                    }
                    apjso.add("predicate", (JsonElement)pjso);
                    oja.add((JsonElement)apjso);
                });
                jo.add("overrides", (JsonElement)oja);
            }
            if (!this.textures.isEmpty()) {
                JsonObject tjo = new JsonObject();
                this.textures.forEach((id, loc) -> tjo.addProperty(id, loc.toString()));
                jo.add("textures", (JsonElement)tjo);
            }
        }
        return jsonElement;
    }

    public void putOverride(FileModel model, List<OverridePredicate> predicates) {
        this.overrides.putAll((Object)model, predicates);
    }

    public void putTexture(String id, class_2960 location) {
        this.textures.put(id, location);
    }

    private /* synthetic */ JsonElement lambda$injectedModelOutput$0(Supplier jsonElementSupplier) {
        return this.injectJsonModel((JsonElement)jsonElementSupplier.get());
    }
}

