/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminPose;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminAngryGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminAntiGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminAvoidEntityGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminCuriosityGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminEmbarrassedCurseGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminHiddenGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminHideGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminHurtByTargetGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminNearestAttackableTargetGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminRangedAttackGoal;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.DirtPelletEntity;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.FlowerHeadwearHelmet;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_11;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_7094;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RootminEntity
extends class_1314
implements class_1569 {
    private static final class_2940<Optional<class_2680>> FLOWER_BLOCK_STATE = class_2945.method_12791(RootminEntity.class, (class_2941)class_2943.field_42236);
    public static final class_2941<RootminPose> ROOTMIN_POSE_SERIALIZER = class_2941.method_43240(RootminPose.class);
    private static final class_2940<RootminPose> ROOTMIN_POSE = class_2945.method_12791(RootminEntity.class, ROOTMIN_POSE_SERIALIZER);
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 angryAnimationState = new class_7094();
    public final class_7094 curiousAnimationState = new class_7094();
    public final class_7094 curseAnimationState = new class_7094();
    public final class_7094 embarassedAnimationState = new class_7094();
    public final class_7094 shockAnimationState = new class_7094();
    public final class_7094 shootAnimationState = new class_7094();
    public final class_7094 runAnimationState = new class_7094();
    public final class_7094 walkAnimationState = new class_7094();
    public final class_7094 blockToEntityAnimationState = new class_7094();
    public final class_7094 entityToBlockAnimationState = new class_7094();
    private boolean checkedDefaultFlowerTag = false;
    public boolean isHidden = false;
    public boolean disableAttackGoals = false;
    public RootminEntity rootminToLookAt = null;
    public class_1309 attackerMemory = null;
    public UUID superHatedPlayer = null;
    private int delayTillIdle = -1;
    public boolean takePotShot = false;
    public int exposedTimer = 0;
    public int curiosityCooldown = 60;
    public int stayHidingTimer = 200;
    private UUID essenceController = null;
    private class_2338 essenceControllerBlockPos = null;
    private class_5321<class_1937> essenceControllerDimension = null;
    public int animationTimeBetweenHiding = 0;
    public static final Set<RootminPose> POSES_THAT_CANT_BE_MOTION_INTERRUPTED = Set.of(RootminPose.ANGRY, RootminPose.CURIOUS, RootminPose.CURSE, RootminPose.EMBARRASSED, RootminPose.SHOOT, RootminPose.SHOCK, RootminPose.BLOCK_TO_ENTITY, RootminPose.ENTITY_TO_BLOCK);
    public static final Set<RootminPose> POSES_THAT_CAN_BE_FEAR_INTERRUPTED = Set.of(RootminPose.ANGRY, RootminPose.CURIOUS, RootminPose.CURSE, RootminPose.EMBARRASSED, RootminPose.SHOCK);

    public RootminEntity(class_1299<? extends RootminEntity> type, class_1937 worldIn) {
        super(type, worldIn);
        this.getFlowerBlock();
        this.setAnimationState(this.getRootminPose(), RootminPose.NONE, this.idleAnimationState);
        this.method_49477(1.0f);
    }

    public void setFlowerBlock(@Nullable class_2680 blockState) {
        this.field_6011.method_12778(FLOWER_BLOCK_STATE, Optional.ofNullable(blockState));
    }

    @Nullable
    public class_2680 getFlowerBlock() {
        class_2680 state = ((Optional)this.field_6011.method_12789(FLOWER_BLOCK_STATE)).orElse(null);
        state = this.getFlowerOrSetIfMissing(state);
        return state;
    }

    @Nullable
    private class_2680 getFlowerOrSetIfMissing(class_2680 state) {
        if (state == null && !this.method_37908().method_8608() && !this.checkedDefaultFlowerTag) {
            List blockList = class_7923.field_41175.method_40266(BzTags.ROOTMIN_DEFAULT_FLOWERS).map(holders -> holders.method_40239().map(class_6880::comp_349).toList()).orElseGet(ArrayList::new);
            class_2680 class_26802 = state = blockList.isEmpty() ? null : ((class_2248)blockList.get(this.method_6051().method_43048(blockList.size()))).method_9564();
            if (state != null && state.method_26215()) {
                state = null;
            }
            this.setFlowerBlock(state);
            this.checkedDefaultFlowerTag = true;
        }
        return state;
    }

    public UUID getEssenceController() {
        return this.essenceController;
    }

    public void setEssenceController(UUID essenceController) {
        this.essenceController = essenceController;
    }

    public class_2338 getEssenceControllerBlockPos() {
        return this.essenceControllerBlockPos;
    }

    public void setEssenceControllerBlockPos(class_2338 essenceControllerBlockPos) {
        this.essenceControllerBlockPos = essenceControllerBlockPos;
    }

    public class_5321<class_1937> getEssenceControllerDimension() {
        return this.essenceControllerDimension;
    }

    public void setEssenceControllerDimension(class_5321<class_1937> essenceControllerDimension) {
        this.essenceControllerDimension = essenceControllerDimension;
    }

    public void setRootminPose(RootminPose rootminPose) {
        this.field_6011.method_12778(ROOTMIN_POSE, (Object)rootminPose);
    }

    public RootminPose getRootminPose() {
        return (RootminPose)((Object)this.field_6011.method_12789(ROOTMIN_POSE));
    }

    public void runAngry() {
        if (this.getRootminPose() != RootminPose.ANGRY) {
            this.method_5783(BzSounds.ROOTMIN_ANGRY.get(), 1.0f, this.method_6051().method_43057() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 80;
        this.setRootminPose(RootminPose.ANGRY);
    }

    public void runCurious() {
        if (this.getRootminPose() != RootminPose.CURIOUS) {
            this.method_5783(BzSounds.ROOTMIN_CURIOUS.get(), 1.0f, this.method_6051().method_43057() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 28;
        this.setRootminPose(RootminPose.CURIOUS);
    }

    public void runCurse() {
        if (this.getRootminPose() != RootminPose.CURSE) {
            this.method_5783(BzSounds.ROOTMIN_CURSING.get(), 1.0f, this.method_6051().method_43057() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 40;
        this.setRootminPose(RootminPose.CURSE);
    }

    public void runEmbarrassed() {
        if (this.getRootminPose() != RootminPose.EMBARRASSED) {
            this.method_5783(BzSounds.ROOTMIN_EMBARRASSED.get(), 1.0f, this.method_6051().method_43057() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 60;
        this.setRootminPose(RootminPose.EMBARRASSED);
    }

    public void runShock() {
        if (this.getRootminPose() != RootminPose.SHOCK) {
            this.method_5783(BzSounds.ROOTMIN_SHOCK.get(), 1.0f, this.method_6051().method_43057() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 10;
        this.setRootminPose(RootminPose.SHOCK);
    }

    public void runShoot(@Nullable class_1309 target, float speedMultipiler, boolean isHoming) {
        if (isHoming && target != null) {
            this.shootHomingDirt(target, speedMultipiler);
        } else {
            this.shootDirt(target, speedMultipiler);
        }
        this.delayTillIdle = 8;
        this.setRootminPose(RootminPose.SHOOT);
    }

    public void runMultiShoot(@Nullable class_1309 target, float speedMultipiler, int projectiles) {
        this.shootDirt(target, speedMultipiler, projectiles);
        this.delayTillIdle = 8;
        this.setRootminPose(RootminPose.SHOOT);
    }

    public void exposeFromBlock() {
        this.isHidden = false;
        this.delayTillIdle = 20;
        this.animationTimeBetweenHiding = 20;
        this.setRootminPose(RootminPose.BLOCK_TO_ENTITY);
    }

    public void hideAsBlock(class_243 destination) {
        this.isHidden = true;
        this.delayTillIdle = -1;
        this.animationTimeBetweenHiding = 20;
        this.setRootminPose(RootminPose.ENTITY_TO_BLOCK);
        this.method_5942().method_6340();
        if (destination != null && this.method_19538().method_1020(destination).method_1033() < 1.0) {
            this.method_29495(destination);
        } else {
            this.method_29495(class_243.method_24953((class_2382)this.method_24515()));
        }
        this.method_18799(class_243.field_1353);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new RootminAntiGoal(this));
        this.field_6201.method_6277(2, (class_1352)new RootminAngryGoal(this));
        this.field_6201.method_6277(3, (class_1352)new RootminEmbarrassedCurseGoal(this));
        this.field_6201.method_6277(4, (class_1352)new RootminCuriosityGoal(this));
        this.field_6201.method_6277(5, (class_1352)new RootminHiddenGoal(this));
        this.field_6201.method_6277(6, (class_1352)new RootminAvoidEntityGoal(this, BzTags.ROOTMIN_PANIC_AVOID, 24.0f, 1.75, 2.5));
        this.field_6201.method_6277(7, (class_1352)new RootminHideGoal(this));
        this.field_6201.method_6277(8, (class_1352)new RootminRangedAttackGoal(this, 1.25, 20, 15, 30.0f));
        this.field_6185.method_6277(9, (class_1352)new RootminHurtByTargetGoal(this));
        this.field_6185.method_6277(10, (class_1352)new RootminNearestAttackableTargetGoal((class_1308)this, true));
    }

    public static class_5132.class_5133 getAttributeBuilder() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.18).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23717, 30.0);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        class_2680 blockState = this.getFlowerBlock();
        if (blockState != null) {
            compoundTag.method_10566("flowerBlock", (class_2520)class_2512.method_10686((class_2680)blockState));
        }
        compoundTag.method_10556("hidden", this.isHidden);
        compoundTag.method_10569("delayTillIdle", this.delayTillIdle);
        compoundTag.method_10582("animationState", this.getRootminPose().name());
        if (this.superHatedPlayer != null) {
            compoundTag.method_25927("superHatedPlayer", this.superHatedPlayer);
        }
        if (this.getEssenceController() != null) {
            compoundTag.method_25927("essenceController", this.getEssenceController());
        }
        if (this.getEssenceControllerBlockPos() != null) {
            compoundTag.method_10566("essenceControllerBlockPos", (class_2520)class_2512.method_10692((class_2338)this.getEssenceControllerBlockPos()));
        }
        if (this.getEssenceControllerDimension() != null) {
            compoundTag.method_10582("essenceControllerDimension", this.getEssenceControllerDimension().method_29177().toString());
        }
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        class_2680 blockState = null;
        if (compoundTag.method_10573("flowerBlock", 10) && (blockState = class_2512.method_10681((class_7871)this.method_37908().method_45448(class_7924.field_41254), (class_2487)compoundTag.method_10562("flowerBlock"))).method_26215()) {
            blockState = null;
        }
        if (blockState == null) {
            this.getFlowerBlock();
        } else {
            this.setFlowerBlock(blockState);
        }
        this.isHidden = compoundTag.method_10577("hidden");
        this.delayTillIdle = compoundTag.method_10550("delayTillIdle");
        if (compoundTag.method_10545("superHatedPlayer")) {
            this.superHatedPlayer = compoundTag.method_25926("superHatedPlayer");
        }
        if (this.isHidden) {
            this.setRootminPose(RootminPose.ENTITY_TO_BLOCK);
        } else if (compoundTag.method_10545("animationState")) {
            this.setRootminPose(RootminPose.valueOf(compoundTag.method_10558("animationState")));
        }
        if (compoundTag.method_10545("essenceController")) {
            this.setEssenceController(compoundTag.method_25926("essenceController"));
        }
        if (compoundTag.method_10545("essenceControllerBlockPos")) {
            this.setEssenceControllerBlockPos(class_2512.method_10691((class_2487)compoundTag.method_10562("essenceControllerBlockPos")));
        }
        if (compoundTag.method_10545("essenceControllerDimension")) {
            this.setEssenceControllerDimension((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(compoundTag.method_10558("essenceControllerDimension"))));
        }
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn, class_2487 dataTag) {
        return super.method_5943(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FLOWER_BLOCK_STATE, Optional.empty());
        this.field_6011.method_12784(ROOTMIN_POSE, (Object)RootminPose.NONE);
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (ROOTMIN_POSE.equals(entityDataAccessor)) {
            RootminPose pose = this.getRootminPose();
            if (pose == RootminPose.BLOCK_TO_ENTITY || pose == RootminPose.ENTITY_TO_BLOCK) {
                this.animationTimeBetweenHiding = 20;
            }
            this.setAnimationState(pose, RootminPose.NONE, this.idleAnimationState, this.field_6012 - 27);
            this.setAnimationState(pose, RootminPose.ANGRY, this.angryAnimationState, (class_2394)BzParticles.ANGRY_PARTICLE.get(), 75, 1.0);
            this.setAnimationState(pose, RootminPose.CURIOUS, this.curiousAnimationState, (class_2394)BzParticles.CURIOUS_PARTICLE.get(), 23, 1.0);
            this.setAnimationState(pose, RootminPose.CURSE, this.curseAnimationState, (class_2394)BzParticles.CURSING_PARTICLE.get(), 35, 1.0);
            this.setAnimationState(pose, RootminPose.EMBARRASSED, this.embarassedAnimationState, (class_2394)BzParticles.EMBARRASSED_PARTICLE.get(), 55, 1.0);
            this.setAnimationState(pose, RootminPose.SHOCK, this.shockAnimationState);
            this.setAnimationState(pose, RootminPose.SHOOT, this.shootAnimationState);
            this.setAnimationState(pose, RootminPose.RUN, this.runAnimationState);
            this.setAnimationState(pose, RootminPose.WALK, this.walkAnimationState);
            this.setAnimationState(pose, RootminPose.BLOCK_TO_ENTITY, this.blockToEntityAnimationState);
            this.setAnimationState(pose, RootminPose.ENTITY_TO_BLOCK, this.entityToBlockAnimationState, this.field_6012 <= 2 ? -100000 : this.field_6012);
        }
        this.method_18382();
        if (!this.method_5765()) {
            this.method_36456(this.field_6241);
            this.method_5636(this.field_6241);
        }
        if (this.method_5799() && this.field_5974.method_43048(20) == 0) {
            this.method_5746();
        }
        super.method_5674(entityDataAccessor);
    }

    private void setAnimationState(RootminPose pose, RootminPose poseToCheckFor, class_7094 animationState) {
        this.setAnimationState(pose, poseToCheckFor, animationState, null, 0, 0.0);
    }

    private void setAnimationState(RootminPose pose, RootminPose poseToCheckFor, class_7094 animationState, int tickCount) {
        this.setAnimationState(pose, poseToCheckFor, animationState, tickCount, null, 0, 0.0);
    }

    private void setAnimationState(RootminPose pose, RootminPose poseToCheckFor, class_7094 animationState, class_2394 particleType, int particleLifeSpan, double yOffset) {
        this.setAnimationState(pose, poseToCheckFor, animationState, this.field_6012, particleType, particleLifeSpan, yOffset);
    }

    private void setAnimationState(RootminPose pose, RootminPose poseToCheckFor, class_7094 animationState, int tickCount, class_2394 particleType, int particleLifeSpan, double yOffset) {
        if (pose == poseToCheckFor) {
            if (!animationState.method_41327()) {
                class_1937 class_19372;
                animationState.method_41322(tickCount);
                if (particleType != null && (class_19372 = this.method_37908()) instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    serverLevel.method_14199(particleType, this.method_23317(), this.method_5829().field_1325 + yOffset, this.method_23321(), 0, 1.0, 1.0, 1.0, (double)particleLifeSpan);
                }
            }
        } else {
            animationState.method_41325();
        }
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        return true;
    }

    public void method_5650(class_1297.class_5529 removalReason) {
        super.method_5650(removalReason);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_1799 itemstack = player.method_5998(hand);
        boolean instantBuild = player.method_31549().field_7477;
        class_1792 class_17922 = itemstack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_2680 blockState;
            class_3222 serverPlayer;
            class_1747 blockItem = (class_1747)class_17922;
            if ((instantBuild || player instanceof class_3222 && EssenceOfTheBees.hasEssence(serverPlayer = (class_3222)player) || BeeArmor.getBeeThemedWearablesCount((class_1297)player) > 0 || !FlowerHeadwearHelmet.getFlowerHeadwear((class_1297)player).method_7960()) && (blockState = blockItem.method_7711().method_9564()).method_26164(BzTags.ROOTMIN_ALLOWED_FLOWERS) && !blockState.method_26164(BzTags.ROOTMIN_FORCED_DISALLOWED_FLOWERS) && (this.getFlowerBlock() == null || this.getFlowerBlock() != blockState)) {
                if (!this.method_37908().method_8608()) {
                    if (!instantBuild && this.getFlowerBlock() != null) {
                        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8377);
                        itemStack.method_7978(class_1893.field_9099, 1);
                        class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1229, (Object)itemStack).method_51877(class_181.field_1226, (Object)this);
                        List flowerDrops = this.getFlowerBlock().method_26189(builder);
                        for (class_1799 flowerDrop : flowerDrops) {
                            this.method_5699(flowerDrop, 1.0f);
                        }
                    }
                    if (blockState.method_26204() instanceof class_2320) {
                        blockState.method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12607);
                    }
                    int shrinkAmount = 1;
                    if (blockState.method_28498((class_2769)class_2741.field_42835)) {
                        shrinkAmount = Math.min(Math.max(1, itemstack.method_7947()), 4);
                        blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_42835, (Comparable)Integer.valueOf(shrinkAmount));
                    }
                    this.setFlowerBlock(blockState);
                    player.method_7259(class_3468.field_15372.method_14956((Object)itemstack.method_7909()));
                    if (!instantBuild) {
                        itemstack.method_7934(shrinkAmount);
                    }
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer2 = (class_3222)player;
                        BzCriterias.ROOTMIN_FLOWER_SWAP_TRIGGER.trigger(serverPlayer2);
                    }
                }
                return class_1269.field_5812;
            }
        }
        return super.method_5992(player, hand);
    }

    public void shootHomingDirt(class_1309 livingEntity, float speedMultipiler) {
        if (!this.method_37908().method_8608()) {
            DirtPelletEntity pelletEntity = new DirtPelletEntity(this.method_37908(), (class_1309)this);
            pelletEntity.method_33574(pelletEntity.method_19538().method_1031(this.method_5720().method_10216(), 0.0, this.method_5720().method_10215()));
            if (this.getEssenceController() != null) {
                pelletEntity.setEventBased(true);
            }
            pelletEntity.setHoming(true);
            pelletEntity.setHomingTargetUUID(livingEntity.method_5667());
            double x = livingEntity.method_23317() - this.method_23317();
            double y = livingEntity.method_23323(1.333333 - (double)speedMultipiler) - pelletEntity.method_23318();
            double z = livingEntity.method_23321() - this.method_23321();
            double archOffset = Math.sqrt(x * x + z * z);
            class_243 lookAngle = this.method_5720();
            pelletEntity.method_7485(lookAngle.method_10216(), y + archOffset * (double)0.01f, lookAngle.method_10215(), 1.5f * speedMultipiler, 1.0f);
            this.method_5783(BzSounds.ROOTMIN_SHOOT.get(), 1.0f, this.method_6051().method_43057() * 0.2f + 0.8f);
            this.method_37908().method_8649((class_1297)pelletEntity);
        }
    }

    public void shootDirt(@Nullable class_1309 livingEntity) {
        this.shootDirt(livingEntity, 1.0f);
    }

    public void shootDirt(@Nullable class_1309 livingEntity, float speedMultipiler) {
        this.shootDirt(livingEntity, 1.0f, 1);
    }

    public void shootDirt(@Nullable class_1309 livingEntity, float speedMultipiler, int totalProjectiles) {
        if (!this.method_37908().method_8608()) {
            for (int currentProjectile = 0; currentProjectile < totalProjectiles; ++currentProjectile) {
                class_243 shootAngle;
                DirtPelletEntity pelletEntity = new DirtPelletEntity(this.method_37908(), (class_1309)this);
                pelletEntity.method_33574(pelletEntity.method_19538().method_1031(this.method_5720().method_10216(), 0.0, this.method_5720().method_10215()));
                if (this.getEssenceController() != null) {
                    pelletEntity.setEventBased(true);
                }
                if (livingEntity != null) {
                    double x = livingEntity.method_23317() - this.method_23317();
                    double y = livingEntity.method_23323(1.3 - (double)speedMultipiler * 1.3) - pelletEntity.method_23318();
                    double z = livingEntity.method_23321() - this.method_23321();
                    shootAngle = new class_243(x, y, z);
                } else {
                    double defaultSpeed = 5.0;
                    double x = this.method_5720().method_10216() * defaultSpeed;
                    double y = 0.3333333333333333;
                    double z = this.method_5720().method_10215() * defaultSpeed;
                    shootAngle = new class_243(x, y, z);
                }
                double archOffset = Math.sqrt(shootAngle.method_10216() * shootAngle.method_10216() + shootAngle.method_10215() * shootAngle.method_10215());
                class_243 vec3 = this.method_18864(1.0f);
                int angle = (currentProjectile - (int)((float)totalProjectiles / 2.0f)) * 3;
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)((float)angle * ((float)Math.PI / 180)), vec3.field_1352, vec3.field_1351, vec3.field_1350);
                Vector3f rotatedShootAngle = shootAngle.method_46409().rotate((Quaternionfc)quaternionf);
                pelletEntity.method_7485(rotatedShootAngle.x(), (double)rotatedShootAngle.y() + archOffset * (double)0.2f, rotatedShootAngle.z(), 1.5f * speedMultipiler, 1.0f);
                this.method_5783(BzSounds.ROOTMIN_SHOOT.get(), 1.0f, this.method_6051().method_43057() * 0.2f + 0.8f);
                this.method_37908().method_8649((class_1297)pelletEntity);
            }
        }
    }

    public boolean method_5679(class_1282 damageSource) {
        if (this.getEssenceController() != null) {
            class_1297 class_12972 = damageSource.method_5526();
            if (class_12972 instanceof DirtPelletEntity) {
                class_3222 serverPlayer;
                DirtPelletEntity dirtPelletEntity = (DirtPelletEntity)class_12972;
                if (dirtPelletEntity.isEventBased()) {
                    return super.method_5679(damageSource);
                }
                class_1297 class_12973 = dirtPelletEntity.method_24921();
                if (class_12973 instanceof class_3222 && EssenceOfTheBees.hasEssence(serverPlayer = (class_3222)class_12973) && this.getRootminPose() != RootminPose.ANGRY && this.getRootminPose() != RootminPose.CURSE && this.getRootminPose() != RootminPose.SHOCK && this.field_6235 == 0) {
                    return super.method_5679(damageSource);
                }
            }
            return true;
        }
        return super.method_5679(damageSource);
    }

    public void method_5773() {
        class_1937 class_19372;
        super.method_5773();
        if (this.field_6235 == 9 && !this.method_37908().method_8608()) {
            this.isHidden = false;
            if (this.getRootminPose() != RootminPose.CURSE && this.getRootminPose() != RootminPose.SHOCK) {
                this.runShock();
            }
        }
        if (!this.method_37908().method_8608()) {
            double horizontalSpeed = this.method_18798().method_37267();
            if (!POSES_THAT_CANT_BE_MOTION_INTERRUPTED.contains((Object)this.getRootminPose())) {
                if (horizontalSpeed > 0.2 || this.field_6235 > 0) {
                    this.setRootminPose(RootminPose.RUN);
                } else if (horizontalSpeed > 0.01) {
                    this.setRootminPose(RootminPose.WALK);
                }
            }
            if (this.getRootminPose() == RootminPose.ENTITY_TO_BLOCK && this.curiosityCooldown >= 0) {
                --this.curiosityCooldown;
            }
            if (this.delayTillIdle >= 0) {
                if (this.delayTillIdle == 0) {
                    this.setRootminPose(RootminPose.NONE);
                }
                --this.delayTillIdle;
            } else if (!this.isHidden && this.getRootminPose() != RootminPose.NONE && this.method_5805() && horizontalSpeed <= 0.01) {
                this.setRootminPose(RootminPose.NONE);
            }
        }
        if (this.animationTimeBetweenHiding > 0) {
            --this.animationTimeBetweenHiding;
            if (this.getRootminPose() == RootminPose.BLOCK_TO_ENTITY || this.getRootminPose() == RootminPose.ENTITY_TO_BLOCK) {
                this.method_18382();
            }
        }
        if ((class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.getRootminPose() == RootminPose.SHOCK && this.delayTillIdle == 8) {
                serverLevel.method_14199((class_2394)BzParticles.SHOCK_PARTICLE.get(), this.method_23317(), this.method_5829().field_1325 + 1.5, this.method_23321(), 0, 1.0, 1.0, 1.0, 8.0);
            }
        } else if (this.getRootminPose() == RootminPose.ENTITY_TO_BLOCK && this.animationTimeBetweenHiding == 0 && this.field_6259 % 90.0f != 0.0f && this.field_6241 % 90.0f != 0.0f && this.field_6220 % 90.0f != 0.0f && this.field_6283 % 90.0f != 0.0f && !this.method_5765()) {
            float closestDir;
            class_243 lookDirection = this.method_5720();
            this.field_6259 = closestDir = class_2350.method_10142((double)lookDirection.method_10216(), (double)lookDirection.method_10214(), (double)lookDirection.method_10215()).method_10144();
            this.field_6241 = closestDir;
            this.field_6220 = closestDir;
            this.field_6283 = closestDir;
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_5805() && (this.getRootminPose() == RootminPose.WALK || this.getRootminPose() == RootminPose.RUN)) {
            class_243 frontPos = this.method_19538().method_1019(class_243.method_24954((class_2382)this.method_5735().method_10163()));
            List list = this.method_37908().method_8390(RootminEntity.class, this.method_5829().method_1014(0.3), rootmin -> rootmin != this && rootmin.getRootminPose() == RootminPose.ENTITY_TO_BLOCK && rootmin.method_19538().method_24802((class_2374)frontPos, 1.3) && rootmin.method_23318() - this.method_19538().method_10214() >= -0.5);
            if (!list.isEmpty() && this.method_24828()) {
                this.method_6043();
            }
        }
    }

    protected void method_5958() {
        if (this.exposedTimer > 0) {
            --this.exposedTimer;
        }
    }

    protected void method_16080(class_1282 damageSource) {
        RootminEntity sourceEntity;
        class_2680 flower = this.getFlowerBlock();
        RootminEntity rootminEntity = sourceEntity = damageSource.method_5529() == null ? this : damageSource.method_5529();
        if (flower != null) {
            class_1799 itemStack = new class_1799((class_1935)class_1802.field_8377);
            itemStack.method_7978(class_1893.field_9099, 1);
            class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1229, (Object)itemStack).method_51877(class_181.field_1226, (Object)sourceEntity);
            List flowerDrops = flower.method_26189(builder);
            for (class_1799 flowerDrop : flowerDrops) {
                this.method_5699(flowerDrop, 0.5f);
            }
        }
        super.method_16080(damageSource);
    }

    public boolean method_30948() {
        return this.getRootminPose() == RootminPose.ENTITY_TO_BLOCK && !this.method_29504();
    }

    protected class_238 method_33332() {
        if (this.getRootminPose() == RootminPose.BLOCK_TO_ENTITY || this.getRootminPose() == RootminPose.ENTITY_TO_BLOCK) {
            class_238 currentAABB = super.method_33332();
            float target = this.getRootminPose() == RootminPose.BLOCK_TO_ENTITY ? 1.56f : 1.0f;
            float from = this.getRootminPose() == RootminPose.BLOCK_TO_ENTITY ? 1.0f : 1.56f;
            float percentage = (20.0f - (float)this.animationTimeBetweenHiding) / 20.0f;
            currentAABB = currentAABB.method_35578(class_3532.method_16436((double)percentage, (double)((double)from + currentAABB.field_1322), (double)((double)target + currentAABB.field_1322)));
            return currentAABB;
        }
        return super.method_33332();
    }

    protected float method_18394(class_4050 poseIn, class_4048 sizeIn) {
        return (float)(this.method_5829().method_17940() - (double)0.575f);
    }

    public void method_18382() {
        double x = this.method_23317();
        double y = this.method_23318();
        double z = this.method_23321();
        super.method_18382();
        this.method_30634(x, y, z);
    }

    public boolean method_5822() {
        return super.method_5822() && this.getEssenceController() == null;
    }

    public class_1297 method_5731(class_3218 serverLevel) {
        if (this.getEssenceController() != null) {
            return this;
        }
        return super.method_5731(serverLevel);
    }

    public int method_51848() {
        return this.getEssenceController() == null ? super.method_51848() : Integer.MAX_VALUE;
    }

    protected boolean method_27071() {
        return this.getEssenceController() == null || this.method_6081() != null && this.method_6081().method_5526() instanceof DirtPelletEntity;
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    public float method_6107() {
        return 0.4f * (float)(this.method_6109() ? 1 : 2);
    }

    public int method_5978() {
        return 0;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return BzSounds.ROOTMIN_SHOCK.get();
    }

    protected class_3414 method_6002() {
        return BzSounds.ROOTMIN_SHOCK.get();
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    public static boolean isFacingMob(RootminEntity rootminEntity, class_1309 target) {
        class_243 targetView = target.method_5720().method_1029();
        class_243 currentDirection = rootminEntity.method_19538().method_1020(target.method_19538()).method_1029();
        double dotProduct = currentDirection.method_10216() * targetView.method_10216() + currentDirection.method_10214() * targetView.method_10214() + currentDirection.method_10215() * targetView.method_10215();
        return dotProduct >= 0.0;
    }

    public boolean canTarget(class_1309 livingEntity) {
        boolean canTarget;
        boolean bl = canTarget = (BeeAggression.doesBeesHateEntity((class_1297)livingEntity) || livingEntity.method_5864().method_20210(BzTags.ROOTMIN_TARGETS)) && !livingEntity.method_5864().method_20210(BzTags.ROOTMIN_FORCED_DO_NOT_TARGET);
        if (canTarget && livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            if (player.method_7337() || player.method_7325() || player.method_29504()) {
                if (player.method_5667().equals(this.superHatedPlayer)) {
                    this.superHatedPlayer = null;
                }
                return false;
            }
            if (player.method_5667().equals(this.superHatedPlayer)) {
                this.stayHidingTimer = 0;
                return true;
            }
            if (BeeArmor.getBeeThemedWearablesCount((class_1297)player) > 0 || !FlowerHeadwearHelmet.getFlowerHeadwear((class_1297)player).method_7960()) {
                return false;
            }
        }
        return canTarget;
    }

    public static void considerHiddenRootminsInPath(class_11 path, RootminEntity mob) {
        if (path != null && !path.method_46() && path.method_38() > 0 && path.method_38() > path.method_39()) {
            class_2338 targetPos = path.method_31031(path.method_39());
            class_238 aabb = new class_238((double)targetPos.method_10263() - 0.2, (double)targetPos.method_10264() - 0.2, (double)targetPos.method_10260() - 0.2, (double)targetPos.method_10263() + 1.2, (double)targetPos.method_10264() + 1.2, (double)targetPos.method_10260() + 1.2);
            List list = mob.method_37908().method_8390(RootminEntity.class, aabb, rootmin2 -> rootmin2 != mob && rootmin2.getRootminPose() == RootminPose.ENTITY_TO_BLOCK);
            if (!list.isEmpty()) {
                path.method_44();
            }
        }
    }

    public static void jumpFix(class_11 path, RootminEntity mob) {
        class_2338 targetPos;
        if (!mob.field_6282 && path != null && !path.method_46() && path.method_38() > 0 && path.method_38() > path.method_39() && (targetPos = path.method_31031(path.method_39())).method_10264() > mob.method_24515().method_10264()) {
            class_2338 frontPos = mob.method_24515().method_10093(mob.method_5735());
            class_2680 frontState = mob.method_37908().method_8320(frontPos);
            if (frontState.method_26234((class_1922)mob.method_37908(), frontPos)) {
                mob.method_6043();
            }
        }
    }
}

