/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.mixin.entities.FoxAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3449;
import net.minecraft.class_4019;
import net.minecraft.class_5138;
import net.minecraft.class_5819;
import net.minecraft.class_6025;
import net.minecraft.class_7924;

public class KnowingEssence
extends AbilityEssenceItem {
    private static final String STRUCTURE_LIST = "inStructures";
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.knowingEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.knowingEssenceAbilityUse;
    private static final int RED = 0xF90000;
    private static final int ORANGE = 0xFF8800;
    private static final int YELLOW = 0xFFF600;
    private static final int GREEN = 3931904;
    private static final int CYAN = 57564;
    private static final int PURPLE = 13238501;
    private static final int WHITE = 0xFFFCFC;
    private static final int NO_HIGHLIGHT = -1;

    public KnowingEssence(class_1792.class_1793 properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public int getColor() {
        return 15737343;
    }

    @Override
    void addDescriptionComponents(List<class_2561> components) {
        components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_knowing_description_1").method_27692(class_124.field_1064).method_27692(class_124.field_1056));
        components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_knowing_description_2").method_27692(class_124.field_1064).method_27692(class_124.field_1056));
    }

    public void decrementAbilityUseRemaining(class_1799 stack, class_3222 serverPlayer) {
        int getRemainingUse = Math.max(this.getAbilityUseRemaining(stack) - 1, 0);
        this.setAbilityUseRemaining(stack, getRemainingUse);
        if (getRemainingUse == 0) {
            this.setDepleted(stack, serverPlayer, false);
        }
    }

    @Override
    public void rechargeAbilitySlowly(class_1799 stack, class_1937 level, class_3222 serverPlayer) {
        int abilityUseRemaining = this.getAbilityUseRemaining(stack);
        if (abilityUseRemaining < this.getMaxAbilityUseAmount()) {
            int lastChargeTime = KnowingEssence.getLastAbilityChargeTimestamp(stack);
            if (lastChargeTime == 0 || serverPlayer.field_6012 < lastChargeTime) {
                KnowingEssence.setLastAbilityChargeTimestamp(stack, serverPlayer.field_6012);
            } else {
                int timeFromLastCharge = serverPlayer.field_6012 - lastChargeTime;
                int chargeTimeIncrement = Math.max(this.getCooldownTickLength() / this.getMaxAbilityUseAmount(), 1);
                if (timeFromLastCharge % chargeTimeIncrement == 0) {
                    this.setAbilityUseRemaining(stack, abilityUseRemaining + 1);
                    KnowingEssence.setLastAbilityChargeTimestamp(stack, serverPlayer.field_6012);
                }
            }
        }
    }

    @Override
    public void rechargeAbilityEntirely(class_1799 stack) {
        this.setAbilityUseRemaining(stack, this.getMaxAbilityUseAmount());
    }

    @Override
    public void applyAbilityEffects(class_1799 stack, class_1937 level, class_3222 serverPlayer) {
        if (KnowingEssence.getIsActive(stack)) {
            if (((long)serverPlayer.field_6012 + serverPlayer.method_5667().getLeastSignificantBits()) % 5L == 0L) {
                KnowingEssence.spawnParticles(serverPlayer.method_51469(), serverPlayer.method_19538(), serverPlayer.method_6051());
            }
            if (((long)serverPlayer.field_6012 + serverPlayer.method_5667().getLeastSignificantBits()) % 20L == 0L) {
                this.decrementAbilityUseRemaining(stack, serverPlayer);
                if (BzGeneralConfigs.knowingEssenceStructureNameServer) {
                    class_5138 structureManager = ((class_3218)level).method_27056();
                    List structureStarts = structureManager.method_41035(new class_1923(serverPlayer.method_24515()), s -> true);
                    ArrayList<class_3195> structures = new ArrayList<class_3195>();
                    for (class_3449 structureStart : structureStarts) {
                        if (!structureStart.method_14969().method_14662((class_2382)serverPlayer.method_24515())) continue;
                        structures.add(structureStart.method_16656());
                    }
                    class_2487 tag = stack.method_7948();
                    if (!structures.isEmpty()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        class_2378 structureRegistry = level.method_30349().method_30530(class_7924.field_41246);
                        int structureCount = 0;
                        for (class_3195 structure : structures) {
                            if (structureCount > 0) {
                                stringBuilder.append(" ");
                            }
                            stringBuilder.append(structureRegistry.method_10221((Object)structure));
                            ++structureCount;
                        }
                        tag.method_10582(STRUCTURE_LIST, stringBuilder.toString());
                    } else {
                        tag.method_10551(STRUCTURE_LIST);
                    }
                } else {
                    stack.method_7948().method_10551(STRUCTURE_LIST);
                }
            }
        }
    }

    public static String GetAllStructure(class_1799 stack) {
        return stack.method_7948().method_10558(STRUCTURE_LIST);
    }

    public static boolean IsKnowingEssenceActive(class_1657 player) {
        if (player != null) {
            class_1799 offHandItem = player.method_6079();
            return offHandItem.method_31574(BzItems.ESSENCE_KNOWING.get()) && KnowingEssence.getIsActive(offHandItem);
        }
        return false;
    }

    public static boolean IsValidEntityToGlow(class_1297 entity, class_1657 player) {
        return KnowingEssence.GetTeamColor(entity, player) != -1;
    }

    public static int GetTeamColor(class_1297 entity, class_1657 player) {
        class_4019 fox;
        class_6025 ownableEntity;
        class_1299 entityType = entity.method_5864();
        if (entityType.method_20210(BzTags.ENTITY_PREVENT_HIGHLIGHTING)) {
            return -1;
        }
        if (entityType.method_20210(BzTags.ENTITY_FORCED_WHITE_HIGHLIGHT)) {
            return 0xFFFCFC;
        }
        if (entityType.method_20210(BzTags.ENTITY_FORCED_PURPLE_HIGHLIGHT)) {
            return 13238501;
        }
        if (entityType.method_20210(BzTags.ENTITY_FORCED_CYAN_HIGHLIGHT)) {
            return 57564;
        }
        if (entityType.method_20210(BzTags.ENTITY_FORCED_GREEN_HIGHLIGHT)) {
            return 3931904;
        }
        if (entityType.method_20210(BzTags.ENTITY_FORCED_YELLOW_HIGHLIGHT)) {
            return 0xFFF600;
        }
        if (entityType.method_20210(BzTags.ENTITY_FORCED_ORANGE_HIGHLIGHT)) {
            return 0xFF8800;
        }
        if (entityType.method_20210(BzTags.ENTITY_FORCED_RED_HIGHLIGHT)) {
            return 0xF90000;
        }
        if (entityType.method_20210(BzTags.BOSSES)) {
            if (BzClientConfigs.knowingEssenceHighlightBosses) {
                return 13238501;
            }
        } else if (entity instanceof class_1569) {
            if (BzClientConfigs.knowingEssenceHighlightMonsters) {
                return 0xF90000;
            }
        } else if (entity instanceof class_6025 && (ownableEntity = (class_6025)entity).method_6139() != null && ownableEntity.method_6139().equals(player.method_5667())) {
            if (BzClientConfigs.knowingEssenceHighlightTamed) {
                return 3931904;
            }
        } else if (entity instanceof class_4019 && ((FoxAccessor)(fox = (class_4019)entity)).callTrusts(player.method_5667())) {
            if (BzClientConfigs.knowingEssenceHighlightTamed) {
                return 3931904;
            }
        } else if (entity instanceof class_1309) {
            if (BzClientConfigs.knowingEssenceHighlightLivingEntities) {
                return 0xFF8800;
            }
        } else if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            class_1799 itemStack = itemEntity.method_6983();
            if (itemStack.method_7932() == class_1814.field_8906) {
                if (BzClientConfigs.knowingEssenceHighlightCommonItems) {
                    return 0xFFFCFC;
                }
            } else if (itemStack.method_7932() == class_1814.field_8907) {
                if (BzClientConfigs.knowingEssenceHighlightUncommonItems) {
                    return 0xFFF600;
                }
            } else if (itemStack.method_7932() == class_1814.field_8903) {
                if (BzClientConfigs.knowingEssenceHighlightRareItems) {
                    return 57564;
                }
            } else if (itemStack.method_7932() == class_1814.field_8904 && BzClientConfigs.knowingEssenceHighlightEpicItems) {
                return 13238501;
            }
        }
        return -1;
    }

    public static void spawnParticles(class_3218 world, class_243 location, class_5819 random) {
        world.method_14199((class_2394)class_2398.field_11215, location.method_10216(), location.method_10214() + 1.0, location.method_10215(), 1, random.method_43059() * 0.1, random.method_43059() * 0.1 + 0.1, random.method_43059() * 0.1, (double)random.method_43057() * 0.3 + (double)0.1f);
    }
}

