/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.google.common.collect.Lists;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.fabric.EnchantmentUtilsImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Contract;

public class EnchantmentUtils {
    public static int getPlayerXP(class_1657 player) {
        return (int)((float)EnchantmentUtils.getExperienceForLevel(player.field_7520) + player.field_7510 * (float)player.method_7349());
    }

    public static void addPlayerXP(class_1657 player, int amount) {
        int experience;
        player.field_7495 = experience = EnchantmentUtils.getPlayerXP(player) + amount;
        player.field_7520 = EnchantmentUtils.getLevelForExperience(experience);
        int expForLevel = EnchantmentUtils.getExperienceForLevel(player.field_7520);
        player.field_7510 = (float)(experience - expForLevel) / (float)player.method_7349();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return EnchantmentUtils.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + EnchantmentUtils.sum(level - 15, 37, 5);
        }
        return 1395 + EnchantmentUtils.sum(level - 30, 112, 9);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = EnchantmentUtils.getLevelForExperience(level);
        int nextXP = EnchantmentUtils.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = EnchantmentUtils.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static float getPower(class_1937 world, class_2338 position) {
        float power = 0.0f;
        for (int deltaZ = -1; deltaZ <= 1; ++deltaZ) {
            for (int deltaX = -1; deltaX <= 1; ++deltaX) {
                if (deltaZ == 0 && deltaX == 0 || !world.method_22347(position.method_10069(deltaX, 0, deltaZ)) || !world.method_22347(position.method_10069(deltaX, 1, deltaZ))) continue;
                power += EnchantmentUtils.getEnchantPower(world, position.method_10069(deltaX * 2, 0, deltaZ * 2));
                power += EnchantmentUtils.getEnchantPower(world, position.method_10069(deltaX * 2, 1, deltaZ * 2));
                if (deltaX == 0 || deltaZ == 0) continue;
                power += EnchantmentUtils.getEnchantPower(world, position.method_10069(deltaX * 2, 0, deltaZ));
                power += EnchantmentUtils.getEnchantPower(world, position.method_10069(deltaX * 2, 1, deltaZ));
                power += EnchantmentUtils.getEnchantPower(world, position.method_10069(deltaX, 0, deltaZ * 2));
                power += EnchantmentUtils.getEnchantPower(world, position.method_10069(deltaX, 1, deltaZ * 2));
            }
        }
        return power;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static float getEnchantPower(class_1937 world, class_2338 pos) {
        void var1_1;
        return EnchantmentUtilsImpl.getEnchantPower(world, (class_2338)var1_1);
    }

    public static void addAllBooks(class_1887 enchantment, List<class_1799> items) {
        for (int i = enchantment.method_8187(); i <= enchantment.method_8183(); ++i) {
            items.add(class_1772.method_7808((class_1889)new class_1889(enchantment, i)));
        }
    }

    public static List<class_1889> allAllowedEnchantsWithoutMaxLimit(int level, class_1799 stack, int xpTier) {
        ArrayList list = Lists.newArrayList();
        boolean bookFlag = stack.method_31574(class_1802.field_8529) || stack.method_31574(class_1802.field_8598);
        boolean allowTreasure = xpTier == 7;
        Map<class_1887, Integer> existingEnchantments = EnchantmentUtils.getEnchantmentsOnBook(stack);
        block0: for (class_1887 enchantment : class_7923.field_41176) {
            boolean forceAllowed = GeneralUtils.isInTag(class_7923.field_41176, BzTags.FORCED_ALLOWED_CRYSTALLINE_FLOWER_ENCHANTMENTS, enchantment);
            boolean disallowed = GeneralUtils.isInTag(class_7923.field_41176, BzTags.DISALLOWED_CRYSTALLINE_FLOWER_ENCHANTMENTS, enchantment);
            if (!forceAllowed && disallowed) continue;
            int minLevelAllowed = enchantment.method_8187();
            if (existingEnchantments.containsKey(enchantment)) {
                minLevelAllowed = Math.max(minLevelAllowed, existingEnchantments.get(enchantment) + 1);
            }
            if (enchantment.method_8193() && !allowTreasure || !forceAllowed && !enchantment.method_25950() || !EnchantmentUtils.canApplyAtEnchantingTable(enchantment, stack) && (!bookFlag || !EnchantmentUtils.isAllowedOnBooks(enchantment))) continue;
            for (int i = enchantment.method_8183(); i > minLevelAllowed - 1; --i) {
                class_1889 enchantmentInstance;
                if (!forceAllowed && level < enchantment.method_8182(i) || xpTier <= EnchantmentUtils.getEnchantmentTierCost(enchantmentInstance = new class_1889(enchantment, xpTier <= 2 ? 1 : i))) continue;
                list.add(enchantmentInstance);
                continue block0;
            }
        }
        list.sort(EnchantmentUtils::compareEnchantments);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @Contract(pure=true)
    @ExpectPlatform.Transformed
    public static boolean canApplyAtEnchantingTable(class_1887 enchantment, class_1799 stack) {
        void var1_1;
        return EnchantmentUtilsImpl.canApplyAtEnchantingTable(enchantment, (class_1799)var1_1);
    }

    @ExpectPlatform
    @Contract(pure=true)
    @ExpectPlatform.Transformed
    public static boolean isAllowedOnBooks(class_1887 enchantment) {
        return EnchantmentUtilsImpl.isAllowedOnBooks(enchantment);
    }

    public static Map<class_1887, Integer> getEnchantmentsOnBook(class_1799 itemStack) {
        class_2499 listtag = class_1772.method_7806((class_1799)itemStack);
        Object2IntOpenHashMap existingEnchants = new Object2IntOpenHashMap();
        for (int i = 0; i < listtag.size(); ++i) {
            class_2487 compoundtag = listtag.method_10602(i);
            class_2960 resourcelocation1 = class_1890.method_37427((class_2487)compoundtag);
            if (resourcelocation1 == null) continue;
            existingEnchants.put(Objects.requireNonNull((class_1887)class_7923.field_41176.method_10223(resourcelocation1)), class_1890.method_37424((class_2487)compoundtag));
        }
        return existingEnchants;
    }

    public static int getEnchantmentTierCost(class_1889 enchantmentInstance) {
        return EnchantmentUtils.getEnchantmentTierCost(enchantmentInstance.field_9094, enchantmentInstance.field_9093.method_8182(2), enchantmentInstance.field_9093.method_8193(), enchantmentInstance.field_9093.method_8195());
    }

    public static int getEnchantmentTierCost(int level, int minCost, boolean isTreasureOnly, boolean isCurse) {
        int cost = 0;
        cost += minCost / 10;
        cost = (int)((float)cost + (float)level / 1.5f);
        if (isTreasureOnly) {
            cost += 2;
        }
        if (isCurse) {
            cost -= 3;
        }
        return Math.max(1, Math.min(6, cost += BzGeneralConfigs.crystallineFlowerExtraTierCost));
    }

    public static int compareEnchantments(class_1889 enchantment1, class_1889 enchantment2) {
        class_5321 resourceKey1 = (class_5321)class_7923.field_41176.method_29113((Object)enchantment2.field_9093).get();
        class_5321 resourceKey2 = (class_5321)class_7923.field_41176.method_29113((Object)enchantment1.field_9093).get();
        int ret = resourceKey2.method_29177().method_12832().compareTo(resourceKey1.method_29177().method_12832());
        if (ret == 0) {
            ret = enchantment2.field_9094 - enchantment1.field_9094;
        }
        return ret;
    }
}

