/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline.v2.stage.mutators;

import com.dfsek.terra.addons.biome.pipeline.v2.api.Stage;
import com.dfsek.terra.addons.biome.pipeline.v2.api.biome.PipelineBiome;
import com.dfsek.terra.addons.biome.pipeline.v2.pipeline.BiomeChunkImpl;
import com.dfsek.terra.api.noise.NoiseSampler;
import com.dfsek.terra.api.util.collection.ProbabilityCollection;
import java.util.HashSet;
import java.util.stream.Stream;

public class ReplaceStage
implements Stage {
    private final String replaceableTag;
    private final ProbabilityCollection<PipelineBiome> replace;
    private final NoiseSampler sampler;

    public ReplaceStage(String replaceable, ProbabilityCollection<PipelineBiome> replace, NoiseSampler sampler) {
        this.replaceableTag = replaceable;
        this.replace = replace;
        this.sampler = sampler;
    }

    @Override
    public PipelineBiome apply(BiomeChunkImpl.ViewPoint viewPoint) {
        if (viewPoint.getBiome().getTags().contains(this.replaceableTag)) {
            PipelineBiome biome = (PipelineBiome)this.replace.get(this.sampler, (double)viewPoint.worldX(), (double)viewPoint.worldZ(), viewPoint.worldSeed());
            return biome.isSelf() ? viewPoint.getBiome() : biome;
        }
        return viewPoint.getBiome();
    }

    @Override
    public int maxRelativeReadDistance() {
        return 0;
    }

    @Override
    public Iterable<PipelineBiome> getBiomes(Iterable<PipelineBiome> biomes) {
        HashSet<PipelineBiome> biomeSet = new HashSet<PipelineBiome>();
        HashSet reject = new HashSet();
        biomes.forEach(biome -> {
            if (!biome.getTags().contains(this.replaceableTag)) {
                biomeSet.add((PipelineBiome)biome);
            } else {
                reject.add(biome);
            }
        });
        biomeSet.addAll(this.replace.getContents().stream().flatMap(terraBiome -> {
            if (terraBiome.isSelf()) {
                return reject.stream();
            }
            return Stream.of(terraBiome);
        }).toList());
        return biomeSet;
    }
}

