/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.util;

import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_4838;
import net.minecraft.class_5251;
import net.zestyblaze.lootr.api.blockentity.ILootBlockEntity;
import net.zestyblaze.lootr.blocks.LootrBarrelBlock;
import net.zestyblaze.lootr.blocks.LootrChestBlock;
import net.zestyblaze.lootr.blocks.LootrShulkerBlock;
import net.zestyblaze.lootr.blocks.entities.LootrInventoryBlockEntity;
import net.zestyblaze.lootr.config.LootrModConfig;
import net.zestyblaze.lootr.data.DataStorage;
import net.zestyblaze.lootr.data.SpecialChestInventory;
import net.zestyblaze.lootr.entity.LootrChestMinecartEntity;
import net.zestyblaze.lootr.network.NetworkConstants;
import net.zestyblaze.lootr.registry.LootrAdvancementsInit;
import net.zestyblaze.lootr.registry.LootrStatsInit;

public class ChestUtil {
    public static boolean handleLootSneak(class_2248 block, class_1937 level, class_2338 pos, class_1657 player) {
        if (level.method_8608()) {
            return false;
        }
        if (player.method_7325()) {
            return false;
        }
        class_2586 te = level.method_8321(pos);
        if (te instanceof ILootBlockEntity) {
            ILootBlockEntity tile = (ILootBlockEntity)te;
            tile.getOpeners().remove(player.method_5667());
            te.method_5431();
            tile.updatePacketViaState();
            return true;
        }
        return false;
    }

    public static void handleLootCartSneak(class_1937 level, LootrChestMinecartEntity cart, class_1657 player) {
        if (level.method_8608()) {
            return;
        }
        if (player.method_7325()) {
            return;
        }
        cart.getOpeners().remove(player.method_5667());
        NetworkConstants.sendCloseCart(cart.method_5628(), (class_3222)player);
    }

    public static boolean handleLootChest(class_2248 block, class_1937 level, class_2338 pos, class_1657 player) {
        if (level.method_8608()) {
            return false;
        }
        if (player.method_7325()) {
            player.method_17355(null);
            return false;
        }
        class_2586 te = level.method_8321(pos);
        if (te instanceof ILootBlockEntity) {
            int refreshValue;
            ILootBlockEntity tile = (ILootBlockEntity)te;
            UUID tileId = tile.getTileId();
            if (DataStorage.isDecayed(tileId)) {
                level.method_22352(pos, true);
                player.method_7353((class_2561)class_2561.method_43471((String)"lootr.message.decayed").method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1061)).method_10982(Boolean.valueOf(true))), true);
                DataStorage.removeDecayed(tileId);
                return false;
            }
            int decayValue = DataStorage.getDecayValue(tileId);
            if (decayValue > 0 && LootrModConfig.shouldNotify(decayValue)) {
                player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.decay_in", (Object[])new Object[]{decayValue / 20}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1061)).method_10982(Boolean.valueOf(true))), true);
            } else if (decayValue == -1 && LootrModConfig.isDecaying((class_3218)level, (ILootBlockEntity)te)) {
                DataStorage.setDecaying(tileId, LootrModConfig.get().decay.decay_value);
                player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.decay_start", (Object[])new Object[]{LootrModConfig.get().decay.decay_value / 20}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1061)).method_10982(Boolean.valueOf(true))), true);
            }
            if (block instanceof LootrBarrelBlock) {
                LootrAdvancementsInit.BARREL_PREDICATE.trigger((class_3222)player, ((ILootBlockEntity)te).getTileId());
            } else if (block instanceof LootrChestBlock) {
                LootrAdvancementsInit.CHEST_PREDICATE.trigger((class_3222)player, ((ILootBlockEntity)te).getTileId());
            } else if (block instanceof LootrShulkerBlock) {
                LootrAdvancementsInit.SHULKER_PREDICATE.trigger((class_3222)player, ((ILootBlockEntity)te).getTileId());
            }
            if (DataStorage.isRefreshed(tileId)) {
                DataStorage.refreshInventory(level, pos, ((ILootBlockEntity)te).getTileId(), (class_3222)player);
                DataStorage.removeRefreshed(tileId);
                player.method_7353((class_2561)class_2561.method_43471((String)"lootr.message.refreshed").method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1078)).method_10982(Boolean.valueOf(true))), true);
            }
            if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && LootrModConfig.shouldNotify(refreshValue)) {
                player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1078)).method_10982(Boolean.valueOf(true))), true);
            } else if (refreshValue == -1 && LootrModConfig.isRefreshing((class_3218)level, (ILootBlockEntity)te)) {
                DataStorage.setRefreshing(tileId, LootrModConfig.get().refresh.refresh_value);
                player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.refresh_start", (Object[])new Object[]{LootrModConfig.get().refresh.refresh_value / 20}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1078)).method_10982(Boolean.valueOf(true))), true);
            }
            SpecialChestInventory provider = DataStorage.getInventory(level, ((ILootBlockEntity)te).getTileId(), pos, (class_3222)player, (class_2621)te, ((ILootBlockEntity)te)::unpackLootTable);
            if (!DataStorage.isScored(player.method_5667(), ((ILootBlockEntity)te).getTileId())) {
                player.method_7259(LootrStatsInit.LOOTED_STAT);
                LootrAdvancementsInit.SCORE_PREDICATE.trigger((class_3222)player, null);
                DataStorage.score(player.method_5667(), ((ILootBlockEntity)te).getTileId());
            }
            if (tile.getOpeners().add(player.method_5667())) {
                te.method_5431();
                tile.updatePacketViaState();
            }
            player.method_17355((class_3908)provider);
            class_4838.method_24733((class_1657)player, (boolean)true);
            return true;
        }
        return false;
    }

    public static void handleLootCart(class_1937 level, LootrChestMinecartEntity cart, class_1657 player) {
        if (!level.method_8608()) {
            if (player.method_7325()) {
                player.method_17355(null);
            } else {
                int refreshValue;
                LootrAdvancementsInit.CART_PREDICATE.trigger((class_3222)player, cart.method_5667());
                UUID tileId = cart.method_5667();
                if (DataStorage.isDecayed(tileId)) {
                    cart.method_7516(cart.method_48923().method_48829());
                    player.method_7353((class_2561)class_2561.method_43471((String)"lootr.message.decayed").method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1061)).method_10982(Boolean.valueOf(true))), true);
                    DataStorage.removeDecayed(tileId);
                    return;
                }
                int decayValue = DataStorage.getDecayValue(tileId);
                if (decayValue > 0 && LootrModConfig.shouldNotify(decayValue)) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.decay_in", (Object[])new Object[]{decayValue / 20}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1061)).method_10982(Boolean.valueOf(true))), true);
                } else if (decayValue == -1 && LootrModConfig.isDecaying((class_3218)level, cart)) {
                    DataStorage.setDecaying(tileId, LootrModConfig.get().decay.decay_value);
                    player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.decay_start", (Object[])new Object[]{LootrModConfig.get().decay.decay_value / 20}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1061)).method_10982(Boolean.valueOf(true))), true);
                }
                if (!cart.getOpeners().contains(player.method_5667())) {
                    cart.addOpener(player);
                }
                if (!DataStorage.isScored(player.method_5667(), cart.method_5667())) {
                    player.method_7259(LootrStatsInit.LOOTED_STAT);
                    LootrAdvancementsInit.SCORE_PREDICATE.trigger((class_3222)player, null);
                    DataStorage.score(player.method_5667(), cart.method_5667());
                }
                if (DataStorage.isRefreshed(tileId)) {
                    DataStorage.refreshInventory(level, cart, (class_3222)player);
                    DataStorage.removeRefreshed(tileId);
                    player.method_7353((class_2561)class_2561.method_43471((String)"lootr.message.refreshed").method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1078)).method_10982(Boolean.valueOf(true))), true);
                }
                if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && LootrModConfig.shouldNotify(refreshValue)) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1078)).method_10982(Boolean.valueOf(true))), true);
                } else if (refreshValue == -1 && LootrModConfig.isRefreshing((class_3218)level, cart)) {
                    DataStorage.setRefreshing(tileId, LootrModConfig.get().refresh.refresh_value);
                    player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.refresh_start", (Object[])new Object[]{LootrModConfig.get().refresh.refresh_value / 20}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1078)).method_10982(Boolean.valueOf(true))), true);
                }
                SpecialChestInventory provider = DataStorage.getInventory(level, cart, (class_3222)player, cart::addLoot);
                player.method_17355((class_3908)provider);
            }
        }
    }

    public static boolean handleLootInventory(class_2248 block, class_1937 level, class_2338 pos, class_1657 player) {
        if (level.method_8608()) {
            return false;
        }
        if (player.method_7325()) {
            player.method_17355(null);
            return false;
        }
        class_2586 te = level.method_8321(pos);
        if (te instanceof LootrInventoryBlockEntity) {
            int refreshValue;
            UUID tileId;
            LootrInventoryBlockEntity tile = (LootrInventoryBlockEntity)te;
            LootrAdvancementsInit.CHEST_PREDICATE.trigger((class_3222)player, tile.getTileId());
            class_2371<class_1799> stacks = null;
            if (tile.getCustomInventory() != null) {
                stacks = ChestUtil.copyItemList(tile.getCustomInventory());
            }
            if (DataStorage.isRefreshed(tileId = tile.getTileId())) {
                DataStorage.refreshInventory(level, pos, ((ILootBlockEntity)te).getTileId(), stacks, (class_3222)player);
                DataStorage.removeRefreshed(tileId);
                player.method_7353((class_2561)class_2561.method_43471((String)"lootr.message.refreshed").method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1078)).method_10982(Boolean.valueOf(true))), true);
            }
            if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && LootrModConfig.shouldNotify(refreshValue)) {
                player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1078)).method_10982(Boolean.valueOf(true))), true);
            } else if (refreshValue == -1 && LootrModConfig.isRefreshing((class_3218)level, tile)) {
                DataStorage.setRefreshing(tileId, LootrModConfig.get().refresh.refresh_value);
                player.method_7353((class_2561)class_2561.method_43469((String)"lootr.message.refresh_start", (Object[])new Object[]{LootrModConfig.get().refresh.refresh_value / 20}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1078)).method_10982(Boolean.valueOf(true))), true);
            }
            SpecialChestInventory provider = DataStorage.getInventory(level, tile.getTileId(), stacks, (class_3222)player, pos, (class_2621)tile);
            if (!DataStorage.isScored(player.method_5667(), ((ILootBlockEntity)te).getTileId())) {
                player.method_7259(LootrStatsInit.LOOTED_STAT);
                LootrAdvancementsInit.SCORE_PREDICATE.trigger((class_3222)player, null);
                DataStorage.score(player.method_5667(), ((ILootBlockEntity)te).getTileId());
            }
            if (tile.getOpeners().add(player.method_5667())) {
                te.method_5431();
                tile.updatePacketViaState();
            }
            player.method_17355((class_3908)provider);
            class_4838.method_24733((class_1657)player, (boolean)true);
            return true;
        }
        return false;
    }

    public static class_2371<class_1799> copyItemList(class_2371<class_1799> reference) {
        class_2371 contents = class_2371.method_10213((int)reference.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < reference.size(); ++i) {
            contents.set(i, (Object)((class_1799)reference.get(i)).method_7972());
        }
        return contents;
    }
}

