/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.commands.packs;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.CommandManager;
import com.dfsek.terra.addons.manifest.api.AddonInitializer;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.addon.BaseAddon;
import com.dfsek.terra.api.command.CommandSender;
import com.dfsek.terra.api.command.arguments.RegistryArgument;
import com.dfsek.terra.api.config.ConfigPack;
import com.dfsek.terra.api.event.events.platform.CommandRegistrationEvent;
import com.dfsek.terra.api.event.functional.FunctionalEventHandler;
import com.dfsek.terra.api.inject.annotations.Inject;
import com.dfsek.terra.api.registry.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacksCommandAddon
implements AddonInitializer {
    private static final Logger logger = LoggerFactory.getLogger(PacksCommandAddon.class);
    @Inject
    private Platform platform;
    @Inject
    private BaseAddon addon;

    public void initialize() {
        ((FunctionalEventHandler)this.platform.getEventManager().getHandler(FunctionalEventHandler.class)).register(this.addon, CommandRegistrationEvent.class).then(event -> {
            CommandManager manager = event.getCommandManager();
            manager.command(manager.commandBuilder("packs", ArgumentDescription.of((String)"List installed config packs"), new String[0]).permission("terra.packs").handler(context -> {
                StringBuilder packs = new StringBuilder("Installed packs:\n");
                this.platform.getConfigRegistry().forEach(pack -> packs.append(" - ").append(pack.getID()).append('@').append(pack.getVersion().getFormatted()));
                ((CommandSender)context.getSender()).sendMessage(packs.toString());
            })).command(manager.commandBuilder("packs", new String[0]).literal("info", ArgumentDescription.of((String)"Get information about a pack"), new String[0]).permission("terra.packs.info").argument(RegistryArgument.of((String)"pack", (Registry)this.platform.getConfigRegistry())).handler(context -> {
                ConfigPack pack = (ConfigPack)context.get("pack");
                StringBuilder packInfo = new StringBuilder("Pack ").append(pack.getID()).append('\n');
                packInfo.append("Version: ").append(pack.getVersion().getFormatted()).append('\n');
                packInfo.append("Author: ").append(pack.getAuthor()).append('\n');
                packInfo.append("Addon Dependencies:\n");
                pack.addons().forEach((id, versions) -> packInfo.append(" - ").append(id.getID()).append('@').append(versions.getFormatted()).append('\n'));
                ((CommandSender)context.getSender()).sendMessage(packInfo.toString());
            })).command(manager.commandBuilder("packs", new String[0]).literal("reload", ArgumentDescription.of((String)"Reload config packs"), new String[0]).permission("terra.packs.reload").handler(context -> {
                ((CommandSender)context.getSender()).sendMessage("Reloading Terra...");
                logger.info("Reloading Terra...");
                if (this.platform.reload()) {
                    logger.info("Terra reloaded successfully.");
                    ((CommandSender)context.getSender()).sendMessage("Terra reloaded successfully.");
                } else {
                    logger.error("Terra failed to reload.");
                    ((CommandSender)context.getSender()).sendMessage("Terra failed to reload. See logs for more information.");
                }
            }));
        });
    }
}

