/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.smwyg;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.smwyg.MessageItemList;
import io.github.apace100.smwyg.SmwygItemMatch;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.message.v1.ServerMessageDecoratorEvent;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowMeWhatYouGot
implements ModInitializer {
    public static final String MODID = "smwyg";
    public static final Logger LOGGER = LogManager.getLogger(ShowMeWhatYouGot.class);
    public static final class_2960 PACKET_ID = new class_2960("smwyg", "share_item");
    public static final String HIDE_STACK_NBT = "smwyg:hide_stack";
    public static final MessageItemList MESSAGE_ITEM_LIST = new MessageItemList();
    private static final Pattern ITEM_REGEX = Pattern.compile("\\[\\[smwyg:(?<item>.*)\\]\\]");

    public void onInitialize() {
        ServerMessageDecoratorEvent.EVENT.register(ServerMessageDecoratorEvent.CONTENT_PHASE, (sender, message) -> {
            Optional<SmwygItemMatch> itemMatch = MESSAGE_ITEM_LIST.get(sender);
            if (itemMatch.isEmpty()) {
                return CompletableFuture.completedFuture(message);
            }
            return CompletableFuture.completedFuture(ShowMeWhatYouGot.decorateMessage(message, itemMatch.get()));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PACKET_ID, (minecraftServer, serverPlayerEntity, serverPlayNetworkHandler, packetByteBuf, packetSender) -> {
            int start = packetByteBuf.method_10816();
            int end = packetByteBuf.method_10816();
            class_2487 nbt = packetByteBuf.method_10798();
            class_1799 stack = class_1799.method_7915((class_2487)nbt);
            minecraftServer.execute(() -> {
                SmwygItemMatch itemMatch = new SmwygItemMatch();
                itemMatch.stack = stack;
                itemMatch.start = start;
                itemMatch.end = end;
                MESSAGE_ITEM_LIST.add(serverPlayerEntity, itemMatch);
            });
        });
    }

    public static boolean hasSmwygItem(String text) {
        Matcher matcher = ITEM_REGEX.matcher(text);
        return matcher.find();
    }

    public static SmwygItemMatch extractItem(String text) {
        Matcher matcher = ITEM_REGEX.matcher(text);
        if (!matcher.find()) {
            return null;
        }
        String itemNbt = matcher.group("item");
        int start = matcher.start();
        int end = matcher.end();
        SmwygItemMatch itemMatch = new SmwygItemMatch();
        itemMatch.start = start;
        itemMatch.end = end;
        try {
            class_2487 nbt = new class_2522(new StringReader(itemNbt)).method_10727();
            itemMatch.stack = class_1799.method_7915((class_2487)nbt);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return itemMatch;
    }

    public static class_2561 decorateMessage(class_2561 message, SmwygItemMatch itemMatch) {
        if (itemMatch == null || itemMatch.stack == null) {
            return message;
        }
        String msgContent = message.getString();
        class_5250 resultText = class_2561.method_43470((String)msgContent.substring(0, itemMatch.start));
        resultText.method_10852(itemMatch.stack.method_7954());
        resultText.method_10852((class_2561)class_2561.method_43470((String)msgContent.substring(itemMatch.end)));
        return resultText;
    }
}

