/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.disenchanter;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonlib.mixin.AdvancementBehaviourAccessor;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.disenchanter.DisenchanterItemHandler;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.disenchanter.Disenchanting;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.Enchanting;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.ExperienceFluid;
import plus.dragons.createenchantmentindustry.entry.CeiFluids;
import plus.dragons.createenchantmentindustry.foundation.advancement.CeiAdvancements;
import plus.dragons.createenchantmentindustry.foundation.advancement.CeiTriggers;
import plus.dragons.createenchantmentindustry.foundation.config.CeiConfigs;

public class DisenchanterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
SidedStorageBlockEntity {
    public static final int DISENCHANTER_TIME = 10;
    private static final int ABSORB_AMOUNT = 100;
    SmartFluidTankBehaviour internalTank;
    TransportedItemStack heldItem;
    int processingTicks;
    Map<class_2350, DisenchanterItemHandler> itemHandlers;
    class_238 absorbArea;
    SnapshotParticipant<TransportedItemStack> snapshotParticipant = new SnapshotParticipant<TransportedItemStack>(){

        protected TransportedItemStack createSnapshot() {
            return DisenchanterBlockEntity.this.heldItem == null ? TransportedItemStack.EMPTY : DisenchanterBlockEntity.this.heldItem.fullCopy();
        }

        protected void readSnapshot(TransportedItemStack snapshot) {
            DisenchanterBlockEntity.this.heldItem = snapshot == TransportedItemStack.EMPTY ? null : snapshot;
        }

        protected void onFinalCommit() {
            DisenchanterBlockEntity.this.notifyUpdate();
        }
    };

    public DisenchanterBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.itemHandlers = new IdentityHashMap<class_2350, DisenchanterItemHandler>();
        for (class_2350 d : Iterate.horizontalDirections) {
            this.itemHandlers.put(d, new DisenchanterItemHandler(this, d));
        }
        this.absorbArea = new class_238(pos.method_10084());
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.internalTank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (long)((long)((Integer)CeiConfigs.SERVER.disenchanterTankCapacity.get()).intValue() * 81L)).allowExtraction().forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.internalTank);
        this.internalTank.getPrimaryHandler().setValidator(fluidStack -> true);
        this.registerAwardables(behaviours, new CreateAdvancement[]{CeiAdvancements.EXPERIMENTAL.asCreateAdvancement(), CeiAdvancements.GONE_WITH_THE_FOIL.asCreateAdvancement()});
    }

    public void tick() {
        boolean onClient;
        super.tick();
        boolean bl = onClient = this.field_11863.field_9236 && !this.isVirtual();
        if (!onClient && this.field_11863.method_8510() % 10L == 0L) {
            this.absorbExperienceFromWorld();
        }
        if (this.heldItem == null) {
            this.processingTicks = 0;
            return;
        }
        if (this.processingTicks > 0) {
            boolean wasAtBeginning;
            this.heldItem.prevBeltPosition = 0.5f;
            boolean bl2 = wasAtBeginning = this.processingTicks == 10;
            if (!onClient || this.processingTicks < 10) {
                --this.processingTicks;
            }
            if (!this.continueProcessing()) {
                this.processingTicks = 0;
                this.notifyUpdate();
                return;
            }
            if (wasAtBeginning != (this.processingTicks == 10)) {
                this.sendData();
            }
            return;
        }
        this.heldItem.prevBeltPosition = this.heldItem.beltPosition;
        this.heldItem.prevSideOffset = this.heldItem.sideOffset;
        this.heldItem.beltPosition += this.itemMovementPerTick();
        if (this.heldItem.beltPosition > 1.0f) {
            class_2338 nextPosition;
            DirectBeltInputBehaviour directBeltInputBehaviour;
            this.heldItem.beltPosition = 1.0f;
            if (onClient) {
                return;
            }
            class_2350 side = this.heldItem.insertedFrom;
            class_1799 tryExportingToBeltFunnel = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(this.heldItem.stack, side.method_10153(), false);
            if (tryExportingToBeltFunnel != null) {
                if (tryExportingToBeltFunnel.method_7947() != this.heldItem.stack.method_7947()) {
                    if (tryExportingToBeltFunnel.method_7960()) {
                        this.heldItem = null;
                    } else {
                        this.heldItem.stack = tryExportingToBeltFunnel;
                    }
                    this.notifyUpdate();
                    return;
                }
                if (!tryExportingToBeltFunnel.method_7960()) {
                    return;
                }
            }
            if ((directBeltInputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((class_1922)this.field_11863, (class_2338)(nextPosition = this.field_11867.method_10093(side)), (BehaviourType)DirectBeltInputBehaviour.TYPE)) == null) {
                if (!BlockHelper.hasBlockSolidSide((class_2680)this.field_11863.method_8320(nextPosition), (class_1922)this.field_11863, (class_2338)nextPosition, (class_2350)side.method_10153())) {
                    class_1799 ejected = this.heldItem.stack;
                    class_243 outPos = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(class_243.method_24954((class_2382)side.method_10163()).method_1021(0.75));
                    float movementSpeed = this.itemMovementPerTick();
                    class_243 outMotion = class_243.method_24954((class_2382)side.method_10163()).method_1021((double)movementSpeed).method_1031(0.0, 0.125, 0.0);
                    outPos.method_1019(outMotion.method_1029());
                    class_1542 entity = new class_1542(this.field_11863, outPos.field_1352, outPos.field_1351 + 0.375, outPos.field_1350, ejected);
                    entity.method_18799(outMotion);
                    entity.method_6988();
                    entity.field_6037 = true;
                    this.field_11863.method_8649((class_1297)entity);
                    this.heldItem = null;
                    this.notifyUpdate();
                }
                return;
            }
            if (!directBeltInputBehaviour.canInsertFromSide(side)) {
                return;
            }
            class_1799 returned = directBeltInputBehaviour.handleInsertion(this.heldItem.copy(), side, false);
            if (returned.method_7960()) {
                this.heldItem = null;
                this.notifyUpdate();
                return;
            }
            if (returned.method_7947() != this.heldItem.stack.method_7947()) {
                this.heldItem.stack = returned;
                this.notifyUpdate();
                return;
            }
            return;
        }
        if (this.heldItem.prevBeltPosition < 0.5f && this.heldItem.beltPosition >= 0.5f) {
            if (Disenchanting.disenchantResult(this.heldItem.stack.method_7972(), this.field_11863) == null) {
                return;
            }
            this.heldItem.beltPosition = 0.5f;
            if (onClient) {
                return;
            }
            this.processingTicks = 10;
            this.sendData();
        }
    }

    protected void absorbExperienceFromWorld() {
        List experienceOrbs;
        boolean absorbedXp = false;
        List players = this.field_11863.method_8390(class_1657.class, this.absorbArea, class_1309::method_5805);
        if (!players.isEmpty()) {
            AtomicInteger sum = new AtomicInteger();
            players.forEach(player -> {
                if (this.getPlayerExperience((class_1657)player) >= 100) {
                    sum.addAndGet(100);
                } else if (this.getPlayerExperience((class_1657)player) != 0) {
                    sum.addAndGet(this.getPlayerExperience((class_1657)player));
                }
            });
            if (sum.get() != 0) {
                FluidStack fluidStack = new FluidStack(((ExperienceFluid)((Object)CeiFluids.EXPERIENCE.get())).method_15751(), (long)sum.get() * 81L);
                try (Transaction t = TransferUtil.getTransaction();){
                    this.internalTank.allowInsertion();
                    long inserted = this.internalTank.getPrimaryHandler().insert(fluidStack.getType(), fluidStack.getAmount(), (TransactionContext)t) / 81L;
                    t.commit();
                    if (inserted != 0L) {
                        for (class_1657 player2 : players) {
                            int total = this.getPlayerExperience(player2);
                            if (inserted >= 100L) {
                                if (total >= 100) {
                                    player2.method_7255(-100);
                                    inserted -= 100L;
                                } else if (total != 0) {
                                    inserted -= (long)total;
                                    player2.method_7255(-total);
                                }
                                CeiAdvancements.SPIRIT_TAKING.getTrigger().trigger((class_3222)player2);
                                continue;
                            }
                            if (inserted <= 0L) break;
                            if ((long)total >= inserted) {
                                player2.method_7255((int)(-inserted));
                                inserted = 0L;
                            } else {
                                inserted -= (long)total;
                                player2.method_7255(-total);
                            }
                            absorbedXp = true;
                            CeiAdvancements.SPIRIT_TAKING.getTrigger().trigger((class_3222)player2);
                        }
                    }
                    this.internalTank.forbidInsertion();
                }
            }
        }
        if (!(experienceOrbs = this.field_11863.method_18467(class_1303.class, this.absorbArea)).isEmpty()) {
            this.internalTank.allowInsertion();
            for (class_1303 orb : experienceOrbs) {
                int amount = orb.field_6159;
                FluidStack fluidStack = new FluidStack(((ExperienceFluid)((Object)CeiFluids.EXPERIENCE.get())).method_15751(), (long)(amount * 81));
                Transaction t = TransferUtil.getTransaction();
                try {
                    long inserted = this.internalTank.getPrimaryHandler().insert(fluidStack.getType(), fluidStack.getAmount(), (TransactionContext)t) / 81L;
                    t.commit();
                    if (inserted == (long)amount) {
                        absorbedXp = true;
                        orb.method_5650(class_1297.class_5529.field_26999);
                        continue;
                    }
                    if (inserted == 0L) break;
                    absorbedXp = true;
                    orb.field_6159 = (int)((long)orb.field_6159 - inserted);
                    break;
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            this.internalTank.forbidInsertion();
        }
        if (absorbedXp) {
            this.award(CeiAdvancements.EXPERIMENTAL.asCreateAdvancement());
        }
    }

    private int getPlayerExperience(class_1657 player) {
        int level = player.field_7520;
        if (player.field_7520 == 0 && player.field_7510 == 0.0f) {
            return 0;
        }
        int total = Enchanting.expPointFromLevel(level);
        int bar = (int)((float)total + player.field_7510 * (float)player.method_7349());
        return Math.max(bar, 1);
    }

    protected boolean continueProcessing() {
        class_1657 player;
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return true;
        }
        if (this.processingTicks < 5) {
            return true;
        }
        if (this.heldItem.stack.method_7947() <= 0) {
            return false;
        }
        Pair<FluidStack, class_1799> result = Disenchanting.disenchantResult(this.heldItem.stack, this.field_11863);
        if (result == null) {
            return false;
        }
        FluidStack xp = (FluidStack)result.getFirst();
        xp.setAmount(xp.getAmount() * (long)this.heldItem.stack.method_7947());
        if (this.processingTicks > 5) {
            try (Transaction t = TransferUtil.getTransaction();){
                this.internalTank.allowInsertion();
                if (this.internalTank.getPrimaryHandler().simulateInsert((Object)xp.getType(), xp.getAmount(), (TransactionContext)t) != xp.getAmount()) {
                    this.internalTank.forbidInsertion();
                    this.processingTicks = 10;
                    boolean bl = true;
                    return bl;
                }
                this.internalTank.forbidInsertion();
            }
            return true;
        }
        this.award(CeiAdvancements.EXPERIMENTAL.asCreateAdvancement());
        this.award(CeiAdvancements.GONE_WITH_THE_FOIL.asCreateAdvancement());
        AdvancementBehaviour advancementBehaviour = (AdvancementBehaviour)this.getBehaviour(AdvancementBehaviour.TYPE);
        UUID playerId = ((AdvancementBehaviourAccessor)advancementBehaviour).getPlayerId();
        if (playerId != null && (player = this.field_11863.method_18470(playerId)) != null) {
            CeiTriggers.DISENCHANTED.trigger(player, (int)xp.getAmount());
        }
        class_1799 resultItem = (class_1799)result.getSecond();
        resultItem.method_7939(this.heldItem.stack.method_7947());
        this.heldItem.stack = resultItem;
        try (Transaction t = TransferUtil.getTransaction();){
            this.internalTank.allowInsertion();
            this.internalTank.getPrimaryHandler().insert(xp.getType(), xp.getAmount(), (TransactionContext)t);
            t.commit();
            this.internalTank.forbidInsertion();
        }
        this.field_11863.method_20290(1042, this.field_11867, 0);
        this.notifyUpdate();
        return true;
    }

    private float itemMovementPerTick() {
        return 0.125f;
    }

    public SmartFluidTankBehaviour getInternalTank() {
        return this.internalTank;
    }

    private class_1799 tryInsertingFromSide(TransportedItemStack transportedStack, class_2350 side, boolean simulate) {
        class_1799 inserted = transportedStack.stack;
        class_1799 returned = class_1799.field_8037;
        if (!this.getHeldItemStack().method_7960()) {
            return inserted;
        }
        class_1799 disenchanted = Disenchanting.disenchantAndInsert(this, transportedStack.stack, simulate);
        if (!class_1799.method_7973((class_1799)transportedStack.stack, (class_1799)disenchanted)) {
            return disenchanted;
        }
        if (inserted.method_7947() > 1 && Disenchanting.disenchantResult(inserted, this.field_11863) != null) {
            returned = ItemHandlerHelper.copyStackWithSize((class_1799)inserted, (int)(inserted.method_7947() - 1));
            inserted = ItemHandlerHelper.copyStackWithSize((class_1799)inserted, (int)1);
        }
        if (simulate) {
            return returned;
        }
        transportedStack = transportedStack.copy();
        transportedStack.stack = inserted.method_7972();
        transportedStack.beltPosition = side.method_10166().method_10178() ? 0.5f : 0.0f;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        this.setHeldItem(transportedStack, side);
        this.method_5431();
        this.sendData();
        return returned;
    }

    public class_1799 getHeldItemStack() {
        return this.heldItem == null ? class_1799.field_8037 : this.heldItem.stack;
    }

    public void setHeldItem(TransportedItemStack heldItem, class_2350 insertedFrom) {
        this.heldItem = heldItem;
        this.heldItem.insertedFrom = insertedFrom;
    }

    public void invalidate() {
        super.invalidate();
    }

    public void destroy() {
        super.destroy();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            SmartFluidTank tank;
            FluidStack fluidStack;
            class_3611 class_36112;
            class_3218 serverLevel = (class_3218)class_19372;
            class_1799 heldItemStack = this.getHeldItemStack();
            if (!heldItemStack.method_7960()) {
                class_1264.method_5449((class_1937)this.field_11863, (double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260(), (class_1799)heldItemStack);
            }
            if ((class_36112 = (fluidStack = (tank = this.getInternalTank().getPrimaryHandler()).getFluid()).getFluid()) instanceof ExperienceFluid) {
                ExperienceFluid expFluid = (ExperienceFluid)class_36112;
                expFluid.drop(serverLevel, VecHelper.getCenterOf((class_2382)this.method_11016()), (int)fluidStack.getAmount());
            }
        }
    }

    public void write(class_2487 compoundTag, boolean clientPacket) {
        compoundTag.method_10569("ProcessingTicks", this.processingTicks);
        if (this.heldItem != null) {
            compoundTag.method_10566("HeldItem", (class_2520)this.heldItem.serializeNBT());
        }
        super.write(compoundTag, clientPacket);
    }

    protected void read(class_2487 compoundTag, boolean clientPacket) {
        this.heldItem = null;
        this.processingTicks = compoundTag.method_10550("ProcessingTicks");
        if (compoundTag.method_10545("HeldItem")) {
            this.heldItem = TransportedItemStack.read((class_2487)compoundTag.method_10562("HeldItem"));
        }
        super.read(compoundTag, clientPacket);
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getFluidStorage(null));
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(class_2350 side) {
        if (side != class_2350.field_11036) {
            return this.internalTank.getCapability();
        }
        return null;
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(class_2350 side) {
        if (side != null && side.method_10166().method_10179()) {
            return (Storage)this.itemHandlers.get(side);
        }
        return null;
    }
}

