/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.BlazeEnchanterBlock;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.Enchanting;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.EnchantingGuideMenu;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.EnchantingItemHandler;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.EnchantmentEntry;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.FilteringFluidTankBehaviour;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.ExperienceFluid;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.HyperExperienceFluid;
import plus.dragons.createenchantmentindustry.entry.CeiContainerTypes;
import plus.dragons.createenchantmentindustry.entry.CeiFluids;
import plus.dragons.createenchantmentindustry.entry.CeiItems;
import plus.dragons.createenchantmentindustry.entry.CeiTags;
import plus.dragons.createenchantmentindustry.foundation.advancement.CeiAdvancements;
import plus.dragons.createenchantmentindustry.foundation.config.CeiConfigs;

public class BlazeEnchanterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
class_3908,
SidedStorageBlockEntity {
    public static final int ENCHANTING_TIME = 200;
    SmartFluidTankBehaviour internalTank;
    TransportedItemStack heldItem;
    class_1799 targetItem = new class_1799((class_1935)CeiItems.ENCHANTING_GUIDE.get());
    int processingTicks;
    Map<class_2350, LazyOptional<EnchantingItemHandler>> itemHandlers;
    boolean sendParticles;
    LerpedFloat headAnimation;
    LerpedFloat headAngle;
    Random random = new Random();
    float flip;
    float oFlip;
    float flipT;
    float flipA;
    public boolean goggles;
    SnapshotParticipant<TransportedItemStack> snapshotParticipant = new SnapshotParticipant<TransportedItemStack>(){

        protected TransportedItemStack createSnapshot() {
            return BlazeEnchanterBlockEntity.this.heldItem == null ? TransportedItemStack.EMPTY : BlazeEnchanterBlockEntity.this.heldItem.fullCopy();
        }

        protected void readSnapshot(TransportedItemStack snapshot) {
            BlazeEnchanterBlockEntity.this.heldItem = snapshot == TransportedItemStack.EMPTY ? null : snapshot;
        }

        protected void onFinalCommit() {
            BlazeEnchanterBlockEntity.this.notifyUpdate();
        }
    };
    protected static int ENCHANT_PARTICLE_COUNT = 20;

    public BlazeEnchanterBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.itemHandlers = new IdentityHashMap<class_2350, LazyOptional<EnchantingItemHandler>>();
        for (class_2350 d : Iterate.horizontalDirections) {
            EnchantingItemHandler enchantingItemHandler = new EnchantingItemHandler(this, d);
            this.itemHandlers.put(d, (LazyOptional<EnchantingItemHandler>)LazyOptional.of(() -> enchantingItemHandler));
        }
        this.headAnimation = LerpedFloat.linear();
        this.headAngle = LerpedFloat.angular();
        this.headAngle.startWithValue((double)((AngleHelper.horizontalAngle((class_2350)state.method_28500((class_2769)BlazeEnchanterBlock.field_11177).orElse(class_2350.field_11035)) + 180.0f) % 360.0f));
        this.goggles = false;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.internalTank = FilteringFluidTankBehaviour.single(fluidVariant -> fluidVariant.getFluid().method_15791(CeiTags.FluidTag.BLAZE_ENCHANTER_INPUT.tag), this, (Integer)CeiConfigs.SERVER.blazeEnchanterTankCapacity.get() * 81).whenFluidUpdates(() -> {
            class_3611 fluid = this.internalTank.getPrimaryHandler().getFluid().getFluid();
            if (CeiFluids.EXPERIENCE.is((Object)fluid)) {
                this.updateHeatLevel(BlazeEnchanterBlock.HeatLevel.KINDLED);
            } else if (CeiFluids.HYPER_EXPERIENCE.is((Object)fluid)) {
                this.updateHeatLevel(BlazeEnchanterBlock.HeatLevel.SEETHING);
            } else {
                this.updateHeatLevel(BlazeEnchanterBlock.HeatLevel.SMOULDERING);
            }
        });
        behaviours.add((BlockEntityBehaviour)this.internalTank);
        this.registerAwardables(behaviours, new CreateAdvancement[]{CeiAdvancements.FIRST_ORDER.asCreateAdvancement(), CeiAdvancements.ADDITIONAL_ORDER.asCreateAdvancement(), CeiAdvancements.HYPOTHETICAL_EXTENSION.asCreateAdvancement()});
    }

    public void tick() {
        boolean onClient;
        super.tick();
        boolean bl = onClient = this.field_11863.field_9236 && !this.isVirtual();
        if (onClient) {
            this.bookTick();
            this.blazeTick();
        }
        if (this.heldItem == null) {
            this.processingTicks = 0;
            return;
        }
        if (this.processingTicks > 0) {
            boolean wasAtBeginning;
            this.heldItem.prevBeltPosition = 0.5f;
            boolean bl2 = wasAtBeginning = this.processingTicks == 200;
            if (!onClient || this.processingTicks < 200) {
                --this.processingTicks;
            }
            if (!this.continueProcessing()) {
                this.processingTicks = 0;
                this.notifyUpdate();
                return;
            }
            if (wasAtBeginning != (this.processingTicks == 200)) {
                this.sendData();
            }
            return;
        }
        this.heldItem.prevBeltPosition = this.heldItem.beltPosition;
        this.heldItem.prevSideOffset = this.heldItem.sideOffset;
        this.heldItem.beltPosition += this.itemMovementPerTick();
        if (this.heldItem.beltPosition > 1.0f) {
            class_2338 nextPosition;
            DirectBeltInputBehaviour directBeltInputBehaviour;
            this.heldItem.beltPosition = 1.0f;
            if (onClient) {
                return;
            }
            class_2350 side = this.heldItem.insertedFrom;
            class_1799 tryExportingToBeltFunnel = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(this.heldItem.stack, side.method_10153(), false);
            if (tryExportingToBeltFunnel != null) {
                if (tryExportingToBeltFunnel.method_7947() != this.heldItem.stack.method_7947()) {
                    if (tryExportingToBeltFunnel.method_7960()) {
                        this.heldItem = null;
                    } else {
                        this.heldItem.stack = tryExportingToBeltFunnel;
                    }
                    this.notifyUpdate();
                    return;
                }
                if (!tryExportingToBeltFunnel.method_7960()) {
                    return;
                }
            }
            if ((directBeltInputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((class_1922)this.field_11863, (class_2338)(nextPosition = this.field_11867.method_10093(side)), (BehaviourType)DirectBeltInputBehaviour.TYPE)) == null) {
                if (!BlockHelper.hasBlockSolidSide((class_2680)this.field_11863.method_8320(nextPosition), (class_1922)this.field_11863, (class_2338)nextPosition, (class_2350)side.method_10153())) {
                    class_1799 ejected = this.heldItem.stack;
                    class_243 outPos = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(class_243.method_24954((class_2382)side.method_10163()).method_1021(0.75));
                    float movementSpeed = this.itemMovementPerTick();
                    class_243 outMotion = class_243.method_24954((class_2382)side.method_10163()).method_1021((double)movementSpeed).method_1031(0.0, 0.125, 0.0);
                    outPos.method_1019(outMotion.method_1029());
                    class_1542 entity = new class_1542(this.field_11863, outPos.field_1352, outPos.field_1351 + 0.375, outPos.field_1350, ejected);
                    entity.method_18799(outMotion);
                    entity.method_6988();
                    entity.field_6037 = true;
                    this.field_11863.method_8649((class_1297)entity);
                    this.heldItem = null;
                    this.notifyUpdate();
                }
                return;
            }
            if (!directBeltInputBehaviour.canInsertFromSide(side)) {
                return;
            }
            class_1799 returned = directBeltInputBehaviour.handleInsertion(this.heldItem.copy(), side, false);
            if (returned.method_7960()) {
                this.heldItem = null;
                this.notifyUpdate();
                return;
            }
            if (returned.method_7947() != this.heldItem.stack.method_7947()) {
                this.heldItem.stack = returned;
                this.notifyUpdate();
                return;
            }
            return;
        }
        if (this.heldItem.prevBeltPosition < 0.5f && this.heldItem.beltPosition >= 0.5f) {
            if (Enchanting.getValidEnchantment(this.heldItem.stack, this.targetItem, this.hyper()) == null) {
                return;
            }
            this.heldItem.beltPosition = 0.5f;
            if (onClient) {
                return;
            }
            this.processingTicks = 200;
            this.sendData();
        }
    }

    protected void blazeTick() {
        boolean active;
        boolean bl = active = this.processingTicks > 0;
        if (!active) {
            float target = 0.0f;
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && !player.method_5767()) {
                double z;
                double x;
                if (this.isVirtual()) {
                    x = -4.0;
                    z = -10.0;
                } else {
                    x = player.method_23317();
                    z = player.method_23321();
                }
                double dx = x - ((double)this.method_11016().method_10263() + 0.5);
                double dz = z - ((double)this.method_11016().method_10260() + 0.5);
                target = AngleHelper.deg((double)(-class_3532.method_15349((double)dz, (double)dx))) - 90.0f;
            }
            target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff((double)this.headAngle.getValue(), (double)target);
            this.headAngle.chase((double)target, 0.25, LerpedFloat.Chaser.exp((double)5.0));
            this.headAngle.tickChaser();
        } else {
            this.headAngle.chase((double)((AngleHelper.horizontalAngle((class_2350)this.method_11010().method_28500((class_2769)BlazeEnchanterBlock.field_11177).orElse(class_2350.field_11035)) + 180.0f) % 360.0f), 0.125, LerpedFloat.Chaser.EXP);
            this.headAngle.tickChaser();
        }
        this.headAnimation.chase(1.0, 0.25, LerpedFloat.Chaser.exp((double)0.25));
        this.headAnimation.tickChaser();
        this.spawnBlazeParticles();
    }

    protected void bookTick() {
        if (this.random.nextInt(40) == 0) {
            float oFlipT = this.flipT;
            while (oFlipT == this.flipT) {
                this.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            }
        }
        this.oFlip = this.flip;
        float flipDiff = (this.flipT - this.flip) * 0.4f;
        flipDiff = class_3532.method_15363((float)flipDiff, (float)-0.2f, (float)0.2f);
        this.flipA += (flipDiff - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }

    protected void spawnBlazeParticles() {
        if (this.field_11863 == null) {
            return;
        }
        BlazeEnchanterBlock.HeatLevel heatLevel = (BlazeEnchanterBlock.HeatLevel)((Object)this.method_11010().method_11654(BlazeEnchanterBlock.HEAT_LEVEL));
        class_5819 r = this.field_11863.field_9229;
        class_243 c = VecHelper.getCenterOf((class_2382)this.field_11867);
        class_243 v = c.method_1019(VecHelper.offsetRandomly((class_243)class_243.field_1353, (class_5819)r, (float)0.125f).method_18805(1.0, 0.0, 1.0));
        if (r.method_43048(3) == 0) {
            this.field_11863.method_8406((class_2394)class_2398.field_11237, v.field_1352, v.field_1351, v.field_1350, 0.0, 0.0, 0.0);
        }
        if (r.method_43048(2) != 0) {
            return;
        }
        boolean empty = this.field_11863.method_8320(this.field_11867.method_10084()).method_26220((class_1922)this.field_11863, this.field_11867.method_10084()).method_1110();
        double yMotion = empty ? 0.0625 : r.method_43058() * (double)0.0125f;
        class_243 v2 = c.method_1019(VecHelper.offsetRandomly((class_243)class_243.field_1353, (class_5819)r, (float)0.5f).method_18805(1.0, 0.25, 1.0).method_1029().method_1021((empty ? 0.25 : 0.5) + r.method_43058() * 0.125)).method_1031(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeEnchanterBlock.HeatLevel.SEETHING)) {
            this.field_11863.method_8406((class_2394)class_2398.field_22246, v2.field_1352, v2.field_1351, v2.field_1350, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeEnchanterBlock.HeatLevel.KINDLED)) {
            this.field_11863.method_8406((class_2394)class_2398.field_11240, v2.field_1352, v2.field_1351, v2.field_1350, 0.0, yMotion, 0.0);
        }
    }

    protected void spawnEnchantParticles() {
        if (this.isVirtual()) {
            return;
        }
        class_243 vec = VecHelper.getCenterOf((class_2382)this.field_11867);
        vec = vec.method_1031(0.0, 1.0, 0.0);
        class_2400 particle = class_2398.field_11215;
        for (int i = 0; i < ENCHANT_PARTICLE_COUNT; ++i) {
            class_243 m = VecHelper.offsetRandomly((class_243)class_243.field_1353, (class_5819)this.field_11863.field_9229, (float)1.0f);
            m = new class_243(m.field_1352, Math.abs(m.field_1351), m.field_1350);
            this.field_11863.method_8494((class_2394)particle, vec.field_1352, vec.field_1351, vec.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
        this.field_11863.method_8486(vec.field_1352, vec.field_1351, vec.field_1350, class_3417.field_15119, class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f, true);
    }

    protected boolean continueProcessing() {
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            if (this.processingTicks > 0 && this.processingTicks < 200 && this.field_11863.method_8510() % 80L == 0L) {
                ((class_638)this.field_11863).method_45446(this.field_11867, class_3417.field_15045, class_3419.field_15245, 1.0f, 1.0f, true);
            }
            return true;
        }
        if (this.processingTicks < 5) {
            return true;
        }
        boolean hyper = this.hyper();
        EnchantmentEntry entry = Enchanting.getValidEnchantment(this.heldItem.stack, this.targetItem, hyper);
        if (entry == null) {
            return false;
        }
        FluidStack exp = new FluidStack(hyper ? ((HyperExperienceFluid)((Object)CeiFluids.HYPER_EXPERIENCE.get())).method_15751() : ((ExperienceFluid)((Object)CeiFluids.EXPERIENCE.get())).method_15751(), (long)((double)Enchanting.getExperienceConsumption((class_1887)entry.getFirst(), (Integer)entry.getSecond()) * (hyper ? (Double)CeiConfigs.SERVER.hyperEnchantByBlazeEnchanterCostCoefficient.get() : (Double)CeiConfigs.SERVER.enchantByBlazeEnchanterCostCoefficient.get())));
        if (this.processingTicks > 5) {
            class_3611 tankFluid = this.internalTank.getPrimaryHandler().getFluid().getFluid();
            if (!CeiFluids.EXPERIENCE.is((Object)tankFluid) && !CeiFluids.HYPER_EXPERIENCE.is((Object)tankFluid) || this.internalTank.getPrimaryHandler().getFluidAmount() < exp.getAmount()) {
                this.processingTicks = 200;
            }
            return true;
        }
        if (class_1890.method_8222((class_1799)this.heldItem.stack).isEmpty()) {
            this.award(CeiAdvancements.FIRST_ORDER.asCreateAdvancement());
        } else {
            this.award(CeiAdvancements.ADDITIONAL_ORDER.asCreateAdvancement());
        }
        if (hyper) {
            this.award(CeiAdvancements.HYPOTHETICAL_EXTENSION.asCreateAdvancement());
        }
        Enchanting.enchantItem(this.heldItem.stack, entry);
        try (Transaction t = TransferUtil.getTransaction();){
            this.internalTank.getPrimaryHandler().extract(exp.getType(), exp.getAmount(), (TransactionContext)t);
            t.commit();
        }
        this.sendParticles = true;
        this.notifyUpdate();
        return true;
    }

    private float itemMovementPerTick() {
        return 0.125f;
    }

    public void setTargetItem(class_1799 itemStack) {
        this.targetItem = itemStack;
    }

    private class_1799 tryInsertingFromSide(TransportedItemStack transportedStack, class_2350 side, boolean simulate) {
        class_1799 inserted = transportedStack.stack;
        class_1799 returned = class_1799.field_8037;
        if (!this.getHeldItemStack().method_7960()) {
            return inserted;
        }
        if (inserted.method_7947() > 1 && Enchanting.getValidEnchantment(inserted, this.targetItem, this.hyper()) != null) {
            returned = ItemHandlerHelper.copyStackWithSize((class_1799)inserted, (int)(inserted.method_7947() - 1));
            inserted = ItemHandlerHelper.copyStackWithSize((class_1799)inserted, (int)1);
        }
        if (simulate) {
            return returned;
        }
        transportedStack = transportedStack.copy();
        transportedStack.stack = inserted.method_7972();
        transportedStack.beltPosition = side.method_10166().method_10178() ? 0.5f : 0.0f;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        this.setHeldItem(transportedStack, side);
        this.method_5431();
        this.sendData();
        return returned;
    }

    public class_1799 getHeldItemStack() {
        return this.heldItem == null ? class_1799.field_8037 : this.heldItem.stack;
    }

    public void setHeldItem(TransportedItemStack heldItem, class_2350 insertedFrom) {
        this.heldItem = heldItem;
        this.heldItem.insertedFrom = insertedFrom;
    }

    public void invalidate() {
        super.invalidate();
    }

    public ItemRequirement getRequiredItems(class_2680 state) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.targetItem);
    }

    public void destroy() {
        super.destroy();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_1799 heldItemStack = this.getHeldItemStack();
            class_2338 pos = this.method_11016();
            if (!heldItemStack.method_7960()) {
                class_1264.method_5449((class_1937)this.field_11863, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)heldItemStack);
            }
            class_1264.method_5449((class_1937)this.field_11863, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)this.targetItem);
            SmartFluidTank tank = this.internalTank.getPrimaryHandler();
            FluidStack fluidStack = tank.getFluid();
            class_3611 class_36112 = fluidStack.getFluid();
            if (class_36112 instanceof ExperienceFluid) {
                ExperienceFluid expFluid = (ExperienceFluid)class_36112;
                expFluid.drop(serverLevel, VecHelper.getCenterOf((class_2382)pos), (int)fluidStack.getAmount());
            }
        }
    }

    public boolean hyper() {
        return CeiFluids.HYPER_EXPERIENCE.is((Object)this.internalTank.getPrimaryHandler().getFluid().getFluid());
    }

    public void write(class_2487 compoundTag, boolean clientPacket) {
        super.write(compoundTag, clientPacket);
        compoundTag.method_10569("ProcessingTicks", this.processingTicks);
        compoundTag.method_10566("TargetItem", NBTSerializer.serializeNBT((Object)this.targetItem));
        compoundTag.method_10556("Goggles", this.goggles);
        if (this.heldItem != null) {
            compoundTag.method_10566("HeldItem", (class_2520)this.heldItem.serializeNBT());
        }
        if (this.sendParticles && clientPacket) {
            compoundTag.method_10556("SpawnParticles", true);
            this.sendParticles = false;
        }
    }

    public void writeSafe(class_2487 tag) {
        super.writeSafe(tag);
        tag.method_10566("TargetItem", NBTSerializer.serializeNBT((Object)new class_1799((class_1935)CeiItems.ENCHANTING_GUIDE.get())));
        tag.method_10556("Goggles", this.goggles);
    }

    protected void read(class_2487 compoundTag, boolean clientPacket) {
        super.read(compoundTag, clientPacket);
        this.heldItem = null;
        this.processingTicks = compoundTag.method_10550("ProcessingTicks");
        this.targetItem = class_1799.method_7915((class_2487)compoundTag.method_10562("TargetItem"));
        this.goggles = compoundTag.method_10577("Goggles");
        if (compoundTag.method_10545("HeldItem")) {
            this.heldItem = TransportedItemStack.read((class_2487)compoundTag.method_10562("HeldItem"));
        }
        if (!clientPacket) {
            return;
        }
        if (compoundTag.method_10545("SpawnParticles")) {
            this.spawnEnchantParticles();
        }
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(class_2350 side) {
        if (side == class_2350.field_11033 || side == null) {
            return this.internalTank.getCapability();
        }
        return null;
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(class_2350 side) {
        if (side != null && side.method_10166().method_10179()) {
            return (Storage)this.itemHandlers.get(side).getValueUnsafer();
        }
        return null;
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        EnchantmentEntry entry;
        EnchantmentIndustry.LANG.translate("gui.goggles.blaze_enchanter", new Object[0]).forGoggles(tooltip);
        if (this.targetItem != null && this.targetItem.method_31574((class_1792)CeiItems.ENCHANTING_GUIDE.get()) && (entry = Enchanting.getTargetEnchantment(this.targetItem, this.hyper())) != null) {
            tooltip.add((class_2561)class_2561.method_43470((String)"     ").method_10852(((class_1887)entry.getFirst()).method_8179(((Integer)entry.getSecond()).intValue())));
            if (!entry.valid()) {
                tooltip.add((class_2561)class_2561.method_43470((String)"     ").method_10852((class_2561)EnchantmentIndustry.LANG.translate("gui.goggles.blaze_enchanter.invalid_target", new Object[0]).component()).method_27692(class_124.field_1061));
            } else {
                int consumption = (int)((double)Enchanting.getExperienceConsumption((class_1887)entry.getFirst(), (Integer)entry.getSecond()) * (this.hyper() ? (Double)CeiConfigs.SERVER.hyperEnchantByBlazeEnchanterCostCoefficient.get() : (Double)CeiConfigs.SERVER.enchantByBlazeEnchanterCostCoefficient.get()));
                if (consumption > (Integer)CeiConfigs.SERVER.blazeEnchanterTankCapacity.get() * 81) {
                    tooltip.add((class_2561)class_2561.method_43470((String)"     ").method_10852((class_2561)EnchantmentIndustry.LANG.translate("gui.goggles.too_expensive", new Object[0]).component()).method_27692(class_124.field_1061));
                } else {
                    tooltip.add((class_2561)class_2561.method_43470((String)"     ").method_10852((class_2561)EnchantmentIndustry.LANG.translate("gui.goggles.xp_consumption", new Object[]{consumption / 81}).component()).method_27692(class_124.field_1060));
                }
            }
        }
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getFluidStorage(null));
        return true;
    }

    public void updateHeatLevel(BlazeEnchanterBlock.HeatLevel heatLevel) {
        if (this.field_11863 != null) {
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(BlazeEnchanterBlock.HEAT_LEVEL, (Comparable)((Object)heatLevel)));
        }
    }

    public class_2561 method_5476() {
        return this.targetItem.method_7954();
    }

    @Nullable
    public class_1703 createMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer) {
        return new EnchantingGuideMenu((class_3917)CeiContainerTypes.ENCHANTING_GUIDE_FOR_BLAZE.get(), pContainerId, pPlayerInventory, this.targetItem, this.method_11016());
    }
}

