/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.foundation.mixin;

import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.FilteringStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1278;
import net.minecraft.class_1732;
import net.minecraft.class_1737;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2609;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;
import plus.dragons.createenchantmentindustry.entry.CeiFluids;

@Mixin(value={class_2609.class})
public abstract class AbstractFurnaceBlockEntityMixin<T>
extends class_2624
implements class_1278,
class_1732,
class_1737,
SidedStorageBlockEntity {
    @Shadow
    private Object2IntOpenHashMap<class_2960> field_11986;
    @Unique
    protected final FluidTank internalTank = new FluidTank(Long.MAX_VALUE, fs -> fs.getType().equals(FluidVariant.of((class_3611)CeiFluids.EXPERIENCE.getSource()))){

        protected void onContentsChanged() {
            long total = AbstractFurnaceBlockEntityMixin.this.calculateExperienceStored();
            long diff = total - this.getFluidAmount();
            if (diff <= 0L) {
                return;
            }
            EnchantmentIndustry.LOGGER.debug("Furnace XP removing recipes for a total of {} out of {}", (Object)diff, (Object)total);
            if (diff >= total) {
                EnchantmentIndustry.LOGGER.debug("Furnace XP removing all recipes");
                AbstractFurnaceBlockEntityMixin.this.field_11986.clear();
                return;
            }
            class_1863 recipeManager = AbstractFurnaceBlockEntityMixin.this.method_10997().method_8433();
            Object2IntMap.FastEntrySet it = AbstractFurnaceBlockEntityMixin.this.field_11986.object2IntEntrySet();
            List entriesUsed = StreamSupport.stream(it.spliterator(), false).filter(e -> recipeManager.method_8130((class_2960)e.getKey()).isPresent()).collect(Collectors.toList());
            for (Object2IntMap.Entry entry : entriesUsed) {
                class_1874 usedRecipe = (class_1874)recipeManager.method_8130((class_2960)entry.getKey()).get();
                long experience = (long)(usedRecipe.method_8171() * 81.0f);
                int count = (int)Math.min(diff / experience, (long)entry.getIntValue());
                if (count <= 0) continue;
                diff -= experience;
                AbstractFurnaceBlockEntityMixin.this.field_11986.addTo((Object)usedRecipe.method_8114(), -count);
                EnchantmentIndustry.LOGGER.debug("Furnace XP removed {} recipe {} times", entry.getKey(), (Object)count);
            }
        }
    };
    @Unique
    public final Storage<FluidVariant> exposedExperienceTank = FilteringStorage.extractOnlyOf((Storage)this.internalTank);

    protected AbstractFurnaceBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Unique
    protected long calculateExperienceStored() {
        double total = 0.0;
        for (Object2IntMap.Entry entry : this.field_11986.object2IntEntrySet()) {
            total += this.method_10997().method_8433().method_8130((class_2960)entry.getKey()).map(recipe -> (double)((class_1874)recipe).method_8171() * (double)entry.getIntValue()).orElse(0.0).doubleValue();
        }
        EnchantmentIndustry.LOGGER.debug("Furnace XP amount: {}", (Object)(total *= 81.0));
        return (long)total;
    }

    @Inject(method={"setRecipeUsed"}, at={@At(value="TAIL")}, cancellable=true)
    private void injectSetRecipeUsed(@Nullable class_1860<?> recipe, CallbackInfo ci) {
        if (recipe != null) {
            long amount = this.internalTank.getFluidAmount();
            amount = (long)((double)amount + (amount == 0L ? (double)this.calculateExperienceStored() : Math.floor(((class_1874)recipe).method_8171() * 81.0f)));
            this.internalTank.setFluid(new FluidStack(FluidVariant.of((class_3611)CeiFluids.EXPERIENCE.getSource()), amount));
        }
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(class_2350 side) {
        if (side.method_10166().method_10179()) {
            return this.exposedExperienceTank;
        }
        return null;
    }
}

