/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.feature.locator.locators;

import com.dfsek.terra.addons.feature.locator.patterns.Pattern;
import com.dfsek.terra.api.structure.feature.BinaryColumn;
import com.dfsek.terra.api.structure.feature.Locator;
import com.dfsek.terra.api.util.Range;
import com.dfsek.terra.api.world.WritableWorld;
import com.dfsek.terra.api.world.chunk.generation.util.Column;

public class AdjacentPatternLocator
implements Locator {
    private final Pattern pattern;
    private final Range search;
    private final boolean matchAll;

    public AdjacentPatternLocator(Pattern pattern, Range search, boolean matchAll) {
        this.pattern = pattern;
        this.search = search;
        this.matchAll = matchAll;
    }

    public BinaryColumn getSuitableCoordinates(Column<?> column) {
        return new BinaryColumn(this.search, y -> this.isValid(y, column));
    }

    private boolean isValid(int y, Column<?> column) {
        WritableWorld world = column.getWorld();
        int x = column.getX();
        int z = column.getZ();
        if (this.matchAll) {
            return this.pattern.matches(world, x, y, z - 1) && this.pattern.matches(world, x, y, z + 1) && this.pattern.matches(world, x - 1, y, z) && this.pattern.matches(world, x + 1, y, z);
        }
        return this.pattern.matches(world, x, y, z - 1) || this.pattern.matches(world, x, y, z + 1) || this.pattern.matches(world, x - 1, y, z) || this.pattern.matches(world, x + 1, y, z);
    }
}

