/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.feature.locator.locators;

import com.dfsek.terra.api.noise.NoiseSampler;
import com.dfsek.terra.api.structure.feature.BinaryColumn;
import com.dfsek.terra.api.structure.feature.Locator;
import com.dfsek.terra.api.world.chunk.generation.util.Column;
import java.util.List;

public class SamplerLocator
implements Locator {
    private final List<NoiseSampler> samplers;

    public SamplerLocator(List<NoiseSampler> samplers) {
        this.samplers = samplers;
    }

    private static int floorToInt(double value) {
        int valueInt = (int)value;
        if (value < 0.0) {
            if (value == (double)valueInt) {
                return valueInt;
            }
            return valueInt == Integer.MIN_VALUE ? valueInt : valueInt - 1;
        }
        return valueInt;
    }

    public BinaryColumn getSuitableCoordinates(Column<?> column) {
        Column.BinaryColumnBuilder results = column.newBinaryColumn();
        long seed = column.getWorld().getSeed();
        this.samplers.forEach(sampler -> {
            int y = SamplerLocator.floorToInt(sampler.noise(seed, column.getX(), column.getZ()));
            if (y >= column.getMaxY() || y < column.getMinY()) {
                return;
            }
            results.set(y);
        });
        return results.build();
    }
}

