/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.feature.locator.locators;

import com.dfsek.terra.addons.feature.locator.lib.jafama.FastMath;
import com.dfsek.terra.api.structure.feature.BinaryColumn;
import com.dfsek.terra.api.structure.feature.Locator;
import com.dfsek.terra.api.util.Range;
import com.dfsek.terra.api.world.chunk.generation.util.Column;

public class SurfaceLocator
implements Locator {
    private final Range search;

    public SurfaceLocator(Range search) {
        this.search = search;
    }

    public BinaryColumn getSuitableCoordinates(Column<?> column) {
        Column.BinaryColumnBuilder builder = column.newBinaryColumn();
        int max = FastMath.min(this.search.getMax(), column.getMaxY());
        int min = FastMath.max(this.search.getMin(), column.getMinY());
        if (min >= max) {
            return builder.build();
        }
        for (int y = min; y < max; ++y) {
            if (!column.getBlock(y).isAir() || column.getBlock(y - 1).isAir()) continue;
            builder.set(y);
        }
        return builder.build();
    }
}

