/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.crafting;

import appeng.api.networking.IGridNodeListener;
import appeng.api.orientation.BlockOrientation;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AECableType;
import appeng.block.crafting.PatternProviderBlock;
import appeng.block.crafting.PushDirection;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.util.SettingsFrom;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class PatternProviderBlockEntity
extends AENetworkBlockEntity
implements PatternProviderLogicHost {
    protected final PatternProviderLogic logic = this.createLogic();
    @Nullable
    private PushDirection pendingPushDirectionChange;

    public PatternProviderBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
    }

    protected PatternProviderLogic createLogic() {
        return new PatternProviderLogic(this.getMainNode(), this);
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.logic.onMainNodeStateChanged();
    }

    private PushDirection getPushDirection() {
        return (PushDirection)((Object)this.method_11010().method_11654(PatternProviderBlock.PUSH_DIRECTION));
    }

    @Override
    public Set<class_2350> getGridConnectableSides(BlockOrientation orientation) {
        class_2350 pushDirection = this.getPushDirection().getDirection();
        if (pushDirection == null) {
            return EnumSet.allOf(class_2350.class);
        }
        return EnumSet.complementOf(EnumSet.of(pushDirection));
    }

    @Override
    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        super.addAdditionalDrops(level, pos, drops);
        this.logic.addDrops(drops);
    }

    @Override
    public void method_5448() {
        super.method_5448();
        this.logic.clearContent();
    }

    @Override
    public void onReady() {
        if (this.pendingPushDirectionChange != null) {
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(PatternProviderBlock.PUSH_DIRECTION, (Comparable)((Object)this.pendingPushDirectionChange)));
            this.pendingPushDirectionChange = null;
            this.onGridConnectableSidesChanged();
        }
        super.onReady();
        this.logic.updatePatterns();
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.logic.writeToNBT(data);
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        if (data.method_10577("omniDirectional")) {
            this.pendingPushDirectionChange = PushDirection.ALL;
        } else if (data.method_10573("forward", 8)) {
            try {
                class_2350 forward = class_2350.valueOf((String)data.method_10558("forward").toUpperCase(Locale.ROOT));
                this.pendingPushDirectionChange = PushDirection.fromDirection(forward);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.logic.readFromNBT(data);
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.SMART;
    }

    @Override
    public PatternProviderLogic getLogic() {
        return this.logic;
    }

    @Override
    public EnumSet<class_2350> getTargets() {
        PushDirection pushDirection = this.getPushDirection();
        if (pushDirection.getDirection() == null) {
            return EnumSet.allOf(class_2350.class);
        }
        return EnumSet.of(pushDirection.getDirection());
    }

    @Override
    public AEItemKey getTerminalIcon() {
        return AEItemKey.of(AEBlocks.PATTERN_PROVIDER.stack());
    }

    @Override
    public void exportSettings(SettingsFrom mode, class_2487 output, @Nullable class_1657 player) {
        super.exportSettings(mode, output, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            this.logic.exportSettings(output);
            PushDirection pushDirection = this.getPushDirection();
            output.method_10567("push_direction", (byte)pushDirection.ordinal());
        }
    }

    @Override
    public void importSettings(SettingsFrom mode, class_2487 input, @Nullable class_1657 player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            class_1937 level;
            byte pushDirection;
            this.logic.importSettings(input, player);
            if (input.method_10573(PatternProviderBlock.PUSH_DIRECTION.method_11899(), 1) && (pushDirection = input.method_10571(PatternProviderBlock.PUSH_DIRECTION.method_11899())) >= 0 && pushDirection < PushDirection.values().length && (level = this.method_10997()) != null) {
                level.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(PatternProviderBlock.PUSH_DIRECTION, (Comparable)((Object)PushDirection.values()[pushDirection])));
            }
        }
    }

    @Override
    public class_1799 getMainMenuIcon() {
        return AEBlocks.PATTERN_PROVIDER.stack();
    }

    @Override
    public void method_31664(class_2680 state) {
        super.method_31664(state);
        this.onGridConnectableSidesChanged();
    }
}

