/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.networking;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.GridPowerStorageStateChanged;
import appeng.api.util.AECableType;
import appeng.block.networking.EnergyCellBlock;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.hooks.ticking.TickHandler;
import appeng.me.energy.StoredEnergyAmount;
import appeng.util.SettingsFrom;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class EnergyCellBlockEntity
extends AENetworkBlockEntity
implements IAEPowerStorage {
    private final StoredEnergyAmount stored;
    private byte currentDisplayLevel;
    private boolean neighborChangePending;

    public EnergyCellBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).addService(IAEPowerStorage.class, this);
        EnergyCellBlock cellBlock = (EnergyCellBlock)this.method_11010().method_26204();
        this.stored = new StoredEnergyAmount(0.0, cellBlock.getMaxPower(), this::emitPowerEvent);
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    @Override
    public void onReady() {
        super.onReady();
        int value = (Integer)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)EnergyCellBlock.ENERGY_STORAGE);
        this.currentDisplayLevel = (byte)value;
        this.updateStateForPowerLevel();
    }

    public static int getStorageLevelFromFillFactor(double fillFactor) {
        return (int)Math.floor(4.0 * class_3532.method_15350((double)(fillFactor + 0.01), (double)0.0, (double)1.0));
    }

    private void updateStateForPowerLevel() {
        if (this.method_11015()) {
            return;
        }
        int storageLevel = EnergyCellBlockEntity.getStorageLevelFromFillFactor(this.stored.getAmount() / this.stored.getMaximum());
        if (this.currentDisplayLevel != storageLevel) {
            this.currentDisplayLevel = (byte)storageLevel;
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)EnergyCellBlock.ENERGY_STORAGE, (Comparable)Integer.valueOf(storageLevel)));
        }
    }

    private void onAmountChanged() {
        if (!this.neighborChangePending) {
            this.neighborChangePending = true;
            TickHandler.instance().addCallable((class_1936)this.field_11863, () -> {
                if (!this.method_11015() && this.neighborChangePending) {
                    this.neighborChangePending = false;
                    this.updateStateForPowerLevel();
                    this.method_5431();
                }
            });
        }
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10549("internalCurrentPower", this.stored.getAmount());
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.stored.setStored(data.method_10574("internalCurrentPower"));
    }

    @Override
    public void importSettings(SettingsFrom mode, class_2487 input, @Nullable class_1657 player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.DISMANTLE_ITEM) {
            this.stored.setStored(input.method_10574("internalCurrentPower"));
        }
    }

    @Override
    public void exportSettings(SettingsFrom from, class_2487 data, @Nullable class_1657 player) {
        super.exportSettings(from, data, player);
        if (from == SettingsFrom.DISMANTLE_ITEM && this.stored.getAmount() > 0.0) {
            data.method_10549("internalCurrentPower", this.stored.getAmount());
            data.method_10549("internalMaxPower", this.stored.getMaximum());
        }
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        double inserted = this.stored.insert(amt, mode == Actionable.MODULATE);
        if (mode == Actionable.MODULATE && inserted > 0.0) {
            this.onAmountChanged();
        }
        return amt - inserted;
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier pm) {
        return pm.divide(this.extractAEPower(pm.multiply(amt), mode));
    }

    private double extractAEPower(double amt, Actionable mode) {
        double extracted = this.stored.extract(amt, mode == Actionable.MODULATE);
        if (mode == Actionable.MODULATE && extracted > 0.0) {
            this.onAmountChanged();
        }
        return extracted;
    }

    @Override
    public double getAEMaxPower() {
        return this.stored.getMaximum();
    }

    @Override
    public double getAECurrentPower() {
        return this.stored.getAmount();
    }

    @Override
    public boolean isAEPublicPowerStorage() {
        return true;
    }

    @Override
    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public int getPriority() {
        return ((EnergyCellBlock)this.method_11010().method_26204()).getPriority();
    }

    private void emitPowerEvent(GridPowerStorageStateChanged.PowerEventType type) {
        this.getMainNode().ifPresent(grid -> grid.postEvent(new GridPowerStorageStateChanged(this, type)));
    }
}

