/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.patternaccess;

import appeng.api.config.Settings;
import appeng.api.config.ShowPatternProviders;
import appeng.api.config.TerminalStyle;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.stacks.AEItemKey;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.patternaccess.PatternContainerRecord;
import appeng.client.gui.me.patternaccess.PatternSlot;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.render.SimpleRenderContext;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.implementations.PatternAccessTermMenu;
import appeng.util.inv.AppEngInternalInventory;
import com.google.common.collect.HashMultimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_768;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternAccessTermScreen<C extends PatternAccessTermMenu>
extends AEBaseScreen<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatternAccessTermScreen.class);
    private static final int GUI_WIDTH = 195;
    private static final int GUI_TOP_AND_BOTTOM_PADDING = 54;
    private static final int GUI_PADDING_X = 8;
    private static final int GUI_PADDING_Y = 6;
    private static final int GUI_HEADER_HEIGHT = 17;
    private static final int GUI_FOOTER_HEIGHT = 97;
    private static final int COLUMNS = 9;
    private static final int PATTERN_PROVIDER_NAME_MARGIN_X = 2;
    private static final int TEXT_MAX_WIDTH = 155;
    private static final int ROW_HEIGHT = 18;
    private static final int SLOT_SIZE = 18;
    private static final class_768 HEADER_BBOX = new class_768(0, 0, 195, 17);
    private static final class_768 ROW_TEXT_TOP_BBOX = new class_768(0, 17, 195, 18);
    private static final class_768 ROW_TEXT_MIDDLE_BBOX = new class_768(0, 53, 195, 18);
    private static final class_768 ROW_TEXT_BOTTOM_BBOX = new class_768(0, 89, 195, 18);
    private static final class_768 ROW_INVENTORY_TOP_BBOX = new class_768(0, 35, 195, 18);
    private static final class_768 ROW_INVENTORY_MIDDLE_BBOX = new class_768(0, 71, 195, 18);
    private static final class_768 ROW_INVENTORY_BOTTOM_BBOX = new class_768(0, 107, 195, 18);
    private static final class_768 FOOTER_BBOX = new class_768(0, 125, 195, 97);
    private static final Comparator<PatternContainerGroup> GROUP_COMPARATOR = Comparator.comparing(group -> group.name().getString().toLowerCase(Locale.ROOT));
    private final HashMap<Long, PatternContainerRecord> byId = new HashMap();
    private final HashMultimap<PatternContainerGroup, PatternContainerRecord> byGroup = HashMultimap.create();
    private final ArrayList<PatternContainerGroup> groups = new ArrayList();
    private final ArrayList<Row> rows = new ArrayList();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private final Scrollbar scrollbar = this.widgets.addScrollBar("scrollbar");
    private final AETextField searchField;
    private int visibleRows = 0;
    private final ServerSettingToggleButton<ShowPatternProviders> showPatternProviders;

    public PatternAccessTermScreen(C menu, class_1661 playerInventory, class_2561 title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.field_2792 = 195;
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        this.addToLeftToolbar(new SettingToggleButton<TerminalStyle>(Settings.TERMINAL_STYLE, terminalStyle, this::toggleTerminalStyle));
        this.showPatternProviders = new ServerSettingToggleButton<ShowPatternProviders>(Settings.TERMINAL_SHOW_PATTERN_PROVIDERS, ShowPatternProviders.VISIBLE);
        this.addToLeftToolbar(this.showPatternProviders);
        this.searchField = this.widgets.addTextField("search");
        this.searchField.method_1863(str -> this.refreshList());
        this.searchField.setPlaceholder((class_2561)GuiText.SearchPlaceholder.text());
    }

    @Override
    public void method_25426() {
        this.visibleRows = this.config.getTerminalStyle().getRows((this.field_22790 - 17 - 97 - 54) / 18);
        this.field_2779 = 114 + this.visibleRows * 18;
        super.method_25426();
        this.method_48265((class_364)this.searchField);
        this.resetScrollbar();
    }

    @Override
    public void drawFG(class_332 guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        ((PatternAccessTermMenu)this.field_2797).field_7761.removeIf(slot -> slot instanceof PatternSlot);
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        int scrollLevel = this.scrollbar.getCurrentScroll();
        for (int i = 0; i < this.visibleRows; ++i) {
            int rows;
            if (scrollLevel + i >= this.rows.size()) continue;
            Row row = this.rows.get(scrollLevel + i);
            if (row instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                PatternContainerRecord container = slotsRow.container;
                for (int col = 0; col < slotsRow.slots; ++col) {
                    PatternSlot slot2 = new PatternSlot(container, slotsRow.offset + col, col * 18 + 8, (i + 1) * 18);
                    ((PatternAccessTermMenu)this.field_2797).field_7761.add((Object)slot2);
                }
                continue;
            }
            if (!(row instanceof GroupHeaderRow)) continue;
            GroupHeaderRow headerRow = (GroupHeaderRow)row;
            PatternContainerGroup group = headerRow.group;
            if (group.icon() != null) {
                SimpleRenderContext renderContext = new SimpleRenderContext(LytRect.empty(), guiGraphics);
                renderContext.renderItem(group.icon().toStack(), 10, 23 + i * 18, 8.0f, 8.0f);
            }
            Object displayName = (rows = this.byGroup.get((Object)group).size()) > 1 ? class_2561.method_43473().method_10852(group.name()).method_10852((class_2561)class_2561.method_43470((String)(" (" + rows + ")"))) : group.name();
            class_5481 text = class_2477.method_10517().method_30934(this.field_22793.method_1714((class_5348)displayName, 145));
            guiGraphics.method_51430(this.field_22793, text, 20, 23 + i * 18, textColor, false);
        }
    }

    protected void method_2380(class_332 guiGraphics, int x, int y) {
        Row row;
        int hoveredLineIndex;
        if (this.field_2787 == null && (hoveredLineIndex = this.getHoveredLineIndex(x, y)) != -1 && (row = this.rows.get(hoveredLineIndex)) instanceof GroupHeaderRow) {
            GroupHeaderRow headerRow = (GroupHeaderRow)row;
            if (!headerRow.group.tooltip().isEmpty()) {
                guiGraphics.method_51437(this.field_22793, headerRow.group.tooltip(), Optional.empty(), x, y);
                return;
            }
        }
        super.method_2380(guiGraphics, x, y);
    }

    private int getHoveredLineIndex(int x, int y) {
        x = x - this.field_2776 - 8;
        y = y - this.field_2800 - 18;
        if (x < 0 || y < 0) {
            return -1;
        }
        if (x >= 162 || y >= this.visibleRows * 18) {
            return -1;
        }
        int rowIndex = this.scrollbar.getCurrentScroll() + y / 18;
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            return -1;
        }
        return rowIndex;
    }

    @Override
    public boolean method_25402(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.searchField.method_25405(xCoord, yCoord)) {
            this.searchField.method_1852("");
        }
        return super.method_25402(xCoord, yCoord, btn);
    }

    @Override
    protected void method_2383(class_1735 slot, int slotIdx, int mouseButton, class_1713 clickType) {
        if (slot instanceof PatternSlot) {
            InventoryAction action = null;
            switch (clickType) {
                case field_7790: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case field_7794: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case field_7796: {
                    if (!this.getPlayer().method_31549().field_7477) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                PatternSlot machineSlot = (PatternSlot)slot;
                InventoryActionPacket p = new InventoryActionPacket(action, machineSlot.field_7875, machineSlot.getMachineInv().getServerId());
                NetworkHandler.instance().sendToServer(p);
            }
            return;
        }
        super.method_2383(slot, slotIdx, mouseButton, clickType);
    }

    @Override
    public void drawBG(class_332 guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.blit(guiGraphics, offsetX, offsetY, HEADER_BBOX);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int currentY = offsetY + 17;
        this.blit(guiGraphics, offsetX, currentY + this.visibleRows * 18, FOOTER_BBOX);
        for (int i = 0; i < this.visibleRows; ++i) {
            Row row;
            boolean firstLine = i == 0;
            boolean lastLine = i == this.visibleRows - 1;
            class_768 bbox = this.selectRowBackgroundBox(false, firstLine, lastLine);
            this.blit(guiGraphics, offsetX, currentY, bbox);
            if (scrollLevel + i < this.rows.size() && (row = this.rows.get(scrollLevel + i)) instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                bbox = this.selectRowBackgroundBox(true, firstLine, lastLine);
                bbox.method_35782(8 + 18 * slotsRow.slots - 1);
                this.blit(guiGraphics, offsetX, currentY, bbox);
            }
            currentY += 18;
        }
    }

    private class_768 selectRowBackgroundBox(boolean isInvLine, boolean firstLine, boolean lastLine) {
        if (isInvLine) {
            if (firstLine) {
                return ROW_INVENTORY_TOP_BBOX;
            }
            if (lastLine) {
                return ROW_INVENTORY_BOTTOM_BBOX;
            }
            return ROW_INVENTORY_MIDDLE_BBOX;
        }
        if (firstLine) {
            return ROW_TEXT_TOP_BBOX;
        }
        if (lastLine) {
            return ROW_TEXT_BOTTOM_BBOX;
        }
        return ROW_TEXT_MIDDLE_BBOX;
    }

    public boolean method_25400(char character, int key) {
        if (character == ' ' && this.searchField.method_1882().isEmpty()) {
            return true;
        }
        return super.method_25400(character, key);
    }

    public void clear() {
        this.byId.clear();
        this.cachedSearches.clear();
        this.refreshList();
    }

    public void postFullUpdate(long inventoryId, long sortBy, PatternContainerGroup group, int inventorySize, Int2ObjectMap<class_1799> slots) {
        PatternContainerRecord record = new PatternContainerRecord(inventoryId, inventorySize, sortBy, group);
        this.byId.put(inventoryId, record);
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (class_1799)entry.getValue());
        }
        this.cachedSearches.clear();
        this.refreshList();
    }

    public void postIncrementalUpdate(long inventoryId, Int2ObjectMap<class_1799> slots) {
        PatternContainerRecord record = this.byId.get(inventoryId);
        if (record == null) {
            LOGGER.warn("Ignoring incremental update for unknown inventory id {}", (Object)inventoryId);
            return;
        }
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (class_1799)entry.getValue());
        }
    }

    @Override
    public void updateBeforeRender() {
        this.showPatternProviders.set(((PatternAccessTermMenu)this.field_2797).getShownProviders());
    }

    private void refreshList() {
        this.byGroup.clear();
        String searchFilterLowerCase = this.searchField.method_1882().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(searchFilterLowerCase);
        boolean rebuild = cachedSearch.isEmpty();
        for (PatternContainerRecord entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFilterLowerCase.isEmpty();
            if (!found) {
                class_1799 itemStack;
                Iterator<Object> iterator = entry.getInventory().iterator();
                while (iterator.hasNext() && !(found = this.itemStackMatchesSearchTerm(itemStack = iterator.next(), searchFilterLowerCase))) {
                }
            }
            if (found || entry.getSearchName().contains(searchFilterLowerCase)) {
                this.byGroup.put((Object)entry.getGroup(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.groups.clear();
        this.groups.addAll(this.byGroup.keySet());
        this.groups.sort(GROUP_COMPARATOR);
        this.rows.clear();
        this.rows.ensureCapacity(this.getMaxRows());
        for (PatternContainerGroup group : this.groups) {
            this.rows.add(new GroupHeaderRow(group));
            ArrayList containers = new ArrayList(this.byGroup.get((Object)group));
            Collections.sort(containers);
            for (PatternContainerRecord container : containers) {
                AppEngInternalInventory inventory = container.getInventory();
                for (int offset = 0; offset < inventory.size(); offset += 9) {
                    int slots = Math.min(inventory.size() - offset, 9);
                    SlotsRow containerRow = new SlotsRow(container, offset, slots);
                    this.rows.add(containerRow);
                }
            }
        }
        this.resetScrollbar();
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(this.visibleRows * 18 - 2);
        this.scrollbar.setRange(0, this.rows.size() - this.visibleRows, 2);
    }

    private boolean itemStackMatchesSearchTerm(class_1799 itemStack, String searchTerm) {
        if (itemStack.method_7960()) {
            return false;
        }
        class_2487 encodedValue = itemStack.method_7969();
        if (encodedValue == null) {
            return false;
        }
        class_2499 outTag = encodedValue.method_10554("out", 10);
        for (int i = 0; i < outTag.size(); ++i) {
            String displayName;
            class_1799 parsedItemStack = class_1799.method_7915((class_2487)outTag.method_10602(i));
            AEItemKey itemKey = AEItemKey.of(parsedItemStack);
            if (itemKey == null || !(displayName = itemKey.getDisplayName().getString().toLowerCase()).contains(searchTerm)) continue;
            return true;
        }
        return false;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
        }
        return cache;
    }

    private void reinitialize() {
        this.method_25396().removeAll(this.field_33816);
        this.field_33816.clear();
        this.method_25426();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set(next);
        this.reinitialize();
    }

    private int getMaxRows() {
        return this.groups.size() + this.byId.size();
    }

    private void blit(class_332 guiGraphics, int offsetX, int offsetY, class_768 srcRect) {
        class_2960 texture = AppEng.makeId("textures/guis/patternaccessterminal.png");
        guiGraphics.method_25302(texture, offsetX, offsetY, srcRect.method_3321(), srcRect.method_3322(), srcRect.method_3319(), srcRect.method_3320());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface Row {
    }

    record SlotsRow(PatternContainerRecord container, int offset, int slots) implements Row
    {
    }

    record GroupHeaderRow(PatternContainerGroup group) implements Row
    {
    }
}

