/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1132;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_433;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

@Environment(value=EnvType.CLIENT)
public class GuidebookStructureCommands {
    @Nullable
    private static String lastOpenedOrSavedPath;
    private static final String[] FILE_PATTERNS;
    private static final String FILE_PATTERN_DESC = "Structure NBT Files (*.snbt, *.nbt)";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder rootCommand = LiteralArgumentBuilder.literal((String)"ae2guide");
        GuidebookStructureCommands.registerImportCommand((LiteralArgumentBuilder<class_2168>)rootCommand);
        GuidebookStructureCommands.registerExportCommand((LiteralArgumentBuilder<class_2168>)rootCommand);
        dispatcher.register(rootCommand);
    }

    private static void registerImportCommand(LiteralArgumentBuilder<class_2168> rootCommand) {
        LiteralArgumentBuilder importSubcommand = LiteralArgumentBuilder.literal((String)"importstructure");
        importSubcommand.requires(source -> class_310.method_1551().method_1496());
        importSubcommand.then(class_2170.method_9244((String)"origin", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_2338 origin = class_2262.method_48299((CommandContext)context, (String)"origin");
            GuidebookStructureCommands.importStructure(((class_2168)context.getSource()).method_9225(), origin);
            return 0;
        }));
        rootCommand.then((ArgumentBuilder)importSubcommand);
    }

    private static void importStructure(class_3218 level, class_2338 origin) {
        class_310 minecraft = class_310.method_1551();
        class_1132 server = minecraft.method_1576();
        class_746 player = minecraft.field_1724;
        if (server == null || player == null) {
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(GuidebookStructureCommands::pickFileForOpen, (Executor)minecraft).thenApplyAsync(selectedPath -> {
            if (selectedPath == null) {
                return null;
            }
            lastOpenedOrSavedPath = selectedPath;
            class_3485 manager = server.method_27727();
            try {
                class_2487 compound;
                if (selectedPath.toLowerCase(Locale.ROOT).endsWith(".snbt")) {
                    String textInFile = Files.readString(Paths.get(selectedPath, new String[0]), StandardCharsets.UTF_8);
                    try {
                        compound = class_2512.method_32260((String)textInFile);
                    }
                    catch (CommandSyntaxException e) {
                        player.method_43496((class_2561)class_2561.method_43470((String)e.toString()));
                        return null;
                    }
                }
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream((String)selectedPath));){
                    compound = class_2507.method_10629((InputStream)is);
                }
                class_3499 structure = manager.method_21891(compound);
                if (!structure.method_15172((class_5425)level, origin, origin, new class_3492(), (class_5819)new class_6575(0L), 2)) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"Failed to place structure"));
                } else {
                    player.method_43496((class_2561)class_2561.method_43470((String)"Placed structure"));
                }
            }
            catch (Exception e) {
                player.method_43496((class_2561)class_2561.method_43470((String)e.toString()));
            }
            return null;
        }, (Executor)server)).thenRunAsync(() -> {
            if (minecraft.field_1755 instanceof class_433) {
                minecraft.method_1507(null);
            }
        }, (Executor)minecraft);
    }

    private static void registerExportCommand(LiteralArgumentBuilder<class_2168> rootCommand) {
        LiteralArgumentBuilder exportSubcommand = LiteralArgumentBuilder.literal((String)"exportstructure");
        exportSubcommand.requires(source -> class_310.method_1551().method_1496());
        exportSubcommand.then(class_2170.method_9244((String)"origin", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"sizeX", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"sizeY", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"sizeZ", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            class_2338 origin = class_2262.method_48299((CommandContext)context, (String)"origin");
            int sizeX = IntegerArgumentType.getInteger((CommandContext)context, (String)"sizeX");
            int sizeY = IntegerArgumentType.getInteger((CommandContext)context, (String)"sizeY");
            int sizeZ = IntegerArgumentType.getInteger((CommandContext)context, (String)"sizeZ");
            class_2382 size = new class_2382(sizeX, sizeY, sizeZ);
            GuidebookStructureCommands.exportStructure(((class_2168)context.getSource()).method_9225(), origin, size);
            return 0;
        })))));
        rootCommand.then((ArgumentBuilder)exportSubcommand);
    }

    private static void exportStructure(class_3218 level, class_2338 origin, class_2382 size) {
        class_310 minecraft = class_310.method_1551();
        class_1132 server = minecraft.method_1576();
        class_746 player = minecraft.field_1724;
        if (server == null || player == null) {
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(GuidebookStructureCommands::pickFileForSave, (Executor)minecraft).thenApplyAsync(selectedPath -> {
            if (selectedPath == null) {
                return null;
            }
            try {
                class_2338 to = class_2338.method_20437((class_2338)origin, (class_2338)origin.method_10069(size.method_10263() - 1, size.method_10264() - 1, size.method_10260() - 1)).filter(pos -> !level.method_8320(pos).method_26215()).reduce(origin, (blockPos, blockPos2) -> new class_2338(Math.max(blockPos.method_10263(), blockPos2.method_10263()), Math.max(blockPos.method_10264(), blockPos2.method_10264()), Math.max(blockPos.method_10260(), blockPos2.method_10260())));
                class_2338 actualSize = new class_2338(1 + to.method_10263() - origin.method_10263(), 1 + to.method_10264() - origin.method_10264(), 1 + to.method_10260() - origin.method_10260());
                class_3499 structureTemplate = new class_3499();
                structureTemplate.method_15174((class_1937)level, origin, (class_2382)actualSize, false, class_2246.field_10124);
                class_2487 compound = structureTemplate.method_15175(new class_2487());
                if (selectedPath.toLowerCase(Locale.ROOT).endsWith(".snbt")) {
                    Files.writeString(Paths.get(selectedPath, new String[0]), (CharSequence)class_2512.method_32271((class_2487)compound), StandardCharsets.UTF_8, new OpenOption[0]);
                } else {
                    class_2507.method_30614((class_2487)compound, (File)new File((String)selectedPath));
                }
                player.method_43496((class_2561)class_2561.method_43470((String)"Saved structure"));
            }
            catch (IOException e) {
                player.method_43496((class_2561)class_2561.method_43470((String)e.toString()));
            }
            return null;
        }, (Executor)server)).thenRunAsync(() -> {
            if (minecraft.field_1755 instanceof class_433) {
                minecraft.method_1507(null);
            }
        }, (Executor)minecraft);
    }

    private static String pickFileForOpen() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            String string = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Load Structure", (CharSequence)lastOpenedOrSavedPath, (PointerBuffer)GuidebookStructureCommands.createFilterPatterns(stack), (CharSequence)FILE_PATTERN_DESC, (boolean)false);
            return string;
        }
    }

    private static String pickFileForSave() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            String string = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)"Save Structure", (CharSequence)lastOpenedOrSavedPath, (PointerBuffer)GuidebookStructureCommands.createFilterPatterns(stack), (CharSequence)FILE_PATTERN_DESC);
            return string;
        }
    }

    private static PointerBuffer createFilterPatterns(MemoryStack stack) {
        PointerBuffer filterPatternsBuffer = stack.mallocPointer(FILE_PATTERNS.length);
        for (String pattern : FILE_PATTERNS) {
            filterPatternsBuffer.put(stack.UTF8((CharSequence)pattern));
        }
        filterPatternsBuffer.flip();
        return filterPatternsBuffer;
    }

    static {
        FILE_PATTERNS = new String[]{"*.snbt", "*.nbt"};
    }
}

