/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.models;

import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.IOrientationStrategy;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.IGeneratedBlockstate;

class VariantsBuilder
implements IGeneratedBlockstate {
    private final class_2248 block;
    private final JsonObject blockStateDef = new JsonObject();
    private final JsonObject variantsDef;

    public VariantsBuilder(class_2248 block) {
        this.block = block;
        this.variantsDef = new JsonObject();
        this.blockStateDef.add("variants", (JsonElement)this.variantsDef);
    }

    public VariantsBuilder generateRotations(BlockModelBuilder model) {
        this.generateRotations(this.block.method_9564(), model);
        return this;
    }

    public VariantsBuilder generateRotations(class_2680 baseState, BlockModelBuilder model) {
        IOrientationStrategy strategy = IOrientationStrategy.get(baseState);
        strategy.getAllStates(baseState).forEachOrdered(blockState -> {
            StringBuilder stateText = new StringBuilder();
            for (class_2769<?> property : strategy.getProperties()) {
                if (stateText.length() > 0) {
                    stateText.append(',');
                }
                VariantsBuilder.appendStateProperty(blockState, property, stateText);
            }
            BlockOrientation modelRotation = BlockOrientation.get(strategy, blockState);
            int rotationX = modelRotation.getAngleX();
            int rotationY = modelRotation.getAngleY();
            int rotationZ = modelRotation.getAngleZ();
            JsonObject modelObj = new JsonObject();
            modelObj.addProperty("model", model.getLocation().toString());
            if (rotationX != 0) {
                modelObj.addProperty("x", (Number)rotationX);
            }
            if (rotationY != 0) {
                modelObj.addProperty("x", (Number)rotationY);
            }
            if (rotationZ != 0) {
                modelObj.addProperty("ae2:z", (Number)rotationZ);
            }
            this.variantsDef.add(stateText.toString(), (JsonElement)modelObj);
        });
        return this;
    }

    public JsonObject toJson() {
        return this.blockStateDef;
    }

    private static <T extends Comparable<T>> void appendStateProperty(class_2680 blockState, class_2769<T> property, StringBuilder stateText) {
        stateText.append(property.method_11899());
        stateText.append('=');
        stateText.append(property.method_11901(blockState.method_11654(property)));
    }
}

