/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.blockentity.spatial.SpatialIOPortBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.PlotBuilder;
import appeng.server.testworld.PlotTestHelper;
import appeng.spatial.SpatialStoragePlot;
import appeng.spatial.SpatialStoragePlotManager;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_3218;

public final class SpatialTestPlots {
    private SpatialTestPlots() {
    }

    @TestPlot(value="controller_inside_scs")
    public static void controllerInsideScs(PlotBuilder plot) {
        plot.creativeEnergyCell("0 0 0");
        plot.block("[1,10] 0 0", AEBlocks.SPATIAL_PYLON);
        plot.block("0 [1,10] 0", AEBlocks.SPATIAL_PYLON);
        plot.block("0 0 [1,10]", AEBlocks.SPATIAL_PYLON);
        plot.blockEntity("-1 0 0", AEBlocks.SPATIAL_IO_PORT, port -> port.getInternalInventory().insertItem(0, AEItems.SPATIAL_CELL128.stack(), false));
        class_2338 leverPos = plot.leverOn(new class_2338(-1, 0, 0), class_2350.field_11039);
        plot.creativeEnergyCell("[4,6] 3 [4,6]");
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    boolean edge;
                    boolean bl = edge = Math.abs(x) + Math.abs(y) + Math.abs(z) >= 2;
                    if (!edge) continue;
                    plot.block(new class_2338(5 + x, 5 + y, 5 + z), AEBlocks.CONTROLLER);
                }
            }
        }
        plot.test(helper -> helper.method_36041().method_36076(5).method_36085(() -> helper.method_36039(leverPos)).method_36076(5).method_36075());
    }

    @TestPlot(value="spatial_entity_storage")
    public static void storeAndRetrieveEntities(PlotBuilder plot) {
        class_2338 chickenPos = new class_2338(1, 1, 1);
        class_2338 ioPortPos = new class_2338(-1, 0, 0);
        plot.creativeEnergyCell("0 0 0");
        plot.block("[1,2] 0 0", AEBlocks.SPATIAL_PYLON);
        plot.block("0 [1,2] 0", AEBlocks.SPATIAL_PYLON);
        plot.block("0 0 [1,2]", AEBlocks.SPATIAL_PYLON);
        plot.block(chickenPos.method_10074(), class_2246.field_10340);
        plot.block(chickenPos.method_10084(), class_2246.field_10340);
        for (int i = 0; i < 4; ++i) {
            class_2350 dir = class_2350.method_10139((int)i);
            plot.block(chickenPos.method_10093(dir), class_2246.field_10033);
            plot.block(chickenPos.method_10093(dir).method_10084(), class_2246.field_10033);
        }
        plot.blockEntity(ioPortPos, AEBlocks.SPATIAL_IO_PORT, port -> port.getInternalInventory().insertItem(0, AEItems.SPATIAL_CELL2.stack(), false));
        class_2338 buttonPos = plot.buttonOn(ioPortPos, class_2350.field_11039);
        plot.test(helper -> helper.method_36041().method_36085(() -> {
            helper.method_36001();
            helper.method_35964(class_1299.field_6132, chickenPos.method_10084());
            helper.method_35968(class_1802.field_8281, (float)chickenPos.method_10263() + 0.5f, (float)chickenPos.method_10264() + 0.5f, (float)chickenPos.method_10260() + 0.5f);
        }).method_36076(5).method_36085(() -> helper.method_36026(buttonPos)).method_36076(5).method_36085(() -> {
            helper.method_35970(class_1802.field_8281, chickenPos, 1.0, 0);
            helper.method_44606(class_1299.field_6132, chickenPos, 0, 1.0);
            class_1799 cell = SpatialTestPlots.getCellFromSpatialIoPortOutput(helper, ioPortPos);
            SpatialTestPlots.insertCell(helper, ioPortPos, cell);
        }).method_36076(25).method_36085(() -> helper.method_36026(buttonPos)).method_36076(5).method_36085(() -> {
            helper.method_35970(class_1802.field_8281, chickenPos, 1.0, 1);
            helper.method_44606(class_1299.field_6132, chickenPos, 1, 1.0);
        }).method_36075());
    }

    private static class_1799 getCellFromSpatialIoPortOutput(PlotTestHelper helper, class_2338 ioPortPos) {
        SpatialIOPortBlockEntity spatialIoPort = (SpatialIOPortBlockEntity)helper.method_36014(ioPortPos);
        class_1799 cell = spatialIoPort.getInternalInventory().extractItem(1, 1, false);
        helper.check(AEItems.SPATIAL_CELL2.isSameAs(cell), "no spatial cell in output slot", ioPortPos);
        return cell;
    }

    private static void insertCell(PlotTestHelper helper, class_2338 ioPortPos, class_1799 cell) {
        SpatialIOPortBlockEntity spatialIoPort = (SpatialIOPortBlockEntity)helper.method_36014(ioPortPos);
        spatialIoPort.getInternalInventory().insertItem(0, cell, false);
    }

    private static PlotInfo getPlotInfo(PlotTestHelper helper, class_2338 ioPortPos, class_1799 cell) {
        helper.check(cell.method_7909() instanceof ISpatialStorageCell, "cell is not a spatial cell", ioPortPos);
        ISpatialStorageCell spatialCell = (ISpatialStorageCell)cell.method_7909();
        int plotId = spatialCell.getAllocatedPlotId(cell);
        SpatialStoragePlot plot = SpatialStoragePlotManager.INSTANCE.getPlot(plotId);
        helper.check(plot != null, "plot not found", ioPortPos);
        return new PlotInfo(SpatialStoragePlotManager.INSTANCE.getLevel(), new class_238(plot.getOrigin(), plot.getOrigin().method_10081((class_2382)plot.getSize())), plot.getOrigin());
    }

    record PlotInfo(class_3218 level, class_238 bounds, class_2338 origin) {
    }
}

