/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.parent;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.SortMode;
import me.lucko.luckperms.common.command.utils.SortType;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.comparator.NodeWithContextComparator;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Iterators;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;

public class ParentInfo
extends GenericChildCommand {
    private static final Comparator<InheritanceNode> ALPHABETICAL_NODE_COMPARATOR = (o1, o2) -> {
        int i = o1.getGroupName().compareTo(o2.getGroupName());
        if (i != 0) {
            return i;
        }
        return NodeWithContextComparator.reverse().compare((Node)o1, (Node)o2);
    };

    public ParentInfo() {
        super(CommandSpec.PARENT_INFO, "info", CommandPermission.USER_PARENT_INFO, CommandPermission.GROUP_PARENT_INFO, Predicates.notInRange(0, 2));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder target, ArgumentList args, String label, CommandPermission permission) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, permission, target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        int page = args.getIntOrDefault(0, 1);
        SortMode sortMode = SortMode.determine(args);
        LinkedList<InheritanceNode> nodes = new LinkedList<InheritanceNode>();
        target.normalData().copyInheritanceNodesTo(nodes, QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL);
        nodes.removeIf(node -> !node.getValue());
        if (nodes.isEmpty()) {
            Message.PARENT_INFO_NO_DATA.send(sender, target);
            return;
        }
        if (sortMode.getType() == SortType.ALPHABETICALLY) {
            nodes.sort(ALPHABETICAL_NODE_COMPARATOR);
        }
        if (!sortMode.isAscending()) {
            Collections.reverse(nodes);
        }
        int pageIndex = page - 1;
        List pages = Iterators.divideIterable(nodes, 19);
        if (pageIndex < 0 || pageIndex >= pages.size()) {
            page = 1;
            pageIndex = 0;
        }
        List content = pages.get(pageIndex);
        Message.PARENT_INFO.send(sender, target, page, pages.size(), nodes.size());
        for (InheritanceNode node2 : content) {
            if (node2.hasExpiry()) {
                Message.PARENT_INFO_TEMPORARY_NODE_ENTRY.send(sender, node2, target, label);
                continue;
            }
            Message.PARENT_INFO_NODE_ENTRY.send(sender, node2, target, label);
        }
    }
}

