/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.lucko.luckperms.common.cacheddata.type.SimpleMetaValueSelector;
import me.lucko.luckperms.common.config.generic.KeyedConfiguration;
import me.lucko.luckperms.common.config.generic.adapter.ConfigurationAdapter;
import me.lucko.luckperms.common.config.generic.key.ConfigKey;
import me.lucko.luckperms.common.config.generic.key.ConfigKeyFactory;
import me.lucko.luckperms.common.config.generic.key.SimpleConfigKey;
import me.lucko.luckperms.common.context.calculator.WorldNameRewriter;
import me.lucko.luckperms.common.graph.TraversalAlgorithm;
import me.lucko.luckperms.common.metastacking.SimpleMetaStackDefinition;
import me.lucko.luckperms.common.metastacking.StandardStackElements;
import me.lucko.luckperms.common.model.PrimaryGroupHolder;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.query.QueryOptionsBuilderImpl;
import me.lucko.luckperms.common.storage.StorageType;
import me.lucko.luckperms.common.storage.implementation.split.SplitStorageType;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.context.ContextSatisfyMode;
import net.luckperms.api.metastacking.DuplicateRemovalFunction;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.model.data.TemporaryNodeMergeStrategy;
import net.luckperms.api.platform.Platform;
import net.luckperms.api.query.Flag;
import net.luckperms.api.query.QueryMode;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.query.meta.MetaValueSelector;

public final class ConfigKeys {
    public static final ConfigKey<String> SERVER = ConfigKeyFactory.lowercaseStringKey("server", "global");
    public static final ConfigKey<Integer> SYNC_TIME = ConfigKeyFactory.notReloadable(ConfigKeyFactory.key(c -> {
        int val = c.getInteger("sync-minutes", -1);
        if (val == -1) {
            val = c.getInteger("data.sync-minutes", -1);
        }
        return val;
    }));
    public static final ConfigKey<QueryOptions> GLOBAL_QUERY_OPTIONS = ConfigKeyFactory.key(c -> {
        EnumSet<Flag> flags = EnumSet.of(Flag.RESOLVE_INHERITANCE);
        if (c.getBoolean("include-global", true)) {
            flags.add(Flag.INCLUDE_NODES_WITHOUT_SERVER_CONTEXT);
        }
        if (c.getBoolean("include-global-world", true)) {
            flags.add(Flag.INCLUDE_NODES_WITHOUT_WORLD_CONTEXT);
        }
        if (c.getBoolean("apply-global-groups", true)) {
            flags.add(Flag.APPLY_INHERITANCE_NODES_WITHOUT_SERVER_CONTEXT);
        }
        if (c.getBoolean("apply-global-world-groups", true)) {
            flags.add(Flag.APPLY_INHERITANCE_NODES_WITHOUT_WORLD_CONTEXT);
        }
        return new QueryOptionsBuilderImpl(QueryMode.CONTEXTUAL).flags(flags).build();
    });
    public static final ConfigKey<ContextSatisfyMode> CONTEXT_SATISFY_MODE = ConfigKeyFactory.key(c -> {
        String value = c.getString("context-satisfy-mode", "at-least-one-value-per-key");
        if (value.equalsIgnoreCase("all-values-per-key")) {
            return ContextSatisfyMode.ALL_VALUES_PER_KEY;
        }
        return ContextSatisfyMode.AT_LEAST_ONE_VALUE_PER_KEY;
    });
    public static final ConfigKey<Set<String>> DISABLED_CONTEXTS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.key(c -> (Set)c.getStringList("disabled-contexts", (List<String>)ImmutableList.of()).stream().map(String::toLowerCase).collect(ImmutableCollectors.toSet())));
    public static final ConfigKey<Boolean> USE_SERVER_UUID_CACHE = ConfigKeyFactory.booleanKey("use-server-uuid-cache", false);
    public static final ConfigKey<Boolean> ALLOW_INVALID_USERNAMES = ConfigKeyFactory.booleanKey("allow-invalid-usernames", false);
    public static final ConfigKey<Boolean> SKIP_BULKUPDATE_CONFIRMATION = ConfigKeyFactory.booleanKey("skip-bulkupdate-confirmation", false);
    public static final ConfigKey<Boolean> DISABLE_BULKUPDATE = ConfigKeyFactory.booleanKey("disable-bulkupdate", false);
    public static final ConfigKey<Boolean> DEBUG_LOGINS = ConfigKeyFactory.booleanKey("debug-logins", false);
    public static final ConfigKey<Boolean> CANCEL_FAILED_LOGINS = ConfigKeyFactory.booleanKey("cancel-failed-logins", false);
    public static final ConfigKey<Boolean> UPDATE_CLIENT_COMMAND_LIST = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("update-client-command-list", true));
    public static final ConfigKey<Boolean> REGISTER_COMMAND_LIST_DATA = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("register-command-list-data", true));
    public static final ConfigKey<Boolean> RESOLVE_COMMAND_SELECTORS = ConfigKeyFactory.booleanKey("resolve-command-selectors", false);
    public static final ConfigKey<TemporaryNodeMergeStrategy> TEMPORARY_ADD_BEHAVIOUR = ConfigKeyFactory.key(c -> {
        String value = c.getString("temporary-add-behaviour", "deny");
        switch (value.toLowerCase(Locale.ROOT)) {
            case "accumulate": {
                return TemporaryNodeMergeStrategy.ADD_NEW_DURATION_TO_EXISTING;
            }
            case "replace": {
                return TemporaryNodeMergeStrategy.REPLACE_EXISTING_IF_DURATION_LONGER;
            }
        }
        return TemporaryNodeMergeStrategy.NONE;
    });
    public static final ConfigKey<String> PRIMARY_GROUP_CALCULATION_METHOD = ConfigKeyFactory.notReloadable(ConfigKeyFactory.key(c -> {
        String option = c.getString("primary-group-calculation", "stored").toLowerCase(Locale.ROOT);
        if (!(option.equals("stored") || option.equals("parents-by-weight") || option.equals("all-parents-by-weight"))) {
            option = "stored";
        }
        return option;
    }));
    public static final ConfigKey<Function<User, PrimaryGroupHolder>> PRIMARY_GROUP_CALCULATION = ConfigKeyFactory.notReloadable(ConfigKeyFactory.key(c -> {
        String option;
        switch (option = PRIMARY_GROUP_CALCULATION_METHOD.get((ConfigurationAdapter)c)) {
            case "stored": {
                return PrimaryGroupHolder.Stored::new;
            }
            case "parents-by-weight": {
                return PrimaryGroupHolder.ParentsByWeight::new;
            }
        }
        return PrimaryGroupHolder.AllParentsByWeight::new;
    }));
    public static final ConfigKey<Boolean> PREVENT_PRIMARY_GROUP_REMOVAL = ConfigKeyFactory.booleanKey("prevent-primary-group-removal", true);
    public static final ConfigKey<Boolean> USE_ARGUMENT_BASED_COMMAND_PERMISSIONS = ConfigKeyFactory.booleanKey("argument-based-command-permissions", false);
    public static final ConfigKey<Boolean> REQUIRE_SENDER_GROUP_MEMBERSHIP_TO_MODIFY = ConfigKeyFactory.booleanKey("require-sender-group-membership-to-modify", false);
    public static final ConfigKey<Boolean> APPLYING_WILDCARDS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("apply-wildcards", true));
    public static final ConfigKey<Boolean> APPLYING_WILDCARDS_SPONGE = ConfigKeyFactory.notReloadable(ConfigKeyFactory.key(c -> {
        boolean def = c.getPlugin().getBootstrap().getType() == Platform.Type.SPONGE;
        return c.getBoolean("apply-sponge-implicit-wildcards", def);
    }));
    public static final ConfigKey<Boolean> APPLY_DEFAULT_NEGATIONS_BEFORE_WILDCARDS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("apply-default-negated-permissions-before-wildcards", false));
    public static final ConfigKey<Boolean> APPLYING_REGEX = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("apply-regex", true));
    public static final ConfigKey<Boolean> APPLYING_SHORTHAND = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("apply-shorthand", true));
    public static final ConfigKey<Boolean> APPLY_BUKKIT_CHILD_PERMISSIONS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("apply-bukkit-child-permissions", true));
    public static final ConfigKey<Boolean> APPLY_BUKKIT_DEFAULT_PERMISSIONS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("apply-bukkit-default-permissions", true));
    public static final ConfigKey<Boolean> APPLY_BUKKIT_ATTACHMENT_PERMISSIONS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("apply-bukkit-attachment-permissions", true));
    public static final ConfigKey<Boolean> APPLY_NUKKIT_CHILD_PERMISSIONS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("apply-nukkit-child-permissions", true));
    public static final ConfigKey<Boolean> APPLY_NUKKIT_DEFAULT_PERMISSIONS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("apply-nukkit-default-permissions", true));
    public static final ConfigKey<Boolean> APPLY_NUKKIT_ATTACHMENT_PERMISSIONS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("apply-nukkit-attachment-permissions", true));
    public static final ConfigKey<Boolean> APPLY_BUNGEE_CONFIG_PERMISSIONS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("apply-bungee-config-permissions", false));
    public static final ConfigKey<Boolean> APPLY_SPONGE_DEFAULT_SUBJECTS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("apply-sponge-default-subjects", true));
    public static final ConfigKey<TraversalAlgorithm> INHERITANCE_TRAVERSAL_ALGORITHM = ConfigKeyFactory.key(c -> {
        String value = c.getString("inheritance-traversal-algorithm", "depth-first-pre-order");
        switch (value.toLowerCase(Locale.ROOT)) {
            case "breadth-first": {
                return TraversalAlgorithm.BREADTH_FIRST;
            }
            case "depth-first-post-order": {
                return TraversalAlgorithm.DEPTH_FIRST_POST_ORDER;
            }
        }
        return TraversalAlgorithm.DEPTH_FIRST_PRE_ORDER;
    });
    public static final ConfigKey<Boolean> POST_TRAVERSAL_INHERITANCE_SORT = ConfigKeyFactory.booleanKey("post-traversal-inheritance-sort", false);
    public static final ConfigKey<MetaValueSelector> META_VALUE_SELECTOR = ConfigKeyFactory.key(c -> {
        SimpleMetaValueSelector.Strategy defaultStrategy = SimpleMetaValueSelector.Strategy.parse(c.getString("meta-value-selection-default", "inheritance"));
        Map strategies = (Map)c.getStringMap("meta-value-selection", (Map<String, String>)ImmutableMap.of()).entrySet().stream().map(e -> {
            SimpleMetaValueSelector.Strategy parse = SimpleMetaValueSelector.Strategy.parse((String)e.getValue());
            return parse == null ? null : Maps.immutableEntry((Object)((String)e.getKey()), (Object)((Object)parse));
        }).filter(Objects::nonNull).collect(ImmutableCollectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new SimpleMetaValueSelector(strategies, defaultStrategy);
    });
    public static final ConfigKey<Map<String, Integer>> GROUP_WEIGHTS = ConfigKeyFactory.key(c -> (Map)c.getStringMap("group-weight", (Map<String, String>)ImmutableMap.of()).entrySet().stream().collect(ImmutableCollectors.toMap(e -> ((String)e.getKey()).toLowerCase(Locale.ROOT), e -> {
        try {
            return Integer.parseInt((String)e.getValue());
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    })));
    public static final ConfigKey<MetaStackDefinition> PREFIX_FORMATTING_OPTIONS = ConfigKeyFactory.key(l -> {
        DuplicateRemovalFunction duplicateRemovalFunction;
        List<String> format = l.getStringList("meta-formatting.prefix.format", new ArrayList<String>());
        if (format.isEmpty()) {
            format.add("highest");
        }
        String startSpacer = l.getString("meta-formatting.prefix.start-spacer", "");
        String middleSpacer = l.getString("meta-formatting.prefix.middle-spacer", " ");
        String endSpacer = l.getString("meta-formatting.prefix.end-spacer", "");
        switch (l.getString("meta-formatting.prefix.duplicates", "").toLowerCase(Locale.ROOT)) {
            case "first-only": {
                duplicateRemovalFunction = DuplicateRemovalFunction.FIRST_ONLY;
                break;
            }
            case "last-only": {
                duplicateRemovalFunction = DuplicateRemovalFunction.LAST_ONLY;
                break;
            }
            default: {
                duplicateRemovalFunction = DuplicateRemovalFunction.RETAIN_ALL;
            }
        }
        return new SimpleMetaStackDefinition(StandardStackElements.parseList(l.getPlugin(), format), duplicateRemovalFunction, startSpacer, middleSpacer, endSpacer);
    });
    public static final ConfigKey<MetaStackDefinition> SUFFIX_FORMATTING_OPTIONS = ConfigKeyFactory.key(l -> {
        DuplicateRemovalFunction duplicateRemovalFunction;
        List<String> format = l.getStringList("meta-formatting.suffix.format", new ArrayList<String>());
        if (format.isEmpty()) {
            format.add("highest");
        }
        String startSpacer = l.getString("meta-formatting.suffix.start-spacer", "");
        String middleSpacer = l.getString("meta-formatting.suffix.middle-spacer", " ");
        String endSpacer = l.getString("meta-formatting.suffix.end-spacer", "");
        switch (l.getString("meta-formatting.suffix.duplicates", "").toLowerCase(Locale.ROOT)) {
            case "first-only": {
                duplicateRemovalFunction = DuplicateRemovalFunction.FIRST_ONLY;
                break;
            }
            case "last-only": {
                duplicateRemovalFunction = DuplicateRemovalFunction.LAST_ONLY;
                break;
            }
            default: {
                duplicateRemovalFunction = DuplicateRemovalFunction.RETAIN_ALL;
            }
        }
        return new SimpleMetaStackDefinition(StandardStackElements.parseList(l.getPlugin(), format), duplicateRemovalFunction, startSpacer, middleSpacer, endSpacer);
    });
    public static final ConfigKey<Boolean> LOG_NOTIFY = ConfigKeyFactory.booleanKey("log-notify", true);
    public static final ConfigKey<List<Pattern>> LOG_NOTIFY_FILTERED_DESCRIPTIONS = ConfigKeyFactory.key(c -> (List)c.getStringList("log-notify-filtered-descriptions", (List<String>)ImmutableList.of()).stream().map(entry -> {
        try {
            return Pattern.compile(entry, 2);
        }
        catch (PatternSyntaxException e) {
            new IllegalArgumentException("Invalid pattern: " + entry, e).printStackTrace();
            return null;
        }
    }).filter(Objects::nonNull).collect(ImmutableCollectors.toList()));
    public static final ConfigKey<Boolean> AUTO_INSTALL_TRANSLATIONS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("auto-install-translations", true));
    public static final ConfigKey<Boolean> AUTO_OP = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("auto-op", false));
    public static final ConfigKey<Boolean> OPS_ENABLED = ConfigKeyFactory.notReloadable(ConfigKeyFactory.key(c -> AUTO_OP.get((ConfigurationAdapter)c) == false && c.getBoolean("enable-ops", true)));
    public static final ConfigKey<Boolean> COMMANDS_ALLOW_OP = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("commands-allow-op", true));
    public static final ConfigKey<Boolean> COMMANDS_RATE_LIMIT = ConfigKeyFactory.booleanKey("commands-rate-limit", true);
    public static final ConfigKey<Boolean> VAULT_UNSAFE_LOOKUPS = ConfigKeyFactory.booleanKey("vault-unsafe-lookups", false);
    public static final ConfigKey<Boolean> VAULT_GROUP_USE_DISPLAYNAMES = ConfigKeyFactory.booleanKey("vault-group-use-displaynames", true);
    public static final ConfigKey<String> VAULT_NPC_GROUP = ConfigKeyFactory.stringKey("vault-npc-group", "default");
    public static final ConfigKey<Boolean> VAULT_NPC_OP_STATUS = ConfigKeyFactory.booleanKey("vault-npc-op-status", false);
    public static final ConfigKey<Boolean> USE_VAULT_SERVER = ConfigKeyFactory.booleanKey("use-vault-server", false);
    public static final ConfigKey<String> VAULT_SERVER = ConfigKeyFactory.lowercaseStringKey("vault-server", "global");
    public static final ConfigKey<Boolean> VAULT_INCLUDING_GLOBAL = ConfigKeyFactory.booleanKey("vault-include-global", true);
    public static final ConfigKey<Boolean> VAULT_IGNORE_WORLD = ConfigKeyFactory.booleanKey("vault-ignore-world", false);
    public static final ConfigKey<Boolean> INTEGRATED_SERVER_OWNER_BYPASSES_CHECKS = ConfigKeyFactory.booleanKey("integrated-server-owner-bypasses-checks", true);
    public static final ConfigKey<Set<Predicate<String>>> DISABLED_CONTEXT_CALCULATORS = ConfigKeyFactory.key(c -> (Set)c.getStringList("disabled-context-calculators", (List<String>)ImmutableList.of()).stream().map(Predicates::startsWithIgnoreCase).collect(ImmutableCollectors.toSet()));
    public static final ConfigKey<WorldNameRewriter> WORLD_REWRITES = ConfigKeyFactory.key(c -> WorldNameRewriter.of((Map)c.getStringMap("world-rewrite", (Map<String, String>)ImmutableMap.of()).entrySet().stream().collect(ImmutableCollectors.toMap(e -> ((String)e.getKey()).toLowerCase(Locale.ROOT), e -> ((String)e.getValue()).toLowerCase(Locale.ROOT)))));
    public static final ConfigKey<Map<String, String>> GROUP_NAME_REWRITES = ConfigKeyFactory.mapKey("group-name-rewrite");
    public static final ConfigKey<StorageCredentials> DATABASE_VALUES = ConfigKeyFactory.notReloadable(ConfigKeyFactory.key(c -> {
        int maxPoolSize = c.getInteger("data.pool-settings.maximum-pool-size", c.getInteger("data.pool-size", 10));
        int minIdle = c.getInteger("data.pool-settings.minimum-idle", maxPoolSize);
        int maxLifetime = c.getInteger("data.pool-settings.maximum-lifetime", 1800000);
        int keepAliveTime = c.getInteger("data.pool-settings.keepalive-time", 0);
        int connectionTimeout = c.getInteger("data.pool-settings.connection-timeout", 5000);
        ImmutableMap props = ImmutableMap.copyOf(c.getStringMap("data.pool-settings.properties", (Map<String, String>)ImmutableMap.of()));
        return new StorageCredentials(c.getString("data.address", null), c.getString("data.database", null), c.getString("data.username", null), c.getString("data.password", null), maxPoolSize, minIdle, maxLifetime, keepAliveTime, connectionTimeout, (Map<String, String>)props);
    }));
    public static final ConfigKey<String> SQL_TABLE_PREFIX = ConfigKeyFactory.notReloadable(ConfigKeyFactory.key(c -> c.getString("data.table-prefix", c.getString("data.table_prefix", "luckperms_"))));
    public static final ConfigKey<String> MONGODB_COLLECTION_PREFIX = ConfigKeyFactory.notReloadable(ConfigKeyFactory.key(c -> c.getString("data.mongodb-collection-prefix", c.getString("data.mongodb_collection_prefix", ""))));
    public static final ConfigKey<String> MONGODB_CONNECTION_URI = ConfigKeyFactory.notReloadable(ConfigKeyFactory.key(c -> c.getString("data.mongodb-connection-uri", c.getString("data.mongodb_connection_URI", ""))));
    public static final ConfigKey<StorageType> STORAGE_METHOD = ConfigKeyFactory.notReloadable(ConfigKeyFactory.key(c -> StorageType.parse(c.getString("storage-method", "h2"), StorageType.H2)));
    public static final ConfigKey<Boolean> WATCH_FILES = ConfigKeyFactory.booleanKey("watch-files", true);
    public static final ConfigKey<Boolean> SPLIT_STORAGE = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("split-storage.enabled", false));
    public static final ConfigKey<Map<SplitStorageType, StorageType>> SPLIT_STORAGE_OPTIONS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.key(c -> {
        EnumMap<SplitStorageType, StorageType> map = new EnumMap<SplitStorageType, StorageType>(SplitStorageType.class);
        map.put(SplitStorageType.USER, StorageType.parse(c.getString("split-storage.methods.user", "h2"), StorageType.H2));
        map.put(SplitStorageType.GROUP, StorageType.parse(c.getString("split-storage.methods.group", "h2"), StorageType.H2));
        map.put(SplitStorageType.TRACK, StorageType.parse(c.getString("split-storage.methods.track", "h2"), StorageType.H2));
        map.put(SplitStorageType.UUID, StorageType.parse(c.getString("split-storage.methods.uuid", "h2"), StorageType.H2));
        map.put(SplitStorageType.LOG, StorageType.parse(c.getString("split-storage.methods.log", "h2"), StorageType.H2));
        return ImmutableMap.copyOf(map);
    }));
    public static final ConfigKey<String> MESSAGING_SERVICE = ConfigKeyFactory.notReloadable(ConfigKeyFactory.lowercaseStringKey("messaging-service", "auto"));
    public static final ConfigKey<Boolean> AUTO_PUSH_UPDATES = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("auto-push-updates", true));
    public static final ConfigKey<Boolean> PUSH_LOG_ENTRIES = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("push-log-entries", true));
    public static final ConfigKey<Boolean> BROADCAST_RECEIVED_LOG_ENTRIES = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("broadcast-received-log-entries", false));
    public static final ConfigKey<Boolean> REDIS_ENABLED = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("redis.enabled", false));
    public static final ConfigKey<String> REDIS_ADDRESS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.stringKey("redis.address", null));
    public static final ConfigKey<List<String>> REDIS_ADDRESSES = ConfigKeyFactory.notReloadable(ConfigKeyFactory.stringListKey("redis.addresses", (List<String>)ImmutableList.of()));
    public static final ConfigKey<String> REDIS_USERNAME = ConfigKeyFactory.notReloadable(ConfigKeyFactory.stringKey("redis.username", ""));
    public static final ConfigKey<String> REDIS_PASSWORD = ConfigKeyFactory.notReloadable(ConfigKeyFactory.stringKey("redis.password", ""));
    public static final ConfigKey<Boolean> REDIS_SSL = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("redis.ssl", false));
    public static final ConfigKey<Boolean> NATS_ENABLED = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("nats.enabled", false));
    public static final ConfigKey<String> NATS_ADDRESS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.stringKey("nats.address", null));
    public static final ConfigKey<String> NATS_USERNAME = ConfigKeyFactory.notReloadable(ConfigKeyFactory.stringKey("nats.username", ""));
    public static final ConfigKey<String> NATS_PASSWORD = ConfigKeyFactory.notReloadable(ConfigKeyFactory.stringKey("nats.password", ""));
    public static final ConfigKey<Boolean> NATS_SSL = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("nats.ssl", false));
    public static final ConfigKey<Boolean> RABBITMQ_ENABLED = ConfigKeyFactory.notReloadable(ConfigKeyFactory.booleanKey("rabbitmq.enabled", false));
    public static final ConfigKey<String> RABBITMQ_ADDRESS = ConfigKeyFactory.notReloadable(ConfigKeyFactory.stringKey("rabbitmq.address", null));
    public static final ConfigKey<String> RABBITMQ_VIRTUAL_HOST = ConfigKeyFactory.notReloadable(ConfigKeyFactory.stringKey("rabbitmq.vhost", "/"));
    public static final ConfigKey<String> RABBITMQ_USERNAME = ConfigKeyFactory.notReloadable(ConfigKeyFactory.stringKey("rabbitmq.username", "guest"));
    public static final ConfigKey<String> RABBITMQ_PASSWORD = ConfigKeyFactory.notReloadable(ConfigKeyFactory.stringKey("rabbitmq.password", "guest"));
    public static final ConfigKey<Boolean> EDITOR_LAZILY_GENERATE_KEY = ConfigKeyFactory.booleanKey("editor-lazily-generate-key", false);
    public static final ConfigKey<String> BYTEBIN_URL = ConfigKeyFactory.stringKey("bytebin-url", "https://usercontent.luckperms.net/");
    public static final ConfigKey<String> BYTESOCKS_HOST = ConfigKeyFactory.stringKey("bytesocks-host", "usersockets.luckperms.net");
    public static final ConfigKey<Boolean> BYTESOCKS_USE_TLS = ConfigKeyFactory.booleanKey("bytesocks-use-tls", true);
    public static final ConfigKey<String> WEB_EDITOR_URL_PATTERN = ConfigKeyFactory.stringKey("web-editor-url", "https://luckperms.net/editor/");
    public static final ConfigKey<String> VERBOSE_VIEWER_URL_PATTERN = ConfigKeyFactory.stringKey("verbose-viewer-url", "https://luckperms.net/verbose/");
    public static final ConfigKey<String> TREE_VIEWER_URL_PATTERN = ConfigKeyFactory.stringKey("tree-viewer-url", "https://luckperms.net/treeview/");
    private static final List<SimpleConfigKey<?>> KEYS = KeyedConfiguration.initialise(ConfigKeys.class);

    private ConfigKeys() {
    }

    public static List<? extends ConfigKey<?>> getKeys() {
        return KEYS;
    }
}

