/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.config.generic.adapter;

import java.util.Locale;
import me.lucko.luckperms.common.config.generic.adapter.StringBasedConfigurationAdapter;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnvironmentVariableConfigAdapter
extends StringBasedConfigurationAdapter {
    private static final String PREFIX = "LUCKPERMS_";
    private final LuckPermsPlugin plugin;

    public EnvironmentVariableConfigAdapter(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    protected @Nullable String resolveValue(String path) {
        String key = PREFIX + path.toUpperCase(Locale.ROOT).replace('-', '_').replace('.', '_');
        String value = System.getenv(key);
        if (value != null) {
            this.plugin.getLogger().info("Resolved configuration value from environment variable: " + key + " = " + (path.contains("password") ? "*****" : value));
        }
        return value;
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void reload() {
    }
}

