/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.inheritance;

import java.util.Comparator;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.User;

public class InheritanceComparator
implements Comparator<PermissionHolder> {
    private static final Comparator<PermissionHolder> NULL_ORIGIN = new InheritanceComparator(null).reversed();
    private final User origin;

    public static Comparator<? super PermissionHolder> getFor(PermissionHolder origin) {
        if (origin.getType() == HolderType.USER) {
            return new InheritanceComparator((User)origin).reversed();
        }
        return NULL_ORIGIN;
    }

    private InheritanceComparator(User origin) {
        this.origin = origin;
    }

    @Override
    public int compare(PermissionHolder o1, PermissionHolder o2) {
        boolean o2IsUser;
        boolean o1IsUser = o1.getType() == HolderType.USER;
        boolean bl = o2IsUser = o2.getType() == HolderType.USER;
        if (o1IsUser && o2IsUser) {
            return 0;
        }
        if (o1IsUser) {
            return 1;
        }
        if (o2IsUser) {
            return -1;
        }
        Group o1Group = (Group)o1;
        Group o2Group = (Group)o2;
        int result = Integer.compare(o1.getWeight().orElse(0), o2.getWeight().orElse(0));
        if (result != 0) {
            return result;
        }
        if (this.origin != null) {
            return Boolean.compare(o1Group.getName().equalsIgnoreCase(this.origin.getPrimaryGroup().getStoredValue().orElse("default")), o2Group.getName().equalsIgnoreCase(this.origin.getPrimaryGroup().getStoredValue().orElse("default")));
        }
        return 0;
    }
}

