/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model.manager.user;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.model.manager.AbstractManager;
import me.lucko.luckperms.common.model.manager.user.UserHousekeeper;
import me.lucko.luckperms.common.model.manager.user.UserManager;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.util.CompletableFutures;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;

public abstract class AbstractUserManager<T extends User>
extends AbstractManager<UUID, User, T>
implements UserManager<T> {
    private final LuckPermsPlugin plugin;
    private final UserHousekeeper housekeeper;

    public AbstractUserManager(LuckPermsPlugin plugin, UserHousekeeper.TimeoutSettings timeoutSettings) {
        this.plugin = plugin;
        this.housekeeper = new UserHousekeeper(plugin, this, timeoutSettings);
        this.plugin.getBootstrap().getScheduler().asyncRepeating(this.housekeeper, 30L, TimeUnit.SECONDS);
    }

    @Override
    public T getOrMake(UUID id, String username) {
        User user = (User)this.getOrMake(id);
        if (username != null) {
            user.setUsername(username, false);
        }
        return (T)user;
    }

    @Override
    public T getByUsername(String name) {
        for (User user : this.getAll().values()) {
            Optional<String> n = user.getUsername();
            if (!n.isPresent() || !n.get().equalsIgnoreCase(name)) continue;
            return (T)user;
        }
        return null;
    }

    @Override
    public boolean giveDefaultIfNeeded(User user) {
        boolean requireSave = false;
        Collection<InheritanceNode> globalGroups = user.normalData().inheritanceNodesInContext(ImmutableContextSetImpl.EMPTY);
        if (this.plugin.getConfiguration().get(ConfigKeys.PRIMARY_GROUP_CALCULATION_METHOD).equals("stored")) {
            String group;
            String primaryGroup = user.getCachedData().getMetaData(this.plugin.getConfiguration().get(ConfigKeys.GLOBAL_QUERY_OPTIONS)).getPrimaryGroup(CheckOrigin.INTERNAL);
            boolean memberOfPrimaryGroup = false;
            for (InheritanceNode node : globalGroups) {
                if (!node.getGroupName().equalsIgnoreCase(primaryGroup)) continue;
                memberOfPrimaryGroup = true;
                break;
            }
            if (!memberOfPrimaryGroup && (group = (String)globalGroups.stream().findFirst().map(InheritanceNode::getGroupName).orElse(null)) != null) {
                user.getPrimaryGroup().setStoredValue(group);
                requireSave = true;
            }
        }
        boolean hasGroup = false;
        if (user.getPrimaryGroup().getStoredValue().isPresent()) {
            boolean bl = hasGroup = !globalGroups.isEmpty();
        }
        if (!hasGroup) {
            user.getPrimaryGroup().setStoredValue("default");
            user.setNode(DataType.NORMAL, (Node)Inheritance.builder("default").build(), false);
            requireSave = true;
        }
        return requireSave;
    }

    @Override
    public boolean isNonDefaultUser(User user) {
        if (user.normalData().size() != 1) {
            return true;
        }
        List<Node> nodes = user.normalData().asList();
        if (nodes.size() != 1) {
            return true;
        }
        Node onlyNode = nodes.iterator().next();
        if (!this.isDefaultNode(onlyNode)) {
            return true;
        }
        return !user.getPrimaryGroup().getStoredValue().orElse("default").equalsIgnoreCase("default");
    }

    @Override
    public boolean isDefaultNode(Node node) {
        return node instanceof InheritanceNode && node.getValue() && !node.hasExpiry() && node.getContexts().isEmpty() && ((InheritanceNode)node).getGroupName().equalsIgnoreCase("default");
    }

    @Override
    public UserHousekeeper getHouseKeeper() {
        return this.housekeeper;
    }

    @Override
    public CompletableFuture<Void> loadAllUsers() {
        HashSet ids = new HashSet(this.getAll().keySet());
        ids.addAll(this.plugin.getBootstrap().getOnlinePlayers());
        return ids.stream().map(id -> this.plugin.getStorage().loadUser((UUID)id, null)).collect(CompletableFutures.collector());
    }

    @Override
    public void invalidateAllUserCaches() {
        this.getAll().values().forEach(u -> u.getCachedData().invalidate());
    }

    @Override
    public void invalidateAllPermissionCalculators() {
        this.getAll().values().forEach(u -> u.getCachedData().invalidatePermissionCalculators());
    }
}

