/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model.nodemap;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.lucko.luckperms.common.node.comparator.NodeWithContextComparator;
import me.lucko.luckperms.common.util.Difference;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.query.QueryOptions;

public interface NodeMap {
    public boolean isEmpty();

    public int size();

    default public List<Node> asList() {
        ArrayList<Node> list = new ArrayList<Node>();
        this.copyTo(list);
        return list;
    }

    default public LinkedHashSet<Node> asSet() {
        LinkedHashSet<Node> set = new LinkedHashSet<Node>();
        this.copyTo(set);
        return set;
    }

    default public SortedSet<Node> asSortedSet() {
        TreeSet<Node> set = new TreeSet<Node>(NodeWithContextComparator.reverse());
        this.copyTo(set);
        return set;
    }

    default public ImmutableSet<Node> asImmutableSet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.copyTo((ImmutableCollection.Builder<? super Node>)builder);
        return builder.build();
    }

    public Map<ImmutableContextSet, Collection<Node>> asMap();

    default public List<InheritanceNode> inheritanceAsList() {
        ArrayList<InheritanceNode> set = new ArrayList<InheritanceNode>();
        this.copyInheritanceNodesTo(set);
        return set;
    }

    default public LinkedHashSet<InheritanceNode> inheritanceAsSet() {
        LinkedHashSet<InheritanceNode> set = new LinkedHashSet<InheritanceNode>();
        this.copyInheritanceNodesTo(set);
        return set;
    }

    default public SortedSet<InheritanceNode> inheritanceAsSortedSet() {
        TreeSet<? super Node> set = new TreeSet<Node>(NodeWithContextComparator.reverse());
        this.copyInheritanceNodesTo(set);
        return set;
    }

    default public ImmutableSet<InheritanceNode> inheritanceAsImmutableSet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.copyInheritanceNodesTo((ImmutableCollection.Builder<? super InheritanceNode>)builder);
        return builder.build();
    }

    public Map<ImmutableContextSet, Collection<InheritanceNode>> inheritanceAsMap();

    public void forEach(Consumer<? super Node> var1);

    public void forEach(QueryOptions var1, Consumer<? super Node> var2);

    public void copyTo(Collection<? super Node> var1);

    public void copyTo(ImmutableCollection.Builder<? super Node> var1);

    public void copyTo(Collection<? super Node> var1, QueryOptions var2);

    public <T extends Node> void copyTo(Collection<? super T> var1, NodeType<T> var2, QueryOptions var3);

    public void copyInheritanceNodesTo(Collection<? super InheritanceNode> var1);

    public void copyInheritanceNodesTo(ImmutableCollection.Builder<? super InheritanceNode> var1);

    public void copyInheritanceNodesTo(Collection<? super InheritanceNode> var1, QueryOptions var2);

    public Collection<Node> nodesInContext(ContextSet var1);

    public Collection<InheritanceNode> inheritanceNodesInContext(ContextSet var1);

    public Difference<Node> add(Node var1);

    public Difference<Node> remove(Node var1);

    public Difference<Node> removeExact(Node var1);

    public Difference<Node> removeIf(Predicate<? super Node> var1);

    public Difference<Node> removeIf(ContextSet var1, Predicate<? super Node> var2);

    public Difference<Node> removeThenAdd(Node var1, Node var2);

    public Difference<Node> clear();

    public Difference<Node> clear(ContextSet var1);

    public Difference<Node> setContent(Iterable<? extends Node> var1);

    public Difference<Node> setContent(Stream<? extends Node> var1);

    public Difference<Node> applyChanges(Difference<Node> var1);

    public Difference<Node> addAll(Iterable<? extends Node> var1);

    public Difference<Node> addAll(Stream<? extends Node> var1);
}

