/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.types;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import me.lucko.luckperms.common.node.AbstractNode;
import me.lucko.luckperms.common.node.AbstractNodeBuilder;
import me.lucko.luckperms.common.node.factory.Delimiters;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.metadata.NodeMetadataKey;
import net.luckperms.api.node.types.PrefixNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Prefix
extends AbstractNode<PrefixNode, PrefixNode.Builder>
implements PrefixNode {
    public static final String NODE_KEY = "prefix";
    public static final String NODE_MARKER = "prefix.";
    private final String prefix;
    private final int priority;

    public static String key(int priority, String prefix) {
        return NODE_MARKER + priority + '.' + Delimiters.escapeCharacters(prefix);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String prefix, int priority) {
        return Prefix.builder().prefix(prefix).priority(priority);
    }

    public Prefix(String prefix, int priority, boolean value, long expireAt, ImmutableContextSet contexts, Map<NodeMetadataKey<?>, Object> metadata) {
        super(Prefix.key(priority, prefix), value, expireAt, contexts, metadata);
        this.prefix = prefix;
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public @NonNull String getMetaValue() {
        return this.prefix;
    }

    @Override
    public @NonNull ChatMetaType getMetaType() {
        return ChatMetaType.PREFIX;
    }

    @Override
    public @NonNull Builder toBuilder() {
        return new Builder(this.prefix, this.priority, this.value, this.expireAt, this.contexts, this.metadata);
    }

    public static @Nullable Builder parse(String key) {
        if (!key.toLowerCase(Locale.ROOT).startsWith(NODE_MARKER)) {
            return null;
        }
        Iterator metaParts = Delimiters.SPLIT_BY_NODE_SEPARATOR_IN_TWO.split((CharSequence)key.substring(NODE_MARKER.length())).iterator();
        if (!metaParts.hasNext()) {
            return null;
        }
        String priority = (String)metaParts.next();
        if (!metaParts.hasNext()) {
            return null;
        }
        String value = (String)metaParts.next();
        try {
            return Prefix.builder().priority(Integer.parseInt(priority)).prefix(Delimiters.unescapeCharacters(value));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static final class Builder
    extends AbstractNodeBuilder<PrefixNode, PrefixNode.Builder>
    implements PrefixNode.Builder {
        private String prefix;
        private Integer priority;

        private Builder() {
            this.prefix = null;
            this.priority = null;
        }

        public Builder(String prefix, int priority, boolean value, long expireAt, ImmutableContextSet context, Map<NodeMetadataKey<?>, Object> metadata) {
            super(value, expireAt, context, metadata);
            this.prefix = prefix;
            this.priority = priority;
        }

        @Override
        public @NonNull Builder prefix(@NonNull String prefix) {
            this.prefix = Objects.requireNonNull(prefix, Prefix.NODE_KEY);
            return this;
        }

        @Override
        public @NonNull Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public @NonNull Prefix build() {
            Builder.ensureDefined(this.prefix, Prefix.NODE_KEY);
            Builder.ensureDefined(this.priority, "priority");
            return new Prefix(this.prefix, this.priority, this.value, this.expireAt, this.context.build(), this.metadata);
        }
    }
}

