/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.query;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.common.query.FlagUtils;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.query.Flag;
import net.luckperms.api.query.OptionKey;
import net.luckperms.api.query.QueryMode;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class QueryOptionsBuilderImpl
implements QueryOptions.Builder {
    private QueryMode mode;
    private ImmutableContextSet context;
    private final byte flags;
    private Set<Flag> flagsSet;
    private Map<OptionKey<?>, Object> options;
    private boolean copyOptions;

    public QueryOptionsBuilderImpl(QueryMode mode) {
        this.mode = mode;
        this.context = mode == QueryMode.CONTEXTUAL ? ImmutableContextSetImpl.EMPTY : null;
        this.flags = FlagUtils.ALL_FLAGS;
        this.flagsSet = null;
        this.options = null;
        this.copyOptions = false;
    }

    QueryOptionsBuilderImpl(QueryMode mode, ImmutableContextSet context, byte flags, Map<OptionKey<?>, Object> options) {
        this.mode = mode;
        this.context = context;
        this.flags = flags;
        this.flagsSet = null;
        this.options = options;
        this.copyOptions = true;
    }

    @Override
    public @NonNull QueryOptions.Builder mode(@NonNull QueryMode mode) {
        if (this.mode == mode) {
            return this;
        }
        this.mode = mode;
        this.context = this.mode == QueryMode.CONTEXTUAL ? ImmutableContextSetImpl.EMPTY : null;
        return this;
    }

    @Override
    public @NonNull QueryOptions.Builder context(@NonNull ContextSet context) {
        if (this.mode != QueryMode.CONTEXTUAL) {
            throw new IllegalStateException("Mode is not CONTEXTUAL");
        }
        this.context = Objects.requireNonNull(context, "context").immutableCopy();
        return this;
    }

    @Override
    public @NonNull QueryOptions.Builder flag(@NonNull Flag flag, boolean value) {
        Objects.requireNonNull(flag, "flag");
        if (this.flagsSet == null && FlagUtils.read(this.flags, flag) == value) {
            return this;
        }
        if (this.flagsSet == null) {
            this.flagsSet = FlagUtils.toSet(this.flags);
        }
        if (value) {
            this.flagsSet.add(flag);
        } else {
            this.flagsSet.remove((Object)flag);
        }
        return this;
    }

    @Override
    public @NonNull QueryOptions.Builder flags(@NonNull Set<Flag> flags) {
        Objects.requireNonNull(flags, "flags");
        this.flagsSet = EnumSet.copyOf(flags);
        return this;
    }

    @Override
    public <O> @NonNull QueryOptions.Builder option(@NonNull OptionKey<O> key, @Nullable O value) {
        Objects.requireNonNull(key, "key");
        if (this.options == null || this.copyOptions) {
            this.options = this.options != null ? new HashMap(this.options) : new HashMap();
            this.copyOptions = false;
        }
        if (value == null) {
            this.options.remove(key);
        } else {
            this.options.put(key, value);
        }
        if (this.options.isEmpty()) {
            this.options = null;
        }
        return this;
    }

    @Override
    public @NonNull QueryOptions build() {
        byte flags;
        byte by = flags = this.flagsSet != null ? FlagUtils.toByte(this.flagsSet) : this.flags;
        if (this.options == null) {
            if (this.mode == QueryMode.NON_CONTEXTUAL) {
                if (FlagUtils.ALL_FLAGS == flags) {
                    return QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL;
                }
            } else if (this.mode == QueryMode.CONTEXTUAL && FlagUtils.ALL_FLAGS == flags && this.context.isEmpty()) {
                return QueryOptionsImpl.DEFAULT_CONTEXTUAL;
            }
        }
        return new QueryOptionsImpl(this.mode, this.context, flags, this.options);
    }
}

