/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import me.lucko.luckperms.common.storage.implementation.sql.connection.ConnectionFactory;
import me.lucko.luckperms.common.storage.implementation.sql.connection.file.NonClosableConnection;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.format.NamedTextColor;
import me.lucko.luckperms.lib.adventure.text.format.TextColor;

abstract class FlatfileConnectionFactory
implements ConnectionFactory {
    protected static final DecimalFormat FILE_SIZE_FORMAT = new DecimalFormat("#.##");
    private NonClosableConnection connection;
    private final Path file;

    FlatfileConnectionFactory(Path file) {
        this.file = file;
    }

    protected abstract Connection createConnection(Path var1) throws SQLException;

    @Override
    public synchronized Connection getConnection() throws SQLException {
        NonClosableConnection connection = this.connection;
        if (connection == null || connection.isClosed()) {
            this.connection = connection = new NonClosableConnection(this.createConnection(this.file));
        }
        return connection;
    }

    @Override
    public void shutdown() throws Exception {
        if (this.connection != null) {
            this.connection.shutdown();
        }
    }

    protected Path getWriteFile() {
        return this.file;
    }

    protected void migrateOldDatabaseFile(String oldName) {
        Path oldFile = this.getWriteFile().getParent().resolve(oldName);
        if (Files.exists(oldFile, new LinkOption[0])) {
            try {
                Files.move(oldFile, this.getWriteFile(), new CopyOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Map<Component, Component> getMeta() {
        String fileSize;
        Path databaseFile = this.getWriteFile();
        if (Files.exists(databaseFile, new LinkOption[0])) {
            long length;
            try {
                length = Files.size(databaseFile);
            }
            catch (IOException e) {
                length = 0L;
            }
            double size = (double)length / 1048576.0;
            fileSize = FILE_SIZE_FORMAT.format(size) + "MB";
        } else {
            fileSize = "0MB";
        }
        LinkedHashMap<Component, Component> meta = new LinkedHashMap<Component, Component>();
        meta.put((Component)Component.translatable((String)"luckperms.command.info.storage.meta.file-size-key"), (Component)Component.text((String)fileSize, (TextColor)NamedTextColor.GREEN));
        return meta;
    }
}

